/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.command;

import com.kt.gui.event.CallBackListener;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.kitec.kwt.IContextMenu;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KContextMenu;
import nethome.ui.command.Command;
import nethome.ui.command.ICommandInfo;
import option.gad.core.util.SetNotNullDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GdCompositeCommand
extends Command {
    private static final Log mLog = LogFactory.getLog(GdCompositeCommand.class);
    private Set<Command> mCommandSet = new SetNotNullDecorator(new LinkedHashSet());

    public GdCompositeCommand() {
    }

    public GdCompositeCommand(Command ... commandArray) {
        this.mCommandSet.addAll(Arrays.asList(commandArray));
    }

    public GdCompositeCommand add(Command command) {
        this.mCommandSet.add(command);
        return this;
    }

    public GdCompositeCommand addAll(Collection<Command> collection) {
        this.mCommandSet.addAll(collection);
        return this;
    }

    public void remove(Command command) {
        this.mCommandSet.remove(command);
    }

    public void clear() {
        this.mCommandSet.clear();
    }

    public <T extends Command> T findCommand(Class<T> clazz) {
        Command command = null;
        for (Command command2 : this.mCommandSet) {
            if (!clazz.isInstance(command2)) continue;
            command = command2;
            break;
        }
        return (T)command;
    }

    public void play() {
        for (Command command : this.mCommandSet) {
            command.play();
        }
    }

    public void accelerate() {
        for (Command command : this.mCommandSet) {
            command.accelerate();
        }
    }

    public void drawCommand(IRichGraphics iRichGraphics) {
        for (Command command : this.mCommandSet) {
            command.drawCommand(iRichGraphics);
        }
    }

    public void end() {
        for (Command command : this.mCommandSet) {
            command.end();
        }
    }

    public void frameClosing() {
        for (Command command : this.mCommandSet) {
            command.frameClosing();
        }
    }

    public void initInterface() {
        for (Command command : this.mCommandSet) {
            command.initInterface();
        }
    }

    public void restoration() {
        for (Command command : this.mCommandSet) {
            command.restoration();
        }
    }

    public boolean keyPress(int n, int n2) {
        boolean bl = false;
        for (Command command : this.mCommandSet) {
            bl |= command.keyPress(n, n2);
        }
        return bl;
    }

    public void keyReleased(int n) {
        for (Command command : this.mCommandSet) {
            command.keyReleased(n);
        }
    }

    public void mouseDoubleClicked(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.mouseDoubleClicked(n, n2, n3);
        }
    }

    public void mouseDrag(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.mouseDrag(n, n2, n3);
        }
    }

    public void mouseMove(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.mouseMove(n, n2, n3);
        }
    }

    public void mousePress(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.mousePress(n, n2, n3);
        }
    }

    public void mouseRelease(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.mouseRelease(n, n2, n3);
        }
    }

    public void updateInterface() {
        for (Command command : this.mCommandSet) {
            command.updateInterface();
        }
    }

    public void wheelDown(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.wheelDown(n, n2, n3);
        }
    }

    public void wheelUp(int n, int n2, int n3) {
        for (Command command : this.mCommandSet) {
            command.wheelUp(n, n2, n3);
        }
    }

    public void addCallBackListener(CallBackListener callBackListener) {
        throw new UnsupportedOperationException();
    }

    public Component createComponent(ICommandInfo iCommandInfo) {
        throw new UnsupportedOperationException();
    }

    public ICommandInfo getCommandInfo() {
        throw new UnsupportedOperationException();
    }

    public Component getComponent() {
        throw new UnsupportedOperationException();
    }

    public KContextMenu getContextMenu() {
        throw new UnsupportedOperationException();
    }

    public void setComponent(Component component) {
        throw new UnsupportedOperationException();
    }

    public void setContextMenu(IContextMenu iContextMenu) {
        throw new UnsupportedOperationException();
    }

    public void setContinue(boolean bl) {
        throw new UnsupportedOperationException();
    }
}

