/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.command;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.kitec.kwt.KContextMenu;
import jp.kitec.kwt.KCursor;
import jp.kitec.kwt.KKeyEvent;
import jp.kitec.kwt.KMouseEvent;
import jp.kitec.kwt.KPopupMenu;
import nethome.NethomeResource;
import nethome.doc.Layer;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IChildGeometorys;
import nethome.geom.util.ToolMathEx;
import nethome.ui.MainComponent;
import option.gad.client.command.GdCommand;
import option.gad.client.command.GdSubComMoveControlPoint;
import option.gad.client.command.GdSubCommand;
import option.gad.client.doc.GdLayer;
import option.gad.client.doc.GdProject;
import option.gad.client.geom.primitive.GdGeometry;
import option.gad.client.gui.GdCanvas2D;
import option.gad.client.util.GdGeomUtil;
import option.gad.client.util.NetHomeUtil;

public class GdComSelector
extends GdCommand {
    private static KCursor DEF = KCursor.getCursor((int)0);
    public KContextMenu mConDel;
    public KContextMenu mConEnv;
    public KContextMenu mConCan;
    public KContextMenu mConRelSel;
    protected Geometory mCursorGeom = null;
    protected GPoint2Df mCursorControlPoint;
    protected Geometory mCursorControlPointParent;
    protected int mPresX;
    protected int mPresY;
    protected boolean mNowPress = false;
    protected GdSubCommand<?> mSubCommand;
    protected GdSubCommand<?> mSubMovePoint;
    protected ArrayList<GdSubCommand<?>> mSubCommandList = new ArrayList();

    public GdComSelector() {
        this.createContextMenu();
        this.mSubMovePoint = new GdSubComMoveControlPoint();
        this.mSubCommandList.addAll(this.configSubCommandList());
    }

    protected List<GdSubCommand<?>> configSubCommandList() {
        return new ArrayList();
    }

    @Override
    protected void doPlay() {
        Point point = this.mCan.getCurrentMousePos();
        this.mouseMove(point.x, point.y, 0);
    }

    @Override
    protected void doEnd() {
        this.clear();
    }

    @Override
    protected void doMouseDrag(int n, int n2, int n3) {
        if (!this.mNowPress) {
            return;
        }
        if (this.mSubCommand != null) {
            if (!this.mSubCommand.mouseDrag(n, n2, n3)) {
                this.mSubCommand = null;
                return;
            }
        } else {
            this.setUpSubCommand(n, n2);
        }
    }

    @Override
    protected void doMousePress(int n, int n2, int n3) {
        this.mNowPress = true;
        this.setUpSubCommand(n, n2);
        if (this.mSubCommand != null && !this.mSubCommand.mousePress(n, n2, n3)) {
            this.mSubCommand = null;
            return;
        }
        if (this.mCursorControlPoint != null) {
            return;
        }
        if (this.mCan.isShowContext()) {
            this.mCan.endContext();
            this.mouseMove(n, n2, n3);
            this.mPresX = n;
            this.mPresY = n2;
        }
        boolean bl = KMouseEvent.isShiftButtonMask((int)n3);
        if (this.mCursorGeom != null) {
            if (bl) {
                if (this.mLayer.getSelectBuffer().contains(this.mCursorGeom)) {
                    this.mLayer.getSelectBuffer().remove(this.mCursorGeom);
                } else {
                    this.mLayer.getSelectBuffer().add(this.mCursorGeom);
                }
            } else if (!this.mLayer.getSelectBuffer().contains(this.mCursorGeom)) {
                this.mLayer.getSelectBuffer().clear();
                this.mLayer.getSelectBuffer().add(this.mCursorGeom);
            }
        } else if (!bl) {
            this.mLayer.getSelectBuffer().clear();
        }
        this.mMc.updateUserInterface();
        Graphics graphics = this.mCan.getGraphics();
        this.mCan.update(graphics);
        graphics.dispose();
        if (KMouseEvent.isRightButtonMask((int)n3)) {
            this.mCursorGeom = null;
            this.mCan.repaint();
            KPopupMenu kPopupMenu = this.mCan.getPopupMenu();
            this.updateContext(kPopupMenu);
            if (kPopupMenu.getItemCount() != 0) {
                this.mCan.showContext(n, n2);
            }
        } else {
            this.mPresX = n;
            this.mPresY = n2;
        }
    }

    @Override
    protected void doMouseDoubleClicked(int n, int n2, int n3) {
        block3: {
            block2: {
                this.mNowPress = true;
                boolean bl = KMouseEvent.isShiftButtonMask((int)n3);
                if (bl || this.mConEnv == null) break block2;
                this.mMc.updateUserInterface();
                if (!this.mConEnv.isEnabled()) break block3;
                this.mConEnv.performAction();
                break block3;
            }
            if (this.mCursorGeom != null) {
                for (GdSubCommand<?> gdSubCommand : this.mSubCommandList) {
                    if (!gdSubCommand.isTarget(this.mCursorGeom)) continue;
                    gdSubCommand.setTarget(this.mCursorGeom, null, (short)0, (short)0);
                    gdSubCommand.mouseDoubleClicked(n, n2, n3);
                    break;
                }
            }
        }
        this.mNowPress = false;
    }

    @Override
    protected void doMouseRelease(int n, int n2, int n3) {
        this.mNowPress = false;
        if (this.mSubCommand != null && !this.mSubCommand.mouseRelease(n, n2, n3)) {
            this.mSubCommand = null;
            return;
        }
    }

    @Override
    protected void doMouseMove(int n, int n2, int n3) {
        Geometory geometory;
        if (this.mSubCommand != null && !this.mSubCommand.mouseMove(n, n2, n3)) {
            this.mSubCommand = null;
            return;
        }
        float f = this.mCan.mAbstCanvas.devToRealX(n);
        float f2 = this.mCan.mAbstCanvas.devToRealY(n2);
        boolean bl = false;
        GPoint2Df gPoint2Df = this.mCursorControlPoint;
        Geometory geometory2 = this.getNearControlPoint(f, f2);
        if (gPoint2Df != geometory2) {
            bl = true;
        }
        if ((geometory = this.getElement(f, f2)) != this.mCursorGeom) {
            this.mCursorGeom = geometory;
            bl = true;
        }
        this.setCursor(null);
        if (bl) {
            this.mCan.repaint();
        }
    }

    protected Geometory getElement(float f, float f2) {
        GdCanvas2D gdCanvas2D = (GdCanvas2D)((Object)NetHomeUtil.getActiveCanvas());
        if (gdCanvas2D == null) {
            return null;
        }
        GdLayer gdLayer = (GdLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdLayer == null) {
            return null;
        }
        NearGeomInfo nearGeomInfo = new NearGeomInfo();
        nearGeomInfo.minimum = Float.POSITIVE_INFINITY;
        nearGeomInfo.minGeom = null;
        ArrayList<Geometory> arrayList = new ArrayList<Geometory>(GdGeomUtil.collectGeometry(gdLayer.getGeometryList()));
        GdGeomUtil.sortGeometryByPriorityDesc(arrayList);
        for (Geometory geometory : arrayList) {
            if (geometory == null || !this.isGetElementTarget(geometory)) continue;
            this.checkNearGeomDispatcher(f, f2, nearGeomInfo, geometory);
            if (!nearGeomInfo.exit) continue;
            return nearGeomInfo.minGeom;
        }
        if (nearGeomInfo.minGeom != null) {
            float f3 = nearGeomInfo.minGeom.getDistanceToPoint(f, f2);
            float f4 = 15.0f / gdCanvas2D.mAbstCanvas.mDotPerLen;
            if (!Float.isInfinite(f4) && f3 < f4) {
                return nearGeomInfo.minGeom;
            }
        }
        return null;
    }

    protected boolean isGetElementTarget(Geometory geometory) {
        GdGeometry gdGeometry;
        return !(geometory instanceof GdGeometry) || (gdGeometry = (GdGeometry)geometory).isEnabled();
    }

    protected void checkNearGeomDispatcher(float f, float f2, NearGeomInfo nearGeomInfo, Geometory geometory) {
        if (geometory instanceof GdGeometry && !((GdGeometry)geometory).isVisible()) {
            return;
        }
        this.checkNearGeom(f, f2, nearGeomInfo, geometory);
    }

    protected void checkNearGeom(float f, float f2, NearGeomInfo nearGeomInfo, IChildGeometorys iChildGeometorys) {
        Vector vector = iChildGeometorys.getChildGeometorys();
        GdGeomUtil.sortGeometryByPriorityDesc(vector);
        if (vector != null) {
            for (Geometory geometory : vector) {
                this.checkNearGeom(f, f2, nearGeomInfo, geometory);
                if (!nearGeomInfo.exit) continue;
                return;
            }
        }
    }

    protected void checkNearGeom(float f, float f2, NearGeomInfo nearGeomInfo, Geometory geometory) {
        float f3 = geometory.getDistanceToPoint(f, f2);
        if (f3 < 0.0f) {
            return;
        }
        int n = 0;
        if (geometory instanceof GdGeometry) {
            n = ((GdGeometry)geometory).getPriority();
        }
        if (n < nearGeomInfo.priority) {
            return;
        }
        if (f3 < nearGeomInfo.minimum) {
            nearGeomInfo.priority = n;
            nearGeomInfo.minimum = f3;
            nearGeomInfo.minGeom = geometory;
            if (f3 == 0.0f) {
                nearGeomInfo.exit = true;
            }
        }
    }

    protected Geometory getNearControlPoint(float f, float f2) {
        this.mCursorControlPoint = null;
        this.mCursorControlPointParent = null;
        GdCanvas2D gdCanvas2D = (GdCanvas2D)((Object)NetHomeUtil.getActiveCanvas());
        if (gdCanvas2D == null) {
            return null;
        }
        GdLayer gdLayer = (GdLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdLayer == null) {
            return null;
        }
        Vector vector = gdLayer.getSelectBuffer();
        GdGeomUtil.sortGeometryByPriorityDesc(vector);
        double d = 3.4028234663852886E38;
        int n = 0;
        while (n < vector.size()) {
            Geometory geometory = (Geometory)vector.get(vector.size() - n - 1);
            Object object = geometory.getNearControlPoint(f, f2);
            if (object != null && object instanceof GPoint2Df) {
                GPoint2Df gPoint2Df = (GPoint2Df)object;
                double d2 = ToolMathEx.getLength2D((double)gPoint2Df.x, (double)gPoint2Df.y, (double)f, (double)f2);
                if (d2 < d) {
                    d = d2;
                }
            }
            ++n;
        }
        return this.mCursorControlPoint;
    }

    @Override
    protected void doRestoration() {
        this.clear();
    }

    protected void clear() {
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        this.mSubCommand = null;
        this.mCursorGeom = null;
        mainComponent.updateUserInterface();
        t.repaint();
    }

    protected void delete() {
        this.mConDel.performAction();
    }

    protected void escape() {
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        Layer layer = t.getProject().getCurrentLayer();
        if (layer.getSelectBuffer().size() > 0) {
            layer.clearSelectBuffer();
            this.clear();
        }
        t.repaint();
    }

    protected void updateContext(KPopupMenu kPopupMenu) {
        GdCanvas2D gdCanvas2D = (GdCanvas2D)((Object)NetHomeUtil.getActiveCanvas());
        if (gdCanvas2D == null) {
            return;
        }
        Object t = NetHomeUtil.getCurrentLayer();
        kPopupMenu.removeAll();
        int n = t.getSelectBuffer().size();
        if (n != 0 && n >= 1) {
            if (this.mConEnv != null) {
                kPopupMenu.add(this.mConEnv);
            }
            if (this.mConDel != null) {
                if (this.mConEnv != null) {
                    kPopupMenu.addSeparator();
                }
                kPopupMenu.add(this.mConDel);
            }
        }
        if (kPopupMenu.getItemCount() != 0) {
            kPopupMenu.addSeparator();
        }
        kPopupMenu.add(this.mConCan);
        if (n != 0) {
            kPopupMenu.add(this.mConRelSel);
        }
    }

    @Override
    protected void doAccelerate() {
        this.mCan.setMouseCommand(this);
        this.play();
    }

    protected void createContextMenu() {
        this.createCancelContextMenu();
        this.createReleaseContextMenu();
    }

    protected void createCancelContextMenu() {
        this.mConCan = new KContextMenu("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.mConCan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object t = NetHomeUtil.getActiveCanvas();
                if (t == null) {
                    return;
                }
                t.setMouseCommand(null);
                t.endContext();
                GdComSelector.this.updateInterface();
            }
        });
    }

    protected void createReleaseContextMenu() {
        this.mConRelSel = new KContextMenu(NethomeResource.getTextResource((String)"mes.edit.release"));
        this.mConRelSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GdCanvas2D gdCanvas2D = (GdCanvas2D)((Object)NetHomeUtil.getActiveCanvas());
                if (gdCanvas2D == null) {
                    return;
                }
                GdProject gdProject = (GdProject)((Object)NetHomeUtil.getProject());
                gdProject.getCurrentLayer().clearSelectBuffer();
                gdCanvas2D.endContext();
                GdComSelector.this.clear();
                gdCanvas2D.repaint();
            }
        });
    }

    @Override
    protected boolean doKeyPress(int n, int n2) {
        if (KKeyEvent.isMutchKey((int)n, (String)"ESCAPE")) {
            this.escape();
        } else if (KKeyEvent.isMutchKey((int)n, (String)"DELETE")) {
            this.delete();
        } else {
            return false;
        }
        this.clear();
        this.mouseMove(this.mCan.getCurrentMousePos().x, this.mCan.getCurrentMousePos().y, 0);
        return false;
    }

    protected void setCursor(Cursor cursor) {
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        if (cursor == null) {
            cursor = DEF;
        }
        t.setCursor(cursor);
    }

    protected void setUpSubCommand(int n, int n2) {
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        if (Math.abs(this.mPresX - n) <= 3 && Math.abs(this.mPresY - n2) <= 3) {
            return;
        }
        if (this.mCursorControlPoint != null && this.mCursorControlPointParent != null) {
            this.mSubCommand = this.mSubMovePoint;
            this.mSubCommand.setTarget(this.mCursorControlPoint, this.mCursorControlPointParent, (short)0, (short)0);
        } else if (this.mCursorGeom != null) {
            for (GdSubCommand<?> gdSubCommand : this.mSubCommandList) {
                if (!gdSubCommand.isTarget(this.mCursorGeom)) continue;
                gdSubCommand.setTarget(this.mCursorGeom, null, (short)0, (short)0);
                this.mSubCommand = gdSubCommand;
                break;
            }
        }
    }

    protected class NearGeomInfo {
        public boolean exit = false;
        public int priority;
        public float minimum;
        public Geometory minGeom;

        protected NearGeomInfo() {
        }
    }
}

