/*
 * Decompiled with CFR 0.152.
 */
package option.danran.service.material;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import java.util.List;
import option.danran.entity.TerraceInfo;
import option.danran.type.EnforcementType;
import option.danran.type.TerraceDepthType;
import option.danran.type.TerraceWidthType;

@Reflectable
public class TerraceCommonService {
    public TerraceInfo findMasterTerraceInfo(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsMaster.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findTerraceInfoByIndex(LinkedList<TerraceInfo> linkedList, int n) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    public boolean isRentou(LinkedList<TerraceInfo> linkedList) {
        return linkedList.size() > 1;
    }

    public TerraceInfo findLeftEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findRightEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsRightEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceDepthType judgeLeftOptionDepthType(TerraceInfo terraceInfo) {
        float f = terraceInfo.mLeftDepth.floatValue();
        if (terraceInfo.mEnforcementType == EnforcementType.PARTIAL_IRISUMI_L) {
            f += 47.0f;
        }
        TerraceDepthType[] terraceDepthTypeArray = TerraceDepthType.values();
        int n = terraceDepthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceDepthType terraceDepthType = terraceDepthTypeArray[n2];
            if (f == terraceDepthType.mDetailValue) {
                return terraceDepthType;
            }
            ++n2;
        }
        return null;
    }

    public TerraceDepthType judgeRightOptionDepthType(TerraceInfo terraceInfo) {
        float f = terraceInfo.mRightDepth.floatValue();
        if (terraceInfo.mEnforcementType == EnforcementType.PARTIAL_IRISUMI_R) {
            f += 47.0f;
        }
        TerraceDepthType[] terraceDepthTypeArray = TerraceDepthType.values();
        int n = terraceDepthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceDepthType terraceDepthType = terraceDepthTypeArray[n2];
            if (f == terraceDepthType.mDetailValue) {
                return terraceDepthType;
            }
            ++n2;
        }
        return null;
    }

    public boolean existTerraceWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }
}

