/*
 * Decompiled with CFR 0.152.
 */
package option.danran.service.material;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import option.danran.entity.PanelInfo;
import option.danran.entity.TerraceInfo;
import option.danran.type.KoshikabeType;
import option.danran.type.PanelPartsType;

@Reflectable
public class FrontPanelCommonService {
    public LinkedList<LinkedList<PanelInfo>> splitPanelsIntoSegmentList(LinkedList<TerraceInfo> linkedList, LinkedList<PanelInfo> linkedList2) {
        LinkedList<LinkedList<PanelInfo>> linkedList3 = new LinkedList<LinkedList<PanelInfo>>();
        for (TerraceInfo terraceInfo : linkedList) {
            linkedList3.addAll(this.splitPanelsIntoSegmentList(terraceInfo, linkedList2));
        }
        return linkedList3;
    }

    public LinkedList<LinkedList<PanelInfo>> splitPanelsIntoSegmentList(TerraceInfo terraceInfo, LinkedList<PanelInfo> linkedList) {
        LinkedList<LinkedList<PanelInfo>> linkedList2 = new LinkedList<LinkedList<PanelInfo>>();
        int n = terraceInfo.mMiddlePillarPosition == null ? 0 : terraceInfo.mMiddlePillarPosition * 2;
        boolean bl = false;
        LinkedList<PanelInfo> linkedList3 = new LinkedList<PanelInfo>();
        LinkedList<PanelInfo> linkedList4 = this.findFrontPanelInfoByTerraceId(linkedList, terraceInfo.mId);
        for (PanelInfo panelInfo : linkedList4) {
            if (n != 0 && !bl && panelInfo.mIndex >= n) {
                linkedList2.add(linkedList3);
                linkedList3 = new LinkedList();
                bl = true;
            }
            linkedList3.add(panelInfo);
        }
        linkedList2.add(linkedList3);
        return linkedList2;
    }

    public LinkedList<PanelInfo> findFrontPanelInfoByTerraceId(LinkedList<PanelInfo> linkedList, Integer n) {
        LinkedList<PanelInfo> linkedList2 = new LinkedList<PanelInfo>();
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mTerraceId != n) continue;
            linkedList2.add(panelInfo);
        }
        return linkedList2;
    }

    public int findSegmentIndex(PanelInfo panelInfo, LinkedList<LinkedList<PanelInfo>> linkedList) {
        int n = 0;
        for (LinkedList linkedList2 : linkedList) {
            for (PanelInfo panelInfo2 : linkedList2) {
                if (panelInfo2 != panelInfo) continue;
                return n;
            }
            ++n;
        }
        return n;
    }

    public LinkedList<PanelInfo> findPanelsInSegment(PanelInfo panelInfo, LinkedList<LinkedList<PanelInfo>> linkedList) {
        int n = this.findSegmentIndex(panelInfo, linkedList);
        return linkedList.get(n);
    }

    public KoshikabeType judgeAllKoshikabe(LinkedList<PanelInfo> linkedList) {
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mLowerPanelType == PanelPartsType.KOSHIKABE) continue;
            return KoshikabeType.STANDARD;
        }
        return KoshikabeType.KOSHIKABE;
    }

    public KoshikabeType judgeKoshikabe(LinkedList<PanelInfo> linkedList) {
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mLowerPanelType != PanelPartsType.KOSHIKABE) continue;
            return KoshikabeType.KOSHIKABE;
        }
        return KoshikabeType.STANDARD;
    }

    public boolean judgePartialKoshikabe(LinkedList<PanelInfo> linkedList) {
        return this.judgePartialKoshikabe(null, linkedList);
    }

    public boolean judgePartialKoshikabe(TerraceInfo terraceInfo, LinkedList<PanelInfo> linkedList) {
        boolean bl = false;
        boolean bl2 = false;
        for (PanelInfo panelInfo : linkedList) {
            if (terraceInfo != null && panelInfo.mTerraceId != terraceInfo.mId) continue;
            if (panelInfo.mLowerPanelType == PanelPartsType.KOSHIKABE) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    public float calcTotalWidth(LinkedList<PanelInfo> linkedList) {
        float f = 0.0f;
        for (PanelInfo panelInfo : linkedList) {
            f += panelInfo.mWidth.floatValue();
        }
        return f;
    }

    public float calcKoshikabePanelWidth(TerraceInfo terraceInfo, LinkedList<PanelInfo> linkedList, KoshikabeType koshikabeType) {
        LinkedList<LinkedList<PanelInfo>> linkedList2 = this.splitPanelsIntoSegmentList(terraceInfo, linkedList);
        float f = 0.0f;
        int n = 0;
        for (LinkedList linkedList3 : linkedList2) {
            if (this.judgeKoshikabe(linkedList3) != koshikabeType) continue;
            f += this.calcTotalWidth(linkedList3);
            ++n;
        }
        if (n >= 2) {
            f += this.getMiddlePillarWidth();
        }
        return f;
    }

    public float getMainPillarWidth() {
        return 105.0f;
    }

    public float getMiddlePillarWidth() {
        return 212.0f;
    }

    public float calcPanelPosition(TerraceInfo terraceInfo, int n, LinkedList<PanelInfo> linkedList) {
        float f = -(terraceInfo.mWidth - this.getMainPillarWidth()) / 2.0f + 46.0f + 7.5f;
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mTerraceId != terraceInfo.mId) continue;
            if (terraceInfo.mMiddlePillarPosition != null && panelInfo.mIndex == terraceInfo.mMiddlePillarPosition * 2) {
                f += this.getMiddlePillarWidth();
            }
            if (panelInfo.mIndex >= n) break;
            f += panelInfo.mWidth.floatValue();
        }
        return f;
    }
}

