/*
 * Decompiled with CFR 0.152.
 */
package option.danran.service;

import danran.multispan.AbstractTerraceUnit;
import danran.multispan.MultiSpanTerrace;
import danran.multispan.SidePanels;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import option.danran.entity.PanelInfo;
import option.danran.entity.TerraceInfo;
import option.danran.type.PanelFoldingType;
import option.danran.type.TerraceDepthType;
import option.danran.util.AbstractPanelUnit;
import option.danran.util.ChoseiPanelUnit;
import option.danran.util.OridoSize;
import option.danran.util.PanelType;
import option.danran.util.PanelUnit;

public class SidePanelShapeService {
    public static OridoSize findOridoSize(float f) {
        OridoSize oridoSize = null;
        OridoSize[] oridoSizeArray = OridoSize.values();
        int n = oridoSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OridoSize oridoSize2 = oridoSizeArray[n2];
            if (oridoSize2.getWidth() == f) {
                oridoSize = oridoSize2;
                break;
            }
            ++n2;
        }
        return oridoSize;
    }

    public static PanelInfo findSidePanel(LinkedList<PanelInfo> linkedList, int n) {
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mIndex != n) continue;
            return panelInfo;
        }
        return null;
    }

    public static float getAdjustmentFixDepth(TerraceDepthType terraceDepthType) {
        float f = 0.0f;
        switch (terraceDepthType) {
            case T6: {
                f = 236.5f;
                break;
            }
            case T8: {
                f = 288.5f;
                break;
            }
            case T10: {
                f = 408.5f;
            }
        }
        return f;
    }

    public static boolean hasOrido(LinkedList<PanelInfo> linkedList) {
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mPanelFoldingType != PanelFoldingType.ORIDO) continue;
            return true;
        }
        return false;
    }

    public static void translatePanels(SidePanels sidePanels, LinkedList<PanelInfo> linkedList, TerraceInfo terraceInfo) {
        Vector<PanelUnit> vector = sidePanels.getUnits();
        Vector<ChoseiPanelUnit> vector2 = sidePanels.getChoseiUnits();
        vector.clear();
        vector2.clear();
        int n = linkedList.size();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            PanelInfo panelInfo = SidePanelShapeService.findSidePanel(linkedList, n3);
            if (panelInfo.mGroupId == null || panelInfo.mGroupId != n2) {
                Object object;
                PanelType panelType = PanelType.ORIDO;
                OridoSize oridoSize = OridoSize.ORIDO_SET1;
                ArrayList<PanelInfo> arrayList = new ArrayList<PanelInfo>();
                arrayList.add(panelInfo);
                if (panelInfo.mPanelFoldingType == PanelFoldingType.ORIDO) {
                    object = SidePanelShapeService.findSidePanel(linkedList, n3 + 1);
                    arrayList.add((PanelInfo)object);
                    oridoSize = SidePanelShapeService.findOridoSize(panelInfo.mWidth.floatValue() * 2.0f);
                    panelType = PanelType.ORIDO;
                    SidePanelShapeService.addUnit(panelType, oridoSize, vector, arrayList);
                    n2 = panelInfo.mGroupId;
                } else if (panelInfo.mPanelFoldingType == PanelFoldingType.FIX) {
                    oridoSize = SidePanelShapeService.findOridoSize(panelInfo.mWidth.floatValue() * 2.0f);
                    panelType = PanelType.FIX;
                    SidePanelShapeService.addUnit(panelType, oridoSize, vector, arrayList);
                } else if (panelInfo.mPanelFoldingType == PanelFoldingType.ADJUSTMENT_FIX) {
                    object = new ChoseiPanelUnit();
                    ((ChoseiPanelUnit)object).setWidth(panelInfo.mWidth.floatValue());
                    ((AbstractPanelUnit)object).setPanelInfoList(arrayList);
                    vector2.add((ChoseiPanelUnit)object);
                }
            }
            ++n3;
        }
    }

    private static void addUnit(PanelType panelType, OridoSize oridoSize, Vector<PanelUnit> vector, ArrayList<PanelInfo> arrayList) {
        PanelUnit panelUnit = new PanelUnit();
        panelUnit.setType(panelType);
        panelUnit.setSize(oridoSize);
        panelUnit.setPanelInfoList(arrayList);
        vector.add(panelUnit);
    }

    public static boolean hasRightPanel(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (abstractTerraceUnit.getRightRail() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLeftPanel(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (abstractTerraceUnit.getLeftRail() == null) continue;
            return true;
        }
        return false;
    }

    public static float getLeftPanelWidth(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (abstractTerraceUnit.getLeftRail() == null) continue;
            return abstractTerraceUnit.getCx() + abstractTerraceUnit.getWidthL() - 105.0f;
        }
        return 0.0f;
    }

    public static float getRightPanelWidth(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (abstractTerraceUnit.getRightRail() == null) continue;
            return abstractTerraceUnit.getCx() + abstractTerraceUnit.getWidthR() + 105.0f;
        }
        return 0.0f;
    }

    public static boolean isSingleGroup(PanelInfo panelInfo, List<PanelInfo> list) {
        int n = 0;
        for (PanelInfo panelInfo2 : list) {
            if (panelInfo2.mGroupId != panelInfo.mGroupId) continue;
            ++n;
        }
        return n == 1;
    }

    public static PanelInfo findSingleFixPanel(LinkedList<PanelInfo> linkedList) {
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mPanelFoldingType != PanelFoldingType.FIX || !SidePanelShapeService.isSingleGroup(panelInfo, linkedList)) continue;
            return panelInfo;
        }
        return null;
    }
}

