/*
 * Decompiled with CFR 0.152.
 */
package option.danran.model.util.update;

import danran.multispan.AbstractTerraceUnit;
import danran.multispan.MultiSpanTerrace;
import danran.multispan.SidePanelProperty;
import danran.multispan.SidePanels;
import danran.multispan.SideRailProperty;
import danran.multispan.types.ZtPanel;
import java.util.LinkedList;
import java.util.List;
import option.danran.adapter.YaneColorAdapter;
import option.danran.entity.PanelInfo;
import option.danran.entity.TerraceInfo;
import option.danran.entity.TerracesInfo;
import option.danran.service.PanelService;
import option.danran.service.SidePanelShapeService;
import option.danran.type.EnforcementType;
import option.danran.type.TsumabariUpperType;
import option.danran.type.WidthCutType;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInstanceFactory;

public abstract class AbstractDRNTerraceUpdater {
    @GdInject
    private PanelService mPanelService = (PanelService)GdInstanceFactory.getInstance().getInstance(PanelService.class, new Object[0]);

    public void update(MultiSpanTerrace multiSpanTerrace) {
        TerracesInfo terracesInfo = multiSpanTerrace.getTerracesInfo();
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        LinkedList<PanelInfo> linkedList = multiSpanTerrace.getFrontPanelInfoList();
        LinkedList<PanelInfo> linkedList2 = multiSpanTerrace.getLeftPanelInfoList();
        LinkedList<PanelInfo> linkedList3 = multiSpanTerrace.getRightPanelInfoList();
        int n = 0;
        while (n < list.size()) {
            SidePanelProperty sidePanelProperty;
            AbstractTerraceUnit abstractTerraceUnit = list.get(n);
            TerraceInfo terraceInfo = abstractTerraceUnit.getTerraceInfo();
            boolean bl = n == 0;
            boolean bl2 = n == list.size() - 1;
            EnforcementType enforcementType = abstractTerraceUnit.getEnforcementType();
            boolean bl3 = enforcementType.equals((Object)EnforcementType.IRISUMI_R);
            boolean bl4 = enforcementType.equals((Object)EnforcementType.IRISUMI_L);
            boolean bl5 = false;
            if (bl) {
                bl5 = true;
            }
            if (bl4) {
                bl5 = false;
            }
            if (bl5) {
                abstractTerraceUnit.setLeftRail(this.createUnderPanel(linkedList2, terraceInfo));
            }
            boolean bl6 = false;
            if (bl2) {
                bl6 = true;
            }
            if (bl3) {
                bl6 = false;
            }
            if (bl6) {
                abstractTerraceUnit.setRightRail(this.createUnderPanel(linkedList3, terraceInfo));
            }
            LinkedList<PanelInfo> linkedList4 = this.mPanelService.findPanelByTerraceId(linkedList, terraceInfo.mId);
            abstractTerraceUnit.setFrontRail(this.createUnderPanel(linkedList4, terraceInfo));
            this.updateSpunPitchesByCutType(abstractTerraceUnit, terracesInfo);
            if (terraceInfo.mLeftTsumabariUpperType != TsumabariUpperType.NONE) {
                sidePanelProperty = new SidePanelProperty();
                abstractTerraceUnit.setLeftSide(sidePanelProperty);
                sidePanelProperty.setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mLeftTsumabariUpperMaterialType.mId));
            }
            if (terraceInfo.mRightTsumabariUpperType != TsumabariUpperType.NONE) {
                sidePanelProperty = new SidePanelProperty();
                abstractTerraceUnit.setRightSide(sidePanelProperty);
                sidePanelProperty.setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mRightTsumabariUpperMaterialType.mId));
            }
            ++n;
        }
    }

    private SideRailProperty createUnderPanel(LinkedList<PanelInfo> linkedList, TerraceInfo terraceInfo) {
        SideRailProperty sideRailProperty = new SideRailProperty();
        if (!SidePanelShapeService.hasOrido(linkedList)) {
            sideRailProperty.setPanel(ZtPanel.FIX);
        }
        if (SidePanelShapeService.findSidePanel(linkedList, 0) != null) {
            SidePanels sidePanels = sideRailProperty.getPanels();
            if (sidePanels == null) {
                sidePanels = new SidePanels();
                sideRailProperty.setPanels(sidePanels);
            }
            SidePanelShapeService.translatePanels(sidePanels, linkedList, terraceInfo);
        }
        return sideRailProperty;
    }

    private void updateSpunPitchesByCutType(AbstractTerraceUnit abstractTerraceUnit, TerracesInfo terracesInfo) {
        TerraceInfo terraceInfo = abstractTerraceUnit.getTerraceInfo();
        int n = terraceInfo.mWidthType.mId;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = 910.0f;
            ++n2;
        }
        if (terracesInfo.mWidthCutType != null) {
            float f = terraceInfo.mWidthType.mDetailValue - terraceInfo.mWidth;
            WidthCutType widthCutType = terracesInfo.mWidthCutType;
            switch (widthCutType) {
                case LEFT: {
                    if (abstractTerraceUnit.getPrev() != null) break;
                    fArray[0] = fArray[0] - f;
                    break;
                }
                case RIGHT: {
                    if (abstractTerraceUnit.getNext() != null) break;
                    int n3 = n - 1;
                    fArray[n3] = fArray[n3] - f;
                    break;
                }
                case BOTH: {
                    if (abstractTerraceUnit.getPrev() == null) {
                        fArray[0] = abstractTerraceUnit.getNext() == null ? fArray[0] - f / 2.0f : fArray[0] - f;
                    }
                    if (abstractTerraceUnit.getNext() != null) break;
                    if (abstractTerraceUnit.getPrev() == null) {
                        int n4 = n - 1;
                        fArray[n4] = fArray[n4] - f / 2.0f;
                        break;
                    }
                    int n5 = n - 1;
                    fArray[n5] = fArray[n5] - f;
                }
            }
        }
        abstractTerraceUnit.setPitches(fArray);
    }
}

