/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.util;

import java.util.List;
import model.primitive.LsEdge;
import model.primitive.LsFactory;
import model.primitive.LsShape;
import model.primitive.LsSurface;
import model.shape.primitive.SMatrix4d;
import model.shape.primitive.SVector3d;

public class SweepUtil {
    private static SweepUtil instance;

    public static SweepUtil getInstance() {
        if (instance == null) {
            instance = new SweepUtil();
        }
        return instance;
    }

    private SweepUtil() {
    }

    public LsShape createSweepWithCutting(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, SMatrix4d sMatrix4d, boolean bl) {
        return this.createSweepWithCutting(dArray, d, d2, d3, d4, d5, d6, sMatrix4d, bl, null);
    }

    public LsShape createSweepWithCutting(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, SMatrix4d sMatrix4d, boolean bl, boolean[] blArray) {
        LsShape lsShape = LsFactory.createShape((boolean)bl);
        List list = lsShape.getSurfaces();
        SVector3d[] sVector3dArray = new SVector3d[dArray.length];
        SVector3d[] sVector3dArray2 = new SVector3d[dArray.length];
        SVector3d sVector3d = new SVector3d();
        int n = 0;
        while (n < dArray.length) {
            double d7;
            double d8;
            double d9;
            if (dArray[n].length == 3) {
                d9 = dArray[n][1];
                d8 = dArray[n][2];
            } else {
                d9 = dArray[n][0];
                d8 = dArray[n][1];
            }
            double d10 = -(d2 * d9 + d3) / d;
            sVector3dArray[n] = new SVector3d(d10, d9, d8);
            if (sMatrix4d != null) {
                sMatrix4d.translate(sVector3d, d10, d9, d8);
                sVector3dArray[n].set(sVector3d);
            }
            if (Math.abs(d10 - (d7 = -(d5 * d9 + d6) / d4)) < (double)0.001f) {
                sVector3dArray2[n] = sVector3dArray[n];
            } else {
                sVector3dArray2[n] = new SVector3d(d7, d9, d8);
                if (sMatrix4d != null) {
                    sMatrix4d.translate(sVector3d, d7, d9, d8);
                    sVector3dArray2[n].set(sVector3d);
                }
            }
            ++n;
        }
        LsEdge[] lsEdgeArray = new LsEdge[sVector3dArray.length - 1];
        LsEdge[] lsEdgeArray2 = new LsEdge[sVector3dArray2.length - 1];
        int n2 = 0;
        while (n2 < lsEdgeArray.length) {
            lsEdgeArray[n2] = LsFactory.createEdge((SVector3d)sVector3dArray[n2], (SVector3d)sVector3dArray[n2 + 1]);
            lsEdgeArray2[n2] = LsFactory.createEdge((SVector3d)sVector3dArray2[n2], (SVector3d)sVector3dArray2[n2 + 1]);
            ++n2;
        }
        LsEdge[] lsEdgeArray3 = new LsEdge[dArray.length];
        int n3 = 0;
        while (n3 < lsEdgeArray3.length) {
            lsEdgeArray3[n3] = LsFactory.createEdge((SVector3d)sVector3dArray[n3], (SVector3d)sVector3dArray2[n3]);
            if (blArray != null) {
                lsEdgeArray3[n3].drawEdge = blArray[n3];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < lsEdgeArray.length) {
            LsEdge lsEdge = lsEdgeArray3[n3];
            LsEdge lsEdge2 = lsEdgeArray3[n3 + 1];
            LsEdge lsEdge3 = lsEdgeArray[n3];
            LsEdge lsEdge4 = lsEdgeArray2[n3];
            LsSurface lsSurface = LsFactory.createSurface();
            List list2 = lsSurface.getEdges();
            List list3 = lsSurface.getVertices();
            if (!this.equals(lsEdge.p1, lsEdge.p2)) {
                list2.add(lsEdge);
            }
            list2.add(lsEdge3);
            if (!this.equals(lsEdge2.p1, lsEdge2.p2)) {
                list2.add(lsEdge2);
            }
            list2.add(lsEdge4);
            list3.add(sVector3dArray[n3]);
            if (sVector3dArray[n3] != sVector3dArray2[n3]) {
                list3.add(sVector3dArray2[n3]);
            }
            list3.add(sVector3dArray2[n3 + 1]);
            if (sVector3dArray2[n3 + 1] != sVector3dArray[n3 + 1]) {
                list3.add(sVector3dArray[n3 + 1]);
            }
            list.add(lsSurface);
            ++n3;
        }
        return lsShape;
    }

    private boolean equals(SVector3d sVector3d, SVector3d sVector3d2) {
        return sVector3d.x == sVector3d2.x && sVector3d.y == sVector3d2.y && sVector3d.z == sVector3d2.z;
    }
}

