/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.type;

import option.cocoma2.type.TerraceDepthType;

public enum TerraceHeightType {
    H20(0, "H20", 2000, 2187),
    H22(1, "H22", 2200, 2387),
    H24(2, "H24", 2400, 2587),
    NORMAL(3, "\u6a19\u6e96\u67f1", 2400, 2587),
    LONG(4, "\u30ed\u30f3\u30b0\u67f1", 3100, 3287);

    public int mId;
    public String mName;
    public int mTumabariHeight;
    public int mTumadarukiHeight;

    private TerraceHeightType(int n2, String string2, int n3, int n4) {
        this.mId = n2;
        this.mName = string2;
        this.mTumabariHeight = n3;
        this.mTumadarukiHeight = n4;
    }

    public static TerraceHeightType getById(int n) {
        TerraceHeightType terraceHeightType = null;
        TerraceHeightType[] terraceHeightTypeArray = TerraceHeightType.values();
        int n2 = terraceHeightTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TerraceHeightType terraceHeightType2 = terraceHeightTypeArray[n3];
            if (terraceHeightType2.mId == n) {
                terraceHeightType = terraceHeightType2;
                break;
            }
            ++n3;
        }
        return terraceHeightType;
    }

    public static TerraceHeightType getByName(String string) {
        TerraceHeightType terraceHeightType = null;
        TerraceHeightType[] terraceHeightTypeArray = TerraceHeightType.values();
        int n = terraceHeightTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceHeightType terraceHeightType2 = terraceHeightTypeArray[n2];
            if (terraceHeightType2.mName.equals(string)) {
                terraceHeightType = terraceHeightType2;
                break;
            }
            ++n2;
        }
        return terraceHeightType;
    }

    public static TerraceHeightType getByValue(int n) {
        TerraceHeightType terraceHeightType = null;
        TerraceHeightType[] terraceHeightTypeArray = TerraceHeightType.values();
        int n2 = terraceHeightTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TerraceHeightType terraceHeightType2 = terraceHeightTypeArray[n3];
            if (terraceHeightType2.mTumabariHeight == n) {
                terraceHeightType = terraceHeightType2;
                break;
            }
            ++n3;
        }
        return terraceHeightType;
    }

    public float getDefaultHeight(TerraceDepthType terraceDepthType) {
        return (float)this.mTumadarukiHeight + terraceDepthType.getD1();
    }
}

