/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.material;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import java.util.List;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.service.material.KoshikabeCommonService;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.KoshikabePosType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.TerraceDepthType;
import option.cocoma2.type.TerraceWidthType;
import option.cocoma2.type.TsumabariUpperType;
import option.gad.core.inject.GdInject;

@Reflectable
public class TerraceCommonService {
    @GdInject
    private KoshikabeCommonService mKoshikabeCommonService;

    public void changeDepthType(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType) {
        this.changeDepthType(terracesInfo, linkedList, terraceDepthType, terraceDepthType.mDetailValue);
    }

    public void changeDepthType(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType, float f) {
        terracesInfo.mDepthType = terraceDepthType;
        terracesInfo.mDepth = Float.valueOf(f);
        for (TerraceInfo terraceInfo : linkedList) {
            terraceInfo.mDepthType = terraceDepthType;
            terraceInfo.mDepth = Float.valueOf(f);
            terraceInfo.mLeftDepthType = terraceDepthType;
            terraceInfo.mLeftDepth = Float.valueOf(f);
            terraceInfo.mRightDepthType = terraceDepthType;
            terraceInfo.mRightDepth = Float.valueOf(f);
        }
    }

    public TerraceInfo findMasterTerraceInfo(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsMaster.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public LinkedList<TerraceInfo> findManyGardenRoomPlusTerrace(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mIsMaster.booleanValue()) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public LinkedList<TerraceInfo> findManyTerraceInfoByRoomType(List<TerraceInfo> list, RoomType roomType) {
        LinkedList<TerraceInfo> linkedList = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : list) {
            if (roomType != terraceInfo.mRoomType) continue;
            linkedList.add(terraceInfo);
        }
        return linkedList;
    }

    public TerraceWidthType calcTerraceWidthTypeByRoomType(List<TerraceInfo> list, RoomType roomType) {
        LinkedList<TerraceInfo> linkedList = this.findManyTerraceInfoByRoomType(list, roomType);
        float f = 0.0f;
        for (TerraceInfo terraceInfo : linkedList) {
            f += terraceInfo.mWidth;
        }
        return TerraceWidthType.getByDetailValue(f);
    }

    public TerraceInfo findTerraceInfoByIndex(List<TerraceInfo> list, int n) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    public boolean isRentou(LinkedList<TerraceInfo> linkedList) {
        return linkedList.size() > 1 && !this.isGardenRoomPlus(linkedList);
    }

    public boolean isGardenRoomPlus(LinkedList<TerraceInfo> linkedList) {
        RoomType roomType = null;
        if (linkedList.size() > 1) {
            for (TerraceInfo terraceInfo : linkedList) {
                if (roomType == null) {
                    roomType = terraceInfo.mRoomType;
                    continue;
                }
                if (roomType == terraceInfo.mRoomType) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKoshikabeL(TerraceInfo terraceInfo, BasicInfo basicInfo, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? terraceInfo.mLeftKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.LEFT_L : terraceInfo.mRightKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.RIGHT_L;
        return bl2;
    }

    public boolean hasRoomTypes(List<TerraceInfo> list, RoomType ... roomTypeArray) {
        boolean[] blArray = new boolean[roomTypeArray.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        n = 0;
        while (n < roomTypeArray.length) {
            if (this.hasRoomType(list, roomTypeArray[n])) {
                blArray[n] = true;
            }
            ++n;
        }
        n = 1;
        int n2 = 0;
        while (n2 < blArray.length) {
            n &= blArray[n2];
            ++n2;
        }
        return n != 0;
    }

    public boolean hasRoomType(List<TerraceInfo> list, RoomType roomType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mRoomType != roomType) continue;
            return true;
        }
        return false;
    }

    public TerraceInfo findLeftTerrace(LinkedList<TerraceInfo> linkedList, RoomType roomType) {
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mRoomType != roomType || terraceInfo != null && terraceInfo2.mId >= terraceInfo.mId) continue;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findRightTerrace(LinkedList<TerraceInfo> linkedList, RoomType roomType) {
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mRoomType != roomType || terraceInfo != null && terraceInfo2.mId <= terraceInfo.mId) continue;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findLeftEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findRightEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsRightEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceDepthType judgeLeftOptionDepthType(TerraceInfo terraceInfo) {
        float f = terraceInfo.mLeftDepth.floatValue();
        if (terraceInfo.mEnforcementType == EnforcementType.PARTIAL_IRISUMI_L) {
            f -= 50.0f;
        }
        TerraceDepthType[] terraceDepthTypeArray = TerraceDepthType.values();
        int n = terraceDepthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceDepthType terraceDepthType = terraceDepthTypeArray[n2];
            if (f == terraceDepthType.mDetailValue) {
                return terraceDepthType;
            }
            ++n2;
        }
        return null;
    }

    public TerraceDepthType judgeRightOptionDepthType(TerraceInfo terraceInfo) {
        float f = terraceInfo.mRightDepth.floatValue();
        if (terraceInfo.mEnforcementType == EnforcementType.PARTIAL_IRISUMI_R) {
            f -= 50.0f;
        }
        TerraceDepthType[] terraceDepthTypeArray = TerraceDepthType.values();
        int n = terraceDepthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceDepthType terraceDepthType = terraceDepthTypeArray[n2];
            if (f == terraceDepthType.mDetailValue) {
                return terraceDepthType;
            }
            ++n2;
        }
        return null;
    }

    public boolean existTerraceWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public void changeKoshikabeType(LinkedList<TerraceInfo> linkedList, KoshikabeType koshikabeType, KoshikabePosType koshikabePosType) {
        TerraceInfo terraceInfo2;
        for (TerraceInfo terraceInfo2 : linkedList) {
            terraceInfo2.mFrontKoshikabeType = koshikabeType;
            terraceInfo2.mLeftKoshikabeType = KoshikabeType.NONE;
            terraceInfo2.mRightKoshikabeType = KoshikabeType.NONE;
        }
        if (koshikabePosType == KoshikabePosType.LEFT_L) {
            terraceInfo2 = linkedList.getFirst();
            terraceInfo2.mLeftKoshikabeType = koshikabeType;
        }
        if (koshikabePosType == KoshikabePosType.RIGHT_L) {
            terraceInfo2 = linkedList.getLast();
            terraceInfo2.mRightKoshikabeType = koshikabeType;
        }
        this.updateHasExKoshikabe(linkedList);
    }

    public void updateHasExKoshikabe(LinkedList<TerraceInfo> linkedList) {
        this.updateHasLeftExKoshikabe(linkedList);
        this.updateHasRightExKoshikabe(linkedList);
    }

    public void updateHasLeftExKoshikabe(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = linkedList.getFirst();
        if (terraceInfo != null) {
            if (terraceInfo.mEnforcementType == EnforcementType.IRISUMI_L) {
                terraceInfo.mHasLeftExKoshikabe = false;
            } else if (terraceInfo.mLeftKoshikabeType != KoshikabeType.NONE) {
                terraceInfo.mHasLeftExKoshikabe = false;
            }
        }
    }

    public void updateHasRightExKoshikabe(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = linkedList.getLast();
        if (terraceInfo != null) {
            if (terraceInfo.mEnforcementType == EnforcementType.IRISUMI_R) {
                terraceInfo.mHasRightExKoshikabe = false;
            } else if (terraceInfo.mRightKoshikabeType != KoshikabeType.NONE) {
                terraceInfo.mHasRightExKoshikabe = false;
            }
        }
    }

    public float calcLeftDepthGap(EnforcementType enforcementType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        switch (enforcementType) {
            case KUTAI1: {
                f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
                break;
            }
            case PARTIAL_IRISUMI_L: {
                f = terracesInfo.mParticalDepth == null ? 0.0f : terracesInfo.mParticalDepth.floatValue();
                f += 50.0f;
            }
        }
        return f;
    }

    public float calcRightDepthGap(EnforcementType enforcementType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        switch (enforcementType) {
            case KUTAI2: {
                f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
                break;
            }
            case PARTIAL_IRISUMI_R: {
                f = terracesInfo.mParticalDepth == null ? 0.0f : terracesInfo.mParticalDepth.floatValue();
                f += 50.0f;
            }
        }
        return f;
    }

    public boolean hasTsumabariUpper(LinkedList<TerraceInfo> linkedList, boolean bl) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!(bl ? terraceInfo.mLeftTsumabariUpperType != null && terraceInfo.mLeftTsumabariUpperType != TsumabariUpperType.NONE : terraceInfo.mLeftTsumabariUpperType != null && terraceInfo.mRightTsumabariUpperType != TsumabariUpperType.NONE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTsumabariUpper(LinkedList<TerraceInfo> linkedList, TsumabariUpperType tsumabariUpperType) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mLeftTsumabariUpperType == tsumabariUpperType) {
                return true;
            }
            if (terraceInfo.mRightTsumabariUpperType != tsumabariUpperType) continue;
            return true;
        }
        return false;
    }

    public boolean isKoshikabeBorderSpan(List<TerraceInfo> list, TerraceInfo terraceInfo, Integer n) {
        TerraceInfo terraceInfo2;
        if (terraceInfo == null) {
            return false;
        }
        if (n == null) {
            return false;
        }
        if (terraceInfo.mFrontKoshikabeType != KoshikabeType.NONE) {
            return false;
        }
        if (n == 0 && (terraceInfo2 = this.findTerraceInfoByIndex(list, terraceInfo.mId - 1)) != null && terraceInfo2.mFrontKoshikabeType != KoshikabeType.NONE) {
            return true;
        }
        return n == terraceInfo.mWidthType.mId - 1 && (terraceInfo2 = this.findTerraceInfoByIndex(list, terraceInfo.mId + 1)) != null && terraceInfo2.mFrontKoshikabeType != KoshikabeType.NONE;
    }

    public boolean isOnlyLeftEdgeTerraceKoshikabe(LinkedList<TerraceInfo> linkedList) {
        if (linkedList.size() <= 1) {
            return false;
        }
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue() || terraceInfo.mFrontKoshikabeType == KoshikabeType.NONE) continue;
            for (TerraceInfo terraceInfo2 : linkedList) {
                if (!terraceInfo2.mIsRightEnd.booleanValue() || terraceInfo2.mFrontKoshikabeType != KoshikabeType.NONE) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOnlyRightEdgeTerraceKoshikabe(LinkedList<TerraceInfo> linkedList) {
        if (linkedList.size() <= 1) {
            return false;
        }
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue() || terraceInfo.mFrontKoshikabeType != KoshikabeType.NONE) continue;
            for (TerraceInfo terraceInfo2 : linkedList) {
                if (!terraceInfo2.mIsRightEnd.booleanValue() || terraceInfo2.mFrontKoshikabeType == KoshikabeType.NONE) continue;
                return true;
            }
        }
        return false;
    }
}

