/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.material;

import java.util.LinkedList;
import java.util.List;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.service.material.TerraceCommonService;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.SidePanelType;
import option.gad.core.inject.GdInject;
import option.gad.core.util.EnumUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SidePanelCommonService {
    private Log mLog = LogFactory.getLog(SidePanelCommonService.class);
    @GdInject
    protected TerraceCommonService mTerraceCommonService;

    public LinkedList<SidePanelInfo> findManySidePanelInfo(List<SidePanelInfo> list, SidePanelType ... sidePanelTypeArray) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        for (SidePanelInfo sidePanelInfo : list) {
            if (!EnumUtil.matchOR((Enum)sidePanelInfo.mPanelType, (Enum[])sidePanelTypeArray)) continue;
            linkedList.add(sidePanelInfo);
        }
        return linkedList;
    }

    public SidePanelInfo findOneSidePanelByIndex(List<SidePanelInfo> list, int n) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public boolean hasSideDoor(List<SidePanelInfo> list) {
        boolean bl = false;
        bl |= this.hasSidePanelType(list, SidePanelType.ORIDO);
        return bl |= this.hasSidePanelType(list, SidePanelType.HIKIDO);
    }

    public boolean hasSidePanelType(List<SidePanelInfo> list, SidePanelType sidePanelType) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType != sidePanelType) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlySidePanelType(List<SidePanelInfo> list, SidePanelType sidePanelType) {
        if (list.isEmpty()) {
            return false;
        }
        boolean bl = true;
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType == SidePanelType.ORIDO_ADJUSTMENT_FIX || sidePanelInfo.mPanelType == SidePanelType.ADJUSTMENT_FIX || sidePanelInfo.mPanelType == SidePanelType.MIDDLE_MULLION || sidePanelInfo.mPanelType == SidePanelType.TATEWAKU || sidePanelInfo.mPanelType == sidePanelType) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean hasEssentialSidePanel(LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2, LinkedList<SidePanelInfo> linkedList3) {
        boolean bl = true;
        bl &= this.hasEssentialLeftSidePanel(linkedList, linkedList2);
        return bl &= this.hasEssentialRightSidePanel(linkedList, linkedList3);
    }

    public boolean hasEssentialLeftSidePanel(LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.findLeftTerrace(linkedList, RoomType.GARDEN_ROOM);
        if (terraceInfo == null) {
            return true;
        }
        if (terraceInfo.mEnforcementType == EnforcementType.IRISUMI_L) {
            return true;
        }
        return !linkedList2.isEmpty();
    }

    public boolean hasEssentialRightSidePanel(LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.findRightTerrace(linkedList, RoomType.GARDEN_ROOM);
        if (terraceInfo == null) {
            return true;
        }
        if (terraceInfo.mEnforcementType == EnforcementType.IRISUMI_R) {
            return true;
        }
        return !linkedList2.isEmpty();
    }

    public List<SidePanelInfo> packAllSidePanel(List<SidePanelInfo> list, List<SidePanelInfo> list2) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public int countPanel(SidePanelType sidePanelType, List<SidePanelInfo> list) {
        int n = 0;
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType != sidePanelType) continue;
            ++n;
        }
        return n;
    }

    public boolean useLeftIdouHoutate(EnforcementType enforcementType) {
        return enforcementType == EnforcementType.PARTIAL_IRISUMI_L;
    }

    public boolean useRightIdouHoutate(EnforcementType enforcementType) {
        return enforcementType == EnforcementType.PARTIAL_IRISUMI_R;
    }

    public float calcPanelDepth(LinkedList<SidePanelInfo> linkedList, SidePanelType ... sidePanelTypeArray) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : this.findManySidePanelInfo(linkedList, sidePanelTypeArray)) {
            f += sidePanelInfo.mWidth.floatValue();
        }
        return f;
    }
}

