/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.material;

import com.kt.annotation.Reflectable;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.InnerDeckInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.type.CM2ColorType;
import option.cocoma2.type.FloorType;
import option.cocoma2.type.KoshikabePosType;
import option.cocoma2.type.KoshikabeTileType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.TerraceWidthType;

@Reflectable
public class KoshikabeCommonService {
    private static final float WET_FRONT_KOSHIKABE_TO_KASAGI_CAP = 28.5f;
    private static final float DRY_FRONT_KOSHIKABE_TO_KASAGI_CAP = 33.5f;
    private static final float L_KOSHIKABE_TO_KASAGI_CAP = 30.5f;
    private static final float WET_IRISUMI_KOSHIKABE_TO_KASAGI_CAP = 38.5f;
    private static final float DRY_IRISUMI_KOSHIKABE_TO_KASAGI_CAP = 33.5f;
    private static final float FRONT_KOSHIKABE_TO_PILLAR = 70.0f;
    private static final float L_KOSHIKABE_TO_PILLAR = 23.5f;
    private static final float KOSHIKABE_OUT_TO_PILLAR = 126.5f;
    private static final float KASAGI_IN_TO_PILLAR = 53.5f;
    private static final float WET_L_KOSHIKABE_TO_KUTAI = 70.0f;
    private static final float DRY_L_KOSHIKABE_TO_KUTAI = 50.0f;
    public static final float KOSHIKABE_HEIGHT = 833.0f;
    private static final float KOSHIKABE_BLOCK_HEIGHT = 793.0f;
    private static final float KOSHIKABE_KASAGI_CAP_HEIGHT = 792.5f;
    private static final float KOSHIKABE_PILLAR_SPACER_HEIGHT = 800.0f;
    private static final float KOSHIKABE_DEPTH = 150.0f;
    private static final float PILLAR_WIDTH = 60.0f;

    public float calcKoshikabeMargin(LinkedList<TerraceInfo> linkedList, KoshikabeType koshikabeType, KoshikabePosType koshikabePosType, boolean bl, boolean bl2) {
        if (this.judgeCoener(koshikabePosType, bl2) && !bl) {
            return 23.5f;
        }
        TerraceWidthType terraceWidthType = this.calcTerraceWidthTypeByKoshikabe(linkedList);
        if (terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T10;
        }
        KoshikabeBlockWidthType koshikabeBlockWidthType = KoshikabeBlockWidthType.findByTerrathWidthType(terraceWidthType);
        float f = 0.0f;
        float f2 = 0.0f;
        if (koshikabePosType == KoshikabePosType.FRONT) {
            if (!bl) {
                if (koshikabeType == KoshikabeType.WET) {
                    f2 = koshikabeBlockWidthType.mWetWidth;
                } else if (koshikabeType == KoshikabeType.DRY) {
                    f2 = koshikabeBlockWidthType.mDryWidth;
                }
                f = (f2 - terraceWidthType.mDetailValue - 60.0f) / 2.0f;
            } else {
                if (koshikabeType == KoshikabeType.WET) {
                    f2 = koshikabeBlockWidthType.mIrisumiWetWidth;
                } else if (koshikabeType == KoshikabeType.DRY) {
                    f2 = koshikabeBlockWidthType.mIrisumiDryWidth;
                }
                f = f2 - terraceWidthType.mDetailValue - 60.0f;
            }
        } else {
            if (koshikabeType == KoshikabeType.WET) {
                f2 = koshikabeBlockWidthType.mWetLWidth;
            } else if (koshikabeType == KoshikabeType.DRY) {
                f2 = koshikabeBlockWidthType.mDryLWidth;
            }
            f = f2 - terraceWidthType.mDetailValue - 60.0f - 23.5f;
        }
        return f;
    }

    public float calcKoshikabeKasagiCapMargin(LinkedList<TerraceInfo> linkedList, KoshikabeType koshikabeType, KoshikabePosType koshikabePosType, boolean bl, boolean bl2) {
        float f;
        float f2 = 0.0f;
        float f3 = f = koshikabeType == KoshikabeType.WET ? 28.5f : 33.5f;
        f2 = koshikabePosType == KoshikabePosType.FRONT ? (bl ? (koshikabeType == KoshikabeType.WET ? 38.5f : 33.5f) : f) : (this.judgeCoener(koshikabePosType, bl2) ? 30.5f : f);
        return this.calcKoshikabeMargin(linkedList, koshikabeType, koshikabePosType, bl, bl2) + f2;
    }

    public float calcLeftExKoshikabeWidth(TerraceInfo terraceInfo) {
        return this.calcCommonExKoshikabeWidth(terraceInfo.mFrontKoshikabeType, terraceInfo.mHasLeftExKoshikabe);
    }

    public float calcRightExKoshikabeWidth(TerraceInfo terraceInfo) {
        return this.calcCommonExKoshikabeWidth(terraceInfo.mFrontKoshikabeType, terraceInfo.mHasRightExKoshikabe);
    }

    public float calcCommonExKoshikabeWidth(KoshikabeType koshikabeType, boolean bl) {
        float f = 0.0f;
        if (koshikabeType != KoshikabeType.NONE && bl) {
            if (koshikabeType == KoshikabeType.WET) {
                f = 1600.0f;
            } else if (koshikabeType == KoshikabeType.DRY) {
                f = TerraceWidthType.T10.mDetailValue;
            }
        }
        return f;
    }

    public boolean isMixKoshikabeType(LinkedList<TerraceInfo> linkedList) {
        int n = linkedList.size();
        if (n <= 1) {
            return false;
        }
        int n2 = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mFrontKoshikabeType != KoshikabeType.NONE) continue;
            ++n2;
        }
        return n2 != 0 && n2 != n;
    }

    public float calcFrontKoshikabeWidth(LinkedList<TerraceInfo> linkedList, KoshikabeType koshikabeType, KoshikabePosType koshikabePosType, boolean bl) {
        TerraceWidthType terraceWidthType = this.calcTerraceWidthTypeByKoshikabe(linkedList);
        if (terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T10;
        }
        KoshikabeBlockWidthType koshikabeBlockWidthType = KoshikabeBlockWidthType.findByTerrathWidthType(terraceWidthType);
        float f = 0.0f;
        if (koshikabePosType == KoshikabePosType.FRONT) {
            if (!bl) {
                if (koshikabeType == KoshikabeType.WET) {
                    f = koshikabeBlockWidthType.mWetWidth;
                } else if (koshikabeType == KoshikabeType.DRY) {
                    f = koshikabeBlockWidthType.mDryWidth;
                }
            } else if (koshikabeType == KoshikabeType.WET) {
                f = koshikabeBlockWidthType.mIrisumiWetWidth;
            } else if (koshikabeType == KoshikabeType.DRY) {
                f = koshikabeBlockWidthType.mIrisumiDryWidth;
            }
        } else if (koshikabeType == KoshikabeType.WET) {
            f = koshikabeBlockWidthType.mWetLWidth;
        } else if (koshikabeType == KoshikabeType.DRY) {
            f = koshikabeBlockWidthType.mDryLWidth;
        }
        f += this.calcLeftExKoshikabeWidth(linkedList.getFirst());
        return f += this.calcRightExKoshikabeWidth(linkedList.getLast());
    }

    public float calcFrontKoshikabeDepth(LinkedList<TerraceInfo> linkedList, KoshikabePosType koshikabePosType) {
        float f = 0.0f;
        float f2 = 203.0f;
        if (koshikabePosType == KoshikabePosType.FRONT) {
            f = linkedList.getFirst().mDepth.floatValue() - f2;
        }
        return f;
    }

    public float calcSideKoshikabeDepth(LinkedList<TerraceInfo> linkedList, KoshikabePosType koshikabePosType) {
        float f = 0.0f;
        if (koshikabePosType == KoshikabePosType.FRONT) {
            return f;
        }
        float f2 = 203.0f;
        f = koshikabePosType == KoshikabePosType.LEFT_L ? linkedList.getFirst().mLeftDepth.floatValue() - f2 : linkedList.getLast().mRightDepth.floatValue() - f2;
        return f;
    }

    public float getKoshikabeHeight(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo) {
        return 833.0f + this.calcKoshikabeUnderPlus(basicInfo, innerDeckInfo);
    }

    public float getKoshikabeBlockHeight(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo) {
        return 793.0f + this.calcKoshikabeUnderPlus(basicInfo, innerDeckInfo);
    }

    public float getKoshikabeKasagiCapHeight(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo) {
        return 792.5f + this.calcKoshikabeUnderPlus(basicInfo, innerDeckInfo);
    }

    public float getKoshikabePillarSpacerHeight(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo) {
        return 800.0f + this.calcKoshikabeUnderPlus(basicInfo, innerDeckInfo);
    }

    public float getKoshikabeDepth() {
        return 150.0f;
    }

    public float getPillarToOutKoshikabe() {
        return 126.5f;
    }

    public float calcPillarToInKoshikabe() {
        return 23.5f;
    }

    public float configDryBottomGap() {
        return 75.0f;
    }

    private boolean judgeCoener(KoshikabePosType koshikabePosType, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = koshikabePosType == KoshikabePosType.FRONT;
        return bl && !bl2;
    }

    private TerraceWidthType calcTerraceWidthTypeByKoshikabe(LinkedList<TerraceInfo> linkedList) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mFrontKoshikabeType == KoshikabeType.NONE) continue;
            f += terraceInfo.mWidth;
        }
        return TerraceWidthType.getByDetailValue(f);
    }

    public Color convertTileColor(KoshikabeTileType koshikabeTileType) {
        CM2ColorType cM2ColorType;
        switch (koshikabeTileType) {
            case SUT_11: {
                cM2ColorType = CM2ColorType.SUT_11;
                break;
            }
            case SUT_12: {
                cM2ColorType = CM2ColorType.SUT_12;
                break;
            }
            case SUT_13: {
                cM2ColorType = CM2ColorType.SUT_13;
                break;
            }
            case HB_1: {
                cM2ColorType = CM2ColorType.HB_1;
                break;
            }
            case HB_2: {
                cM2ColorType = CM2ColorType.HB_2;
                break;
            }
            case HB_6: {
                cM2ColorType = CM2ColorType.HB_6;
                break;
            }
            case HB_7: {
                cM2ColorType = CM2ColorType.HB_7;
                break;
            }
            case SAI_1: {
                cM2ColorType = CM2ColorType.SAI_1;
                break;
            }
            case SAI_3: {
                cM2ColorType = CM2ColorType.SAI_3;
                break;
            }
            case SAI_4: {
                cM2ColorType = CM2ColorType.SAI_4;
                break;
            }
            case CRG_1: {
                cM2ColorType = CM2ColorType.CRG_1;
                break;
            }
            case CRG_2: {
                cM2ColorType = CM2ColorType.CRG_2;
                break;
            }
            case CRG_4: {
                cM2ColorType = CM2ColorType.CRG_4;
                break;
            }
            case LNS_1: {
                cM2ColorType = CM2ColorType.LNS_1;
                break;
            }
            case LNS_4: {
                cM2ColorType = CM2ColorType.LNS_4;
                break;
            }
            case MCN_1: {
                cM2ColorType = CM2ColorType.MCN_1;
                break;
            }
            case MCN_2: {
                cM2ColorType = CM2ColorType.MCN_2;
                break;
            }
            case MCN_3: {
                cM2ColorType = CM2ColorType.MCN_3;
                break;
            }
            case RCK_1: {
                cM2ColorType = CM2ColorType.RCK_1;
                break;
            }
            case RCK_3: {
                cM2ColorType = CM2ColorType.RCK_3;
                break;
            }
            case RGS_1: {
                cM2ColorType = CM2ColorType.RGS_1;
                break;
            }
            case RGS_2: {
                cM2ColorType = CM2ColorType.RGS_2;
                break;
            }
            case STN_1: {
                cM2ColorType = CM2ColorType.STN_1;
                break;
            }
            case STN_2: {
                cM2ColorType = CM2ColorType.STN_2;
                break;
            }
            case RTZ_2N: {
                cM2ColorType = CM2ColorType.RTZ_2N;
                break;
            }
            case RTZ_3N: {
                cM2ColorType = CM2ColorType.RTZ_3N;
                break;
            }
            default: {
                cM2ColorType = CM2ColorType.HB_6;
            }
        }
        return cM2ColorType.mColor;
    }

    public KoshikabeType judgeKoshikabeType(List<TerraceInfo> list) {
        for (TerraceInfo terraceInfo : list) {
            KoshikabeType koshikabeType = terraceInfo.mFrontKoshikabeType;
            if (koshikabeType != KoshikabeType.WET && koshikabeType != KoshikabeType.DRY) continue;
            return koshikabeType;
        }
        return KoshikabeType.NONE;
    }

    public boolean isKoshikabe(KoshikabeType koshikabeType, LinkedList<TerraceInfo> linkedList) {
        return koshikabeType == this.judgeKoshikabeType(linkedList);
    }

    public KoshikabePosType judgeKoshikabePosType(List<TerraceInfo> list, BasicInfo basicInfo) {
        if (this.judgeKoshikabeType(list) == KoshikabeType.NONE) {
            return null;
        }
        return basicInfo.mKoshikabePosType;
    }

    public float calcKoshikabeUnderPlus(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo) {
        if (basicInfo.mFloorType == FloorType.INNER_DECK) {
            return innerDeckInfo.mFloorLevel.floatValue();
        }
        return 0.0f;
    }

    public float calcKoshikabeFL(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo, float f) {
        if (basicInfo.mFloorType == FloorType.INNER_DECK) {
            return 0.0f;
        }
        return f;
    }

    public Float calcKoshikabeWidth(LinkedList<TerraceInfo> linkedList) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mFrontKoshikabeType == KoshikabeType.NONE) continue;
            f += terraceInfo.mWidthType.mValue;
        }
        return Float.valueOf(f);
    }

    public float getKoshikabeLToKutai(KoshikabeType koshikabeType) {
        float f = -1.0f;
        if (koshikabeType != KoshikabeType.NONE) {
            if (koshikabeType == KoshikabeType.WET) {
                f = 70.0f;
            } else if (koshikabeType == KoshikabeType.DRY) {
                f = 50.0f;
            }
        }
        return f;
    }

    public Float getPillarToInKasagi() {
        return Float.valueOf(53.5f);
    }

    private static enum KoshikabeBlockWidthType {
        T10(TerraceWidthType.T10, 2400.0f, TerraceWidthType.T10.mDetailValue + 140.0f + 60.0f, 2000.0f, TerraceWidthType.T10.mDetailValue + 70.0f + 23.5f + 60.0f, 2000.0f, TerraceWidthType.T10.mDetailValue + 70.0f + 60.0f),
        T15(TerraceWidthType.T15, 3200.0f, TerraceWidthType.T15.mDetailValue + 140.0f + 60.0f, 3000.0f, TerraceWidthType.T15.mDetailValue + 70.0f + 23.5f + 60.0f, 3000.0f, TerraceWidthType.T15.mDetailValue + 70.0f + 60.0f),
        T20(TerraceWidthType.T20, 4000.0f, TerraceWidthType.T20.mDetailValue + 140.0f + 60.0f, 3800.0f, TerraceWidthType.T20.mDetailValue + 70.0f + 23.5f + 60.0f, 3800.0f, TerraceWidthType.T20.mDetailValue + 70.0f + 60.0f),
        T25(TerraceWidthType.T25, 4800.0f, TerraceWidthType.T25.mDetailValue + 140.0f + 60.0f, 4700.0f, TerraceWidthType.T25.mDetailValue + 70.0f + 23.5f + 60.0f, 4700.0f, TerraceWidthType.T25.mDetailValue + 70.0f + 60.0f),
        T30(TerraceWidthType.T30, 6000.0f, TerraceWidthType.T30.mDetailValue + 140.0f + 60.0f, 5700.0f, TerraceWidthType.T30.mDetailValue + 70.0f + 23.5f + 60.0f, 5700.0f, TerraceWidthType.T30.mDetailValue + 70.0f + 60.0f),
        T35(TerraceWidthType.T35, 6600.0f, TerraceWidthType.T35.mDetailValue + 140.0f + 60.0f, 6600.0f, TerraceWidthType.T35.mDetailValue + 70.0f + 23.5f + 60.0f, 6600.0f, TerraceWidthType.T35.mDetailValue + 70.0f + 60.0f),
        T40(TerraceWidthType.T40, 7600.0f, TerraceWidthType.T40.mDetailValue + 140.0f + 60.0f, 7500.0f, TerraceWidthType.T40.mDetailValue + 70.0f + 23.5f + 60.0f, 7500.0f, TerraceWidthType.T40.mDetailValue + 70.0f + 60.0f),
        T45(TerraceWidthType.T45, 8600.0f, TerraceWidthType.T45.mDetailValue + 140.0f + 60.0f, 8400.0f, TerraceWidthType.T45.mDetailValue + 70.0f + 23.5f + 60.0f, 8400.0f, TerraceWidthType.T45.mDetailValue + 70.0f + 60.0f),
        T50(TerraceWidthType.T50, 9400.0f, TerraceWidthType.T50.mDetailValue + 140.0f + 60.0f, 9300.0f, TerraceWidthType.T50.mDetailValue + 70.0f + 23.5f + 60.0f, 9300.0f, TerraceWidthType.T50.mDetailValue + 70.0f + 60.0f),
        T55(TerraceWidthType.T55, 10400.0f, TerraceWidthType.T55.mDetailValue + 140.0f + 60.0f, 10200.0f, TerraceWidthType.T55.mDetailValue + 70.0f + 23.5f + 60.0f, 10200.0f, TerraceWidthType.T55.mDetailValue + 70.0f + 60.0f),
        T60(TerraceWidthType.T60, 11400.0f, TerraceWidthType.T60.mDetailValue + 140.0f + 60.0f, 11200.0f, TerraceWidthType.T60.mDetailValue + 70.0f + 23.5f + 60.0f, 11200.0f, TerraceWidthType.T60.mDetailValue + 70.0f + 60.0f);

        public TerraceWidthType mTerraceWidthType;
        public float mWetWidth;
        public float mDryWidth;
        public float mWetLWidth;
        public float mDryLWidth;
        public float mIrisumiWetWidth;
        public float mIrisumiDryWidth;

        private KoshikabeBlockWidthType(TerraceWidthType terraceWidthType, float f, float f2, float f3, float f4, float f5, float f6) {
            this.mTerraceWidthType = terraceWidthType;
            this.mWetWidth = f;
            this.mDryWidth = f2;
            this.mWetLWidth = f3;
            this.mDryLWidth = f4;
            this.mIrisumiWetWidth = f5;
            this.mIrisumiDryWidth = f6;
        }

        public static KoshikabeBlockWidthType findByTerrathWidthType(TerraceWidthType terraceWidthType) {
            KoshikabeBlockWidthType koshikabeBlockWidthType = null;
            KoshikabeBlockWidthType[] koshikabeBlockWidthTypeArray = KoshikabeBlockWidthType.values();
            int n = koshikabeBlockWidthTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KoshikabeBlockWidthType koshikabeBlockWidthType2 = koshikabeBlockWidthTypeArray[n2];
                if (koshikabeBlockWidthType2.mTerraceWidthType.equals((Object)terraceWidthType)) {
                    koshikabeBlockWidthType = koshikabeBlockWidthType2;
                    break;
                }
                ++n2;
            }
            return koshikabeBlockWidthType;
        }
    }
}

