/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.floor;

import java.util.List;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.InnerDeckInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.service.material.KoshikabeCommonService;
import option.cocoma2.service.material.SidePanelCommonService;
import option.cocoma2.type.BaseType;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.FloorType;
import option.cocoma2.type.KoshikabePosType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.RoomType;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;

public class FloorShapeCommonService {
    @GdInject
    private SidePanelCommonService mSidePanelService;
    @GdInject
    private KoshikabeCommonService mKoshikabeService;

    public FloorShapeCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public float calcLeftBasement(TerraceInfo terraceInfo, EnforcementType enforcementType) {
        float f = terraceInfo.mLeftDepth.floatValue();
        if (this.mSidePanelService.useLeftIdouHoutate(enforcementType)) {
            f = terraceInfo.mLeftDepth.floatValue() + 50.0f;
        }
        return f;
    }

    public float calcRightBasement(TerraceInfo terraceInfo, EnforcementType enforcementType) {
        float f = terraceInfo.mRightDepth.floatValue();
        if (this.mSidePanelService.useRightIdouHoutate(enforcementType)) {
            f = terraceInfo.mRightDepth.floatValue() + 50.0f;
        }
        return f;
    }

    public boolean isLeftBasementCut(TerraceInfo terraceInfo, EnforcementType enforcementType) {
        float f = this.calcLeftBasement(terraceInfo, enforcementType);
        return terraceInfo.mDepthType.mDetailValue > f;
    }

    public boolean isRightBasementCut(TerraceInfo terraceInfo, EnforcementType enforcementType) {
        float f = this.calcRightBasement(terraceInfo, enforcementType);
        return terraceInfo.mDepthType.mDetailValue > f;
    }

    public boolean hasSideBasement(TerracesInfo terracesInfo, TerraceInfo terraceInfo, BasicInfo basicInfo, InnerDeckInfo innerDeckInfo, boolean bl) {
        KoshikabeType koshikabeType = terraceInfo.mFrontKoshikabeType;
        KoshikabePosType koshikabePosType = basicInfo.mKoshikabePosType;
        switch (terraceInfo.mRoomType) {
            case SIDE_THROUGH: 
            case OPEN_TERRACE: {
                if (koshikabeType != KoshikabeType.DRY) {
                    return false;
                }
                if (bl && koshikabePosType == KoshikabePosType.LEFT_L) {
                    return true;
                }
                if (bl || koshikabePosType != KoshikabePosType.RIGHT_L) break;
                return true;
            }
            case GARDEN_ROOM: {
                if (bl && terracesInfo.mEnforcementType == EnforcementType.IRISUMI_L) {
                    return false;
                }
                if (!bl && terracesInfo.mEnforcementType == EnforcementType.IRISUMI_R) {
                    return false;
                }
                if (koshikabeType == KoshikabeType.WET) {
                    if (bl && koshikabePosType == KoshikabePosType.LEFT_L) {
                        return false;
                    }
                    if (!bl && koshikabePosType == KoshikabePosType.RIGHT_L) {
                        return false;
                    }
                }
                if (basicInfo.mFloorType == FloorType.INNER_DECK && koshikabeType == KoshikabeType.DRY && innerDeckInfo.mKoshikabeBaseType == BaseType.NONE) {
                    if (bl && koshikabePosType == KoshikabePosType.LEFT_L) {
                        return false;
                    }
                    if (!bl && koshikabePosType == KoshikabePosType.RIGHT_L) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public float calcFrontBasementSize(BasicInfo basicInfo, InnerDeckInfo innerDeckInfo, TerraceInfo ... terraceInfoArray) {
        float f = 0.0f;
        TerraceInfo[] terraceInfoArray2 = terraceInfoArray;
        int n = terraceInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceInfo terraceInfo = terraceInfoArray2[n2];
            if (!(terraceInfo.mRoomType == RoomType.OPEN_TERRACE && terraceInfo.mFrontKoshikabeType == KoshikabeType.NONE || terraceInfo.mFrontKoshikabeType == KoshikabeType.WET || basicInfo.mFloorType == FloorType.INNER_DECK && terraceInfo.mFrontKoshikabeType == KoshikabeType.DRY && innerDeckInfo.mKoshikabeBaseType == BaseType.NONE)) {
                f += terraceInfo.mWidthType.mValue;
            }
            ++n2;
        }
        return f;
    }

    public float calcFrontExBasementSize(BasicInfo basicInfo, List<TerraceInfo> list) {
        if (this.mKoshikabeService.judgeKoshikabeType(list) != KoshikabeType.DRY) {
            return 0.0f;
        }
        if (basicInfo.mFloorType == FloorType.INNER_DECK) {
            return 0.0f;
        }
        return 1.0f;
    }
}

