/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.floor;

import com.kt.annotation.Reflectable;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.TerraceDepthType;
import option.cocoma2.type.TerraceWidthType;

@Reflectable
public class DomaTileCommonService {
    private static final float EX_DOMA_WIDTH_BY_WET_KOSHIKABE = 1500.0f;
    private static final float EX_DOMA_WIDTH_BY_DRY_KOSHIKABE = 1800.0f;

    public float findDefaultDepth(float f, int n) {
        float f2 = DepthMeasure.values()[0].getDefault();
        DepthMeasure[] depthMeasureArray = DepthMeasure.values();
        int n2 = depthMeasureArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DepthMeasure depthMeasure = depthMeasureArray[n3];
            if (depthMeasure.equals(f)) {
                f2 = depthMeasure.getDefault();
            }
            ++n3;
        }
        return f2;
    }

    public final float findDefaultWidth(float f, int n, int n2, KoshikabeType koshikabeType, boolean bl, boolean bl2) {
        float f2 = this.calcWidth(koshikabeType, bl, bl2, WidthMeasure.values()[0].getDefault());
        WidthMeasure[] widthMeasureArray = WidthMeasure.values();
        int n3 = widthMeasureArray.length;
        int n4 = 0;
        while (n4 < n3) {
            WidthMeasure widthMeasure = widthMeasureArray[n4];
            if (widthMeasure.equals(f)) {
                f2 = n2 == EnforcementType.IRISUMI_R.mId || n2 == EnforcementType.IRISUMI_L.mId ? this.calcWidth(koshikabeType, bl, bl2, widthMeasure.getDefaultKatairisumi()) : this.calcWidth(koshikabeType, bl, bl2, widthMeasure.getDefault());
            }
            ++n4;
        }
        return f2;
    }

    public final float findW(float f) {
        float f2 = WidthMeasure.values()[0].getWidth();
        WidthMeasure[] widthMeasureArray = WidthMeasure.values();
        int n = widthMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            WidthMeasure widthMeasure = widthMeasureArray[n2];
            if (widthMeasure.equals(f)) {
                f2 = widthMeasure.getWidth();
            }
            ++n2;
        }
        return f2;
    }

    public final float findD(float f) {
        float f2 = DepthMeasure.values()[0].getDepth();
        DepthMeasure[] depthMeasureArray = DepthMeasure.values();
        int n = depthMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            DepthMeasure depthMeasure = depthMeasureArray[n2];
            if (depthMeasure.equals(f)) {
                f2 = depthMeasure.getDepth();
            }
            ++n2;
        }
        return f2;
    }

    public float calcExDomaTileWidthByExKoshikabe(KoshikabeType koshikabeType) {
        float f = 0.0f;
        if (koshikabeType == KoshikabeType.WET) {
            f = 1500.0f;
        } else if (koshikabeType == KoshikabeType.DRY) {
            f = 1800.0f;
        }
        return f;
    }

    private float calcWidth(KoshikabeType koshikabeType, boolean bl, boolean bl2, float f) {
        if (bl) {
            f += this.calcExDomaTileWidthByExKoshikabe(koshikabeType);
        }
        if (bl2) {
            f += this.calcExDomaTileWidthByExKoshikabe(koshikabeType);
        }
        return f;
    }

    private static enum DepthMeasure {
        D_4(TerraceDepthType.T4.mValue, TerraceDepthType.T4.mDetailValue, 2100.0f),
        D_6(TerraceDepthType.T6.mValue, TerraceDepthType.T4.mDetailValue, 2700.0f),
        D_8(TerraceDepthType.T8.mValue, TerraceDepthType.T4.mDetailValue, 3300.0f),
        D_10(TerraceDepthType.T10.mValue, TerraceDepthType.T10.mDetailValue, 3900.0f);

        private float keyDepth;
        private float depth;
        private float t;

        private DepthMeasure(float f, float f2, float f3) {
            this.keyDepth = f;
            this.depth = f2;
            this.t = f3;
        }

        private boolean equals(float f) {
            return this.keyDepth == f;
        }

        private float getDepth() {
            return this.depth;
        }

        private float getDefault() {
            return this.t;
        }
    }

    private static enum WidthMeasure {
        W_05(TerraceWidthType.T05.mValue, TerraceWidthType.T05.mDetailValue + 60.0f, 2700.0f, 1800.0f),
        W_10(TerraceWidthType.T10.mValue, TerraceWidthType.T10.mDetailValue + 60.0f, 3600.0f, 2700.0f),
        W_15(TerraceWidthType.T15.mValue, TerraceWidthType.T15.mDetailValue + 60.0f, 4500.0f, 3600.0f),
        W_20(TerraceWidthType.T20.mValue, TerraceWidthType.T20.mDetailValue + 60.0f, 5400.0f, 4500.0f),
        W_25(TerraceWidthType.T25.mValue, TerraceWidthType.T25.mDetailValue + 60.0f, 6300.0f, 5400.0f),
        W_30(TerraceWidthType.T30.mValue, TerraceWidthType.T30.mDetailValue + 60.0f, 7200.0f, 6300.0f),
        W_35(TerraceWidthType.T35.mValue, TerraceWidthType.T35.mDetailValue + 60.0f, 8100.0f, 7200.0f),
        W_40(TerraceWidthType.T40.mValue, TerraceWidthType.T40.mDetailValue + 60.0f, 9000.0f, 8100.0f),
        W_45(TerraceWidthType.T45.mValue, TerraceWidthType.T45.mDetailValue + 60.0f, 9900.0f, 9000.0f),
        W_50(TerraceWidthType.T50.mValue, TerraceWidthType.T50.mDetailValue + 60.0f, 10800.0f, 9900.0f),
        W_55(TerraceWidthType.T55.mValue, TerraceWidthType.T55.mDetailValue + 60.0f, 11700.0f, 10800.0f),
        W_60(TerraceWidthType.T60.mValue, TerraceWidthType.T60.mDetailValue + 60.0f, 12600.0f, 11700.0f);

        private float keyWidth;
        private float width;
        private float t;
        private float tKatairisumi;

        private WidthMeasure(float f, float f2, float f3, float f4) {
            this.keyWidth = f;
            this.width = f2;
            this.t = f3;
            this.tKatairisumi = f4;
        }

        private boolean equals(float f) {
            return this.keyWidth == f;
        }

        private float getWidth() {
            return this.width;
        }

        private float getDefault() {
            return this.t;
        }

        private float getDefaultKatairisumi() {
            return this.tKatairisumi;
        }
    }
}

