/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.detail.tile;

import option.cocoma2.service.detail.tile.AbstractTileDrawer;
import option.cocoma2.service.detail.tile.CeraVioRTileDrawer;
import option.cocoma2.service.detail.tile.CoLenaTileDrawer;
import option.cocoma2.service.detail.tile.HBorderTileDrawer;
import option.cocoma2.service.detail.tile.LuminosTileDrawer;
import option.cocoma2.service.detail.tile.RoughQuartzTileDrawer;
import option.cocoma2.service.detail.tile.Sabiuta2TileDrawer;
import option.cocoma2.service.detail.tile.SaimonTileDrawer;
import option.cocoma2.service.detail.tile.StoneTileDrawer;
import option.cocoma2.service.detail.tile.TileDrawer;
import option.cocoma2.type.KoshikabeTileType;

public class TileDrawerFactory {
    public TileDrawer create(KoshikabeTileType koshikabeTileType) {
        AbstractTileDrawer abstractTileDrawer = null;
        switch (koshikabeTileType) {
            case SUT_11: 
            case SUT_12: 
            case SUT_13: {
                abstractTileDrawer = new Sabiuta2TileDrawer();
                break;
            }
            case HB_1: 
            case HB_2: 
            case HB_6: 
            case HB_7: {
                abstractTileDrawer = new HBorderTileDrawer();
                break;
            }
            case SAI_1: 
            case SAI_3: 
            case SAI_4: {
                abstractTileDrawer = new SaimonTileDrawer();
                break;
            }
            case CRG_1: 
            case CRG_2: 
            case CRG_4: {
                abstractTileDrawer = new CeraVioRTileDrawer();
                break;
            }
            case LNS_1: 
            case LNS_4: {
                abstractTileDrawer = new LuminosTileDrawer();
                break;
            }
            case MCN_1: 
            case MCN_2: 
            case MCN_3: {
                abstractTileDrawer = new CoLenaTileDrawer();
                break;
            }
            case STN_1: 
            case STN_2: {
                abstractTileDrawer = new StoneTileDrawer();
                break;
            }
            case RTZ_2N: 
            case RTZ_3N: {
                abstractTileDrawer = new RoughQuartzTileDrawer();
            }
        }
        return abstractTileDrawer;
    }
}

