/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.common;

import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.type.EnforcementType;

public class EnforcementCommonService {
    public boolean isDehabaCut(TerracesInfo terracesInfo) {
        return terracesInfo.mDepthType.mDetailValue != terracesInfo.mDepth.floatValue();
    }

    public boolean isLeftDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        switch (terracesInfo.mEnforcementType) {
            case PARTIAL_IRISUMI_L: 
            case KUTAI1: {
                return true;
            }
        }
        return false;
    }

    public boolean isRightDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        switch (terracesInfo.mEnforcementType) {
            case PARTIAL_IRISUMI_R: 
            case KUTAI2: {
                return true;
            }
        }
        return false;
    }

    public boolean hasLeftOpening(EnforcementType enforcementType) {
        return enforcementType.equals((Object)EnforcementType.STANDARD) || enforcementType.equals((Object)EnforcementType.IRISUMI_R) || enforcementType.equals((Object)EnforcementType.PARTIAL_IRISUMI_R) || enforcementType.equals((Object)EnforcementType.PARTIAL_IRISUMI_L) || enforcementType.equals((Object)EnforcementType.KUTAI1) || enforcementType.equals((Object)EnforcementType.KUTAI2);
    }

    public boolean hasRightOpening(EnforcementType enforcementType) {
        return enforcementType.equals((Object)EnforcementType.STANDARD) || enforcementType.equals((Object)EnforcementType.IRISUMI_L) || enforcementType.equals((Object)EnforcementType.PARTIAL_IRISUMI_R) || enforcementType.equals((Object)EnforcementType.PARTIAL_IRISUMI_L) || enforcementType.equals((Object)EnforcementType.KUTAI1) || enforcementType.equals((Object)EnforcementType.KUTAI2);
    }

    public boolean hasSingleIrisumi(EnforcementType enforcementType) {
        return enforcementType == EnforcementType.IRISUMI_L || enforcementType == EnforcementType.IRISUMI_R;
    }

    public boolean hasNecessaryIdouhoutateEnforcementType(EnforcementType enforcementType, boolean bl) {
        if (bl && enforcementType == EnforcementType.PARTIAL_IRISUMI_L) {
            return true;
        }
        return !bl && enforcementType == EnforcementType.PARTIAL_IRISUMI_R;
    }
}

