/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service.common;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import option.cocoma2.entity.DomaTileInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.service.floor.DomaTileCommonService;
import option.cocoma2.service.material.TerraceCommonService;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.StepLocationType;
import option.cocoma2.type.StepWidthType;
import option.cocoma2.type.TerraceDepthType;
import option.cocoma2.type.TerraceWidthType;
import option.cocoma2.type.TileDetailType;
import option.cocoma2.type.TileHeightType;
import option.cocoma2.type.TileUsedType;
import option.gad.core.inject.GdInject;

@Reflectable
public class DocumentCommonService {
    @GdInject
    private DomaTileCommonService mDomaTileCommonService;
    @GdInject
    private TerraceCommonService mTerraceCommonService;

    public void initDomaTileInfo(LinkedList<TerraceInfo> linkedList, DomaTileInfo domaTileInfo) {
        domaTileInfo.mTileUsedType = TileUsedType.NONE;
        domaTileInfo.mTileType = TileDetailType.FSL_11;
        domaTileInfo.mFloorLevel = TileHeightType.FL150;
        domaTileInfo.mIsCenter = false;
        domaTileInfo.mOnInner = false;
        domaTileInfo.mWidthInputMode = false;
        domaTileInfo.mWidthInputPriority = true;
        domaTileInfo.orgwidth = -1.0f;
        domaTileInfo.orgdepth = -1.0f;
        domaTileInfo.cutWidth = 0.0f;
        domaTileInfo.cutDepth = 0.0f;
        domaTileInfo.mTotalDepth = Float.valueOf(this.mDomaTileCommonService.findDefaultDepth(TerraceDepthType.T4.mValue, RoomType.GARDEN_ROOM.mId));
        int n = EnforcementType.STANDARD.mId;
        KoshikabeType koshikabeType = this.mTerraceCommonService.findMasterTerraceInfo(linkedList).mFrontKoshikabeType;
        boolean bl = linkedList.getFirst().mHasLeftExKoshikabe;
        boolean bl2 = linkedList.getLast().mHasRightExKoshikabe;
        float f = this.mDomaTileCommonService.findDefaultWidth(TerraceWidthType.T15.mValue, RoomType.GARDEN_ROOM.mId, n, koshikabeType, bl, bl2);
        domaTileInfo.mTotalWidth = Float.valueOf(f);
        float f2 = this.mDomaTileCommonService.findW(TerraceWidthType.T15.mValue);
        float f3 = f2 - 145.0f;
        domaTileInfo.mLeftMargin = Float.valueOf(f / 2.0f - f3 / 2.0f);
        domaTileInfo.mRightMargin = Float.valueOf(f / 2.0f - f3 / 2.0f);
        domaTileInfo.stepMode = StepLocationType.NONE.mValue;
        domaTileInfo.mFrontStepDepthType = StepWidthType.F0;
        domaTileInfo.mLeftStepDepthType = StepWidthType.F0;
        domaTileInfo.mRightStepDepthType = StepWidthType.F0;
        domaTileInfo.amount = 0;
    }
}

