/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service;

import cocoma2.multispan.AbstractTerraceUnit;
import cocoma2.multispan.MultiSpanTerrace;
import java.util.LinkedList;
import java.util.List;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.service.CommonService;
import option.cocoma2.service.SidePanelService;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.SidePanelType;

public class SidePanelShapeService {
    public static SidePanelInfo findSidePanel(LinkedList<SidePanelInfo> linkedList, int n) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public static float calcPanelDepth(LinkedList<SidePanelInfo> linkedList) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType == SidePanelType.ADJUSTMENT_FIX) continue;
            f += sidePanelInfo.mWidth.floatValue();
        }
        return f += SidePanelShapeService.calcCustomWallOtherWidth(linkedList);
    }

    public static boolean hasLeftPanel(AbstractTerraceUnit abstractTerraceUnit, MultiSpanTerrace multiSpanTerrace) {
        return SidePanelShapeService.hasLeftPanel(abstractTerraceUnit, multiSpanTerrace, multiSpanTerrace.getLeftPanelInfoList());
    }

    public static boolean hasLeftPanel(AbstractTerraceUnit abstractTerraceUnit, MultiSpanTerrace multiSpanTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnit abstractTerraceUnit2 = CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
        return SidePanelShapeService.hasSidePanel(linkedList, abstractTerraceUnit, abstractTerraceUnit2);
    }

    public static boolean hasRightPanel(AbstractTerraceUnit abstractTerraceUnit, MultiSpanTerrace multiSpanTerrace) {
        return SidePanelShapeService.hasRightPanel(abstractTerraceUnit, multiSpanTerrace, multiSpanTerrace.getRightPanelInfoList());
    }

    public static boolean hasRightPanel(AbstractTerraceUnit abstractTerraceUnit, MultiSpanTerrace multiSpanTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnit abstractTerraceUnit2 = CommonService.getLastUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
        return SidePanelShapeService.hasSidePanel(linkedList, abstractTerraceUnit, abstractTerraceUnit2);
    }

    private static boolean hasSidePanel(LinkedList<SidePanelInfo> linkedList, AbstractTerraceUnit abstractTerraceUnit, AbstractTerraceUnit abstractTerraceUnit2) {
        if (linkedList.size() == 0) {
            return false;
        }
        return abstractTerraceUnit == abstractTerraceUnit2;
    }

    public static float getLeftPanelWidth(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (!SidePanelShapeService.hasLeftPanel(abstractTerraceUnit, multiSpanTerrace)) continue;
            return abstractTerraceUnit.getCx() + abstractTerraceUnit.getWidthL() - 60.0f;
        }
        return 0.0f;
    }

    public static float getRightPanelWidth(MultiSpanTerrace multiSpanTerrace) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (!SidePanelShapeService.hasRightPanel(abstractTerraceUnit, multiSpanTerrace)) continue;
            return abstractTerraceUnit.getCx() + abstractTerraceUnit.getWidthR() + 60.0f;
        }
        return 0.0f;
    }

    public static float calcLeftKutaiSidePanelY(AbstractTerraceUnit abstractTerraceUnit, LinkedList<SidePanelInfo> linkedList, float f) {
        return SidePanelShapeService.calcCommonKutaiSidePanelY(abstractTerraceUnit, linkedList, f);
    }

    public static float calcRightKutaiSidePanelY(AbstractTerraceUnit abstractTerraceUnit, LinkedList<SidePanelInfo> linkedList, float f) {
        return SidePanelShapeService.calcCommonKutaiSidePanelY(abstractTerraceUnit, linkedList, f);
    }

    private static float calcCommonKutaiSidePanelY(AbstractTerraceUnit abstractTerraceUnit, LinkedList<SidePanelInfo> linkedList, float f) {
        boolean bl = SidePanelService.isUsed(linkedList, SidePanelType.ORIDO);
        boolean bl2 = SidePanelService.isUsed(linkedList, SidePanelType.ORIDO_ADJUSTMENT_FIX);
        float f2 = -f + SidePanelService.calcGapPillarToSidePanel(bl);
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo == null) continue;
            f2 += sidePanelInfo.mWidth.floatValue();
        }
        f2 += SidePanelShapeService.calcCustomWallOtherWidth(linkedList);
        return f2 += SidePanelShapeService.calcChoseiFixOtherWidth(bl2);
    }

    private static float calcCustomWallOtherWidth(LinkedList<SidePanelInfo> linkedList) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != SidePanelType.CUSTOM_WALL) continue;
            f += 60.0f;
        }
        return f;
    }

    public static float calcChoseiFixOtherWidth(boolean bl) {
        float f = 0.0f;
        if (bl) {
            f += 27.0f;
        }
        return f;
    }

    public static double calcAngleForOpenOrido(double d, double d2, double d3) {
        double d4 = d3 / 2.0;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.asin(d4 / d5);
        double d7 = Math.atan2(d2, d);
        return d6 - d7;
    }
}

