/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service;

import cocoma2.multispan.MultiSpanTerrace;
import java.util.LinkedList;
import java.util.List;
import option.cocoma2.entity.FrontPanelOptionInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.service.FrontService;
import option.cocoma2.service.KoshikabeService;
import option.cocoma2.service.TerraceService;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.TerraceHeightType;
import option.cocoma2.type.paneloption.FrontDesignScreenHeightType;
import option.cocoma2.type.paneloption.FrontPanelOptionType;
import option.gad.core.inject.GdInject;

public class FrontPanelOptionService {
    @GdInject
    private KoshikabeService mKoshikabeService;
    @GdInject
    private TerraceService mTerraceService;

    public static boolean isUsed(MultiSpanTerrace multiSpanTerrace, FrontPanelOptionType frontPanelOptionType) {
        LinkedList<FrontPanelOptionInfo> linkedList = multiSpanTerrace.getFrontPanelOptionInfoList();
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType) continue;
            return true;
        }
        return false;
    }

    public static boolean isUsed(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType frontPanelOptionType) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType) continue;
            return true;
        }
        return false;
    }

    public static FrontPanelOptionInfo searchFrontPanelOptionInfo(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType frontPanelOptionType, int n, int n2) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType || frontPanelOptionInfo.mTerraceId != n || frontPanelOptionInfo.mIndex != n2) continue;
            return frontPanelOptionInfo;
        }
        return null;
    }

    public int getHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        FrontPanelOptionType frontPanelOptionType = frontPanelOptionInfo.mPanelOptionType;
        int n = 0;
        if (frontPanelOptionType == null) {
            return n;
        }
        switch (frontPanelOptionType) {
            case ROLL_SCREEN: 
            case MD_ROLL_SCREEN: {
                n = this.getRollScreenHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case MD_ROMAN_SHADE: {
                n = FrontPanelOptionService.getMDRomanShadeHeight(terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case FRONT_DESIGN_SCREEN: {
                n = this.frontDesignScreenHeight(list, terraceInfo, frontPanelOptionInfo);
            }
        }
        return n;
    }

    private int getRollScreenHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        TerraceHeightType terraceHeightType = terracesInfo.mHeightType;
        KoshikabeType koshikabeType = terraceInfo.mFrontKoshikabeType;
        int n = (int)FrontService.getHeightFront(terraceHeightType.mTumadarukiHeight);
        if (terraceHeightType == TerraceHeightType.LONG && koshikabeType == KoshikabeType.NONE) {
            n -= 600;
        } else if (koshikabeType != KoshikabeType.NONE || this.mTerraceService.isKoshikabeBorderSpan(list, terraceInfo, frontPanelOptionInfo.mIndex)) {
            n = (int)((float)n - 833.0f);
        }
        return n;
    }

    private static int getMDRomanShadeHeight(TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        TerraceHeightType terraceHeightType = terracesInfo.mHeightType;
        KoshikabeType koshikabeType = terraceInfo.mFrontKoshikabeType;
        int n = (int)FrontService.getHeightFront(terraceHeightType.mTumadarukiHeight);
        if (koshikabeType != KoshikabeType.NONE) {
            n = (int)((float)n - 833.0f);
        }
        return n;
    }

    private int frontDesignScreenHeight(List<TerraceInfo> list, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        FrontDesignScreenHeightType frontDesignScreenHeightType = (FrontDesignScreenHeightType)frontPanelOptionInfo.getHeightType();
        KoshikabeType koshikabeType = terraceInfo.mFrontKoshikabeType;
        int n = 0;
        n = koshikabeType == KoshikabeType.NONE && !this.mTerraceService.isKoshikabeBorderSpan(list, terraceInfo, frontPanelOptionInfo.mIndex) ? frontDesignScreenHeightType.mHeightByStandard : frontDesignScreenHeightType.mHeightByKoshikabe;
        return n;
    }
}

