/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.service;

import cocoma2.multispan.AbstractTerraceUnit;
import cocoma2.multispan.MultiSpanTerrace;
import java.util.List;
import option.cocoma2.service.TerraceService;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.TerraceDepthType;
import option.cocoma2.type.TerraceWidthType;
import option.gad.core.inject.GdInstanceFactory;

public class CommonService {
    public static float DEFAULT_TARUKI_UPPER_T4 = 342.0f;
    public static float DEFAULT_TARUKI_UPPER_T6 = 448.0f;
    public static float DEFAULT_TARUKI_UPPER_T8 = 554.0f;
    public static float DEFAULT_TARUKI_UPPER_T10 = 659.0f;

    public static float getConstH2(RoomType roomType, TerraceDepthType terraceDepthType) {
        float f = 0.0f;
        if (roomType == RoomType.GARDEN_ROOM) {
            f = terraceDepthType.mDetailTsumabari;
        } else {
            switch (terraceDepthType) {
                case T4: {
                    f = DEFAULT_TARUKI_UPPER_T4;
                    break;
                }
                case T6: {
                    f = DEFAULT_TARUKI_UPPER_T6;
                    break;
                }
                case T8: {
                    f = DEFAULT_TARUKI_UPPER_T8;
                    break;
                }
                case T10: {
                    f = DEFAULT_TARUKI_UPPER_T10;
                }
            }
        }
        return f;
    }

    public static AbstractTerraceUnit getFirstUnit(MultiSpanTerrace multiSpanTerrace, RoomType roomType) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        AbstractTerraceUnit abstractTerraceUnit = null;
        for (AbstractTerraceUnit abstractTerraceUnit2 : list) {
            if (abstractTerraceUnit2.getTerraceInfo().mRoomType != roomType || abstractTerraceUnit != null && abstractTerraceUnit2.getTerraceInfo().mId >= abstractTerraceUnit.getTerraceInfo().mId) continue;
            abstractTerraceUnit = abstractTerraceUnit2;
        }
        return abstractTerraceUnit;
    }

    public static AbstractTerraceUnit getLastUnit(MultiSpanTerrace multiSpanTerrace, RoomType roomType) {
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        AbstractTerraceUnit abstractTerraceUnit = null;
        for (AbstractTerraceUnit abstractTerraceUnit2 : list) {
            if (abstractTerraceUnit2.getTerraceInfo().mRoomType != roomType || abstractTerraceUnit != null && abstractTerraceUnit2.getTerraceInfo().mId <= abstractTerraceUnit.getTerraceInfo().mId) continue;
            abstractTerraceUnit = abstractTerraceUnit2;
        }
        return abstractTerraceUnit;
    }

    public static boolean isShortGRplusST(MultiSpanTerrace multiSpanTerrace, AbstractTerraceUnit abstractTerraceUnit) {
        if (multiSpanTerrace.getTerracesInfo().mWidthType.mId > TerraceWidthType.T30.mId) {
            return false;
        }
        if (CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM) == null) {
            return false;
        }
        return CommonService.getFirstUnit(multiSpanTerrace, RoomType.SIDE_THROUGH) != null;
    }

    public static boolean isShortOTplus(MultiSpanTerrace multiSpanTerrace, AbstractTerraceUnit abstractTerraceUnit) {
        TerraceService terraceService = (TerraceService)GdInstanceFactory.getInstance().getInstance(TerraceService.class, new Object[0]);
        if (!terraceService.isGardenRoomPlus(multiSpanTerrace.mTerraceInfoList)) {
            return false;
        }
        if (multiSpanTerrace.getTerracesInfo().mWidthType.mValue > TerraceWidthType.T30.mValue) {
            return false;
        }
        return CommonService.getFirstUnit(multiSpanTerrace, RoomType.OPEN_TERRACE) != null;
    }
}

