/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.server.dxo;

import java.util.List;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.server.type.SideType;
import option.cocoma2.type.KoshikabePosType;
import option.cocoma2.type.KoshikabeType;

public class SideTypeDxo {
    public static SideType convertRight(BasicInfo basicInfo, TerraceInfo terraceInfo, List<SidePanelInfo> list) {
        if (terraceInfo.mFrontKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.RIGHT_L) {
            return SideType.KOSHIKABE;
        }
        return SideTypeDxo.convert(list);
    }

    public static SideType convertLeft(BasicInfo basicInfo, TerraceInfo terraceInfo, List<SidePanelInfo> list) {
        if (terraceInfo.mFrontKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.LEFT_L) {
            return SideType.KOSHIKABE;
        }
        return SideTypeDxo.convert(list);
    }

    private static SideType convert(List<SidePanelInfo> list) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (SidePanelInfo sidePanelInfo : list) {
            switch (sidePanelInfo.mPanelType) {
                case ORIDO: {
                    bl = true;
                    break;
                }
                case HIKIDO: {
                    bl2 = true;
                    break;
                }
                case FIX: {
                    bl3 = true;
                    break;
                }
                case CUSTOM_WALL: {
                    bl4 = true;
                    break;
                }
            }
        }
        if (bl && (bl3 || bl4)) {
            return SideType.LACKED_ORIDO;
        }
        if (bl) {
            return SideType.ORIDO;
        }
        if (bl2) {
            return SideType.HIKIDO;
        }
        if (bl3) {
            return SideType.FIX;
        }
        if (bl4) {
            return SideType.FIX;
        }
        return SideType.NONE;
    }
}

