/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.model.util.update;

import cocoma2.multispan.AbstractTerraceUnit;
import cocoma2.multispan.MultiSpanTerrace;
import cocoma2.multispan.SidePanelProperty;
import java.util.List;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.type.TsumabariUpperType;
import option.cocoma2.type.WidthCutType;
import optoin.cocoma2.adapter.YaneColorAdapter;

public abstract class AbstractCM2TerraceUpdater {
    public void update(MultiSpanTerrace multiSpanTerrace) {
        TerracesInfo terracesInfo = multiSpanTerrace.getTerracesInfo();
        List<AbstractTerraceUnit> list = multiSpanTerrace.getUnits();
        int n = 0;
        while (n < list.size()) {
            SidePanelProperty sidePanelProperty;
            AbstractTerraceUnit abstractTerraceUnit = list.get(n);
            TerraceInfo terraceInfo = abstractTerraceUnit.getTerraceInfo();
            if (terraceInfo.mLeftTsumabariUpperType != TsumabariUpperType.NONE) {
                sidePanelProperty = new SidePanelProperty();
                abstractTerraceUnit.setLeftSide(sidePanelProperty);
                sidePanelProperty.setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mLeftTsumabariUpperMaterialType.mId));
            }
            if (terraceInfo.mRightTsumabariUpperType != TsumabariUpperType.NONE) {
                sidePanelProperty = new SidePanelProperty();
                abstractTerraceUnit.setRightSide(sidePanelProperty);
                sidePanelProperty.setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mRightTsumabariUpperMaterialType.mId));
            }
            this.updateSpunPitches(abstractTerraceUnit, terracesInfo);
            ++n;
        }
    }

    private void updateSpunPitches(AbstractTerraceUnit abstractTerraceUnit, TerracesInfo terracesInfo) {
        TerraceInfo terraceInfo = abstractTerraceUnit.getTerraceInfo();
        int n = abstractTerraceUnit.getSpanNum();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = 910.0f;
            ++n2;
        }
        if (terracesInfo.mWidthCutType != null) {
            float f = terraceInfo.mWidthType.mDetailValue - terraceInfo.mWidth;
            WidthCutType widthCutType = terracesInfo.mWidthCutType;
            switch (widthCutType) {
                case LEFT: {
                    if (abstractTerraceUnit.getPrev() != null) break;
                    fArray[0] = fArray[0] - f;
                    break;
                }
                case RIGHT: {
                    if (abstractTerraceUnit.getNext() != null) break;
                    int n3 = n - 1;
                    fArray[n3] = fArray[n3] - f;
                    break;
                }
                case BOTH: {
                    if (abstractTerraceUnit.getPrev() == null) {
                        fArray[0] = abstractTerraceUnit.getNext() == null ? fArray[0] - f / 2.0f : fArray[0] - f;
                    }
                    if (abstractTerraceUnit.getNext() != null) break;
                    if (abstractTerraceUnit.getPrev() == null) {
                        int n4 = n - 1;
                        fArray[n4] = fArray[n4] - f / 2.0f;
                        break;
                    }
                    int n5 = n - 1;
                    fArray[n5] = fArray[n5] - f;
                }
            }
        }
        abstractTerraceUnit.setPitches(fArray);
    }
}

