/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.dxo;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import option.cocoma2.dxo.CM2AbstractSaveDataConvertLogic;
import option.cocoma2.entity.CM2Infos;
import option.cocoma2.entity.paneloption.ClearWallInfo;
import option.cocoma2.entity.paneloption.CustomWallInfo;
import option.cocoma2.entity.paneloption.MDRomanShadeInfo;
import option.cocoma2.entity.paneloption.RomanShadeInfo;
import option.cocoma2.entity.v10.BasicInfoV10;
import option.cocoma2.entity.v10.CM2EstimateRowV10;
import option.cocoma2.entity.v10.DomaTileInfoV10;
import option.cocoma2.entity.v10.FloorInfoV10;
import option.cocoma2.entity.v10.FrontPanelInfoV10;
import option.cocoma2.entity.v10.FrontPanelOptionInfoV10;
import option.cocoma2.entity.v10.InnerDeckInfoV10;
import option.cocoma2.entity.v10.KiraraStageInfoV10;
import option.cocoma2.entity.v10.OptionInfoV10;
import option.cocoma2.entity.v10.SidePanelInfoV10;
import option.cocoma2.entity.v10.SidePanelOptionInfoV10;
import option.cocoma2.entity.v10.TerraceInfoV10;
import option.cocoma2.entity.v10.TerracesInfoV10;
import option.cocoma2.type.BaseType;
import option.cocoma2.type.ClearWallCapType;
import option.cocoma2.type.DeckProductType;
import option.cocoma2.type.OptionType;
import option.cocoma2.type.ProductSeriesType;
import option.cocoma2.type.TileDetailType;
import option.cocoma2.type.TileUsedType;
import option.cocoma2.type.paneloption.FrontPanelOptionType;
import option.cocoma2.type.paneloption.dxo.MDRomanShadeHeightTypeDxo;
import option.gad.core.annotation.GdVersion;

@Reflectable
@GdVersion(value="1.0")
public class CM2SaveDataConvertLogicV10
extends CM2AbstractSaveDataConvertLogic<TerracesInfoV10, TerracesInfoV10, TerraceInfoV10, Collection<TerraceInfoV10>, TerraceInfoV10, Collection<TerraceInfoV10>, BasicInfoV10, BasicInfoV10, FrontPanelInfoV10, Collection<FrontPanelInfoV10>, FrontPanelInfoV10, Collection<FrontPanelInfoV10>, SidePanelInfoV10, Collection<SidePanelInfoV10>, SidePanelInfoV10, Collection<SidePanelInfoV10>, SidePanelInfoV10, Collection<SidePanelInfoV10>, SidePanelInfoV10, Collection<SidePanelInfoV10>, FrontPanelOptionInfoV10, Collection<FrontPanelOptionInfoV10>, FrontPanelOptionInfoV10, Collection<FrontPanelOptionInfoV10>, SidePanelOptionInfoV10, Collection<SidePanelOptionInfoV10>, SidePanelOptionInfoV10, Collection<SidePanelOptionInfoV10>, SidePanelOptionInfoV10, Collection<SidePanelOptionInfoV10>, SidePanelOptionInfoV10, Collection<SidePanelOptionInfoV10>, FloorInfoV10, FloorInfoV10, DomaTileInfoV10, DomaTileInfoV10, InnerDeckInfoV10, InnerDeckInfoV10, KiraraStageInfoV10, KiraraStageInfoV10, CM2EstimateRowV10, Collection<CM2EstimateRowV10>, CM2EstimateRowV10, Collection<CM2EstimateRowV10>, OptionInfoV10, Collection<OptionInfoV10>, OptionInfoV10, Collection<OptionInfoV10>> {
    protected CM2SaveDataConvertLogicV10() {
    }

    @Override
    public void repairBefore(CM2Infos<TerracesInfoV10, Collection<TerraceInfoV10>, BasicInfoV10, Collection<FrontPanelInfoV10>, Collection<SidePanelInfoV10>, Collection<SidePanelInfoV10>, Collection<FrontPanelOptionInfoV10>, Collection<SidePanelOptionInfoV10>, Collection<SidePanelOptionInfoV10>, FloorInfoV10, DomaTileInfoV10, InnerDeckInfoV10, KiraraStageInfoV10, Collection<CM2EstimateRowV10>, Collection<OptionInfoV10>> cM2Infos) {
        this.repairRomanShade((Collection)cM2Infos.value7);
        this.repairClearWall((Collection)cM2Infos.value8, (Collection)cM2Infos.value9);
        this.repairInnerDeck((InnerDeckInfoV10)cM2Infos.value12);
        this.repairDomaTileInfo((DomaTileInfoV10)cM2Infos.value11);
        this.repairOption((Collection)cM2Infos.value15);
        this.repairDeckProductType((InnerDeckInfoV10)cM2Infos.value12);
        this.repairProductSeriesType((BasicInfoV10)cM2Infos.value3);
        this.repairPlasmacluster((Collection)cM2Infos.value5, (Collection)cM2Infos.value6);
    }

    private void repairRomanShade(Collection<FrontPanelOptionInfoV10> collection) {
        if (collection == null) {
            return;
        }
        ArrayList<RomanShadeInfo> arrayList = new ArrayList<RomanShadeInfo>();
        ArrayList<MDRomanShadeInfo> arrayList2 = new ArrayList<MDRomanShadeInfo>();
        int n = 0;
        for (FrontPanelOptionInfoV10 frontPanelOptionInfoV10 : collection) {
            if (frontPanelOptionInfoV10.mPanelOptionType != FrontPanelOptionType.ROMAN_SHADE || !(frontPanelOptionInfoV10 instanceof RomanShadeInfo)) continue;
            RomanShadeInfo romanShadeInfo = (RomanShadeInfo)frontPanelOptionInfoV10;
            MDRomanShadeInfo mDRomanShadeInfo = new MDRomanShadeInfo();
            mDRomanShadeInfo.mArrangementType = romanShadeInfo.mArrangementType;
            mDRomanShadeInfo.mProductType = romanShadeInfo.mProductType;
            mDRomanShadeInfo.mQuantity = romanShadeInfo.mQuantity;
            mDRomanShadeInfo.mTerraceId = romanShadeInfo.mTerraceId;
            mDRomanShadeInfo.mIndex = romanShadeInfo.mIndex;
            mDRomanShadeInfo.mColorType = romanShadeInfo.mColorType;
            mDRomanShadeInfo.mPanelOptionType = FrontPanelOptionType.MD_ROMAN_SHADE;
            mDRomanShadeInfo.mHeightType = MDRomanShadeHeightTypeDxo.convert(romanShadeInfo);
            arrayList.add(romanShadeInfo);
            arrayList2.add(mDRomanShadeInfo);
            ++n;
        }
        if (n < 1) {
            return;
        }
        collection.removeAll(arrayList);
        collection.addAll(arrayList2);
    }

    private void repairClearWall(Collection<SidePanelOptionInfoV10> collection, Collection<SidePanelOptionInfoV10> collection2) {
        ArrayList<SidePanelOptionInfoV10> arrayList = new ArrayList<SidePanelOptionInfoV10>();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if (collection2 != null) {
            arrayList.addAll(collection2);
        }
        for (SidePanelOptionInfoV10 sidePanelOptionInfoV10 : arrayList) {
            if (!(sidePanelOptionInfoV10 instanceof ClearWallInfo)) continue;
            ClearWallInfo clearWallInfo = (ClearWallInfo)sidePanelOptionInfoV10;
            if (clearWallInfo.mClearWallCapType != null) continue;
            clearWallInfo.mClearWallCapType = ClearWallCapType.SINGLE;
        }
    }

    private void repairInnerDeck(InnerDeckInfoV10 innerDeckInfoV10) {
        if (innerDeckInfoV10 == null) {
            return;
        }
        if (innerDeckInfoV10.mKoshikabeBaseType == null) {
            innerDeckInfoV10.mKoshikabeBaseType = BaseType.NONE;
        }
    }

    private void repairDomaTileInfo(DomaTileInfoV10 domaTileInfoV10) {
        if (domaTileInfoV10 == null) {
            return;
        }
        if (domaTileInfoV10.mTileType == TileDetailType.CNT_1 || domaTileInfoV10.mTileType == TileDetailType.CNT_2 || domaTileInfoV10.mTileType == TileDetailType.CNT_3 || domaTileInfoV10.mTileType == TileDetailType.CNT_4) {
            domaTileInfoV10.mTileUsedType = TileUsedType.NONE;
            domaTileInfoV10.mTileType = TileDetailType.FSL_11;
        }
    }

    private void repairOption(Collection<OptionInfoV10> collection) {
        if (collection == null) {
            return;
        }
        Iterator<OptionInfoV10> iterator = collection.iterator();
        while (iterator.hasNext()) {
            OptionInfoV10 optionInfoV10 = iterator.next();
            if (optionInfoV10.mId != OptionType.SYUUNOUSHIKI_MONOHOSHI.mId) continue;
            iterator.remove();
        }
    }

    private void repairDeckProductType(InnerDeckInfoV10 innerDeckInfoV10) {
        if (innerDeckInfoV10 == null) {
            return;
        }
        if (innerDeckInfoV10.mDeckProductType == null) {
            innerDeckInfoV10.mDeckProductType = DeckProductType.KIRARA_STAGE;
        }
    }

    private void repairProductSeriesType(BasicInfoV10 basicInfoV10) {
        if (basicInfoV10.mProductSeriesType == null) {
            basicInfoV10.mProductSeriesType = ProductSeriesType.COCOMA2;
        }
    }

    private void repairPlasmacluster(Collection<SidePanelInfoV10> collection, Collection<SidePanelInfoV10> collection2) {
        ArrayList<SidePanelInfoV10> arrayList = new ArrayList<SidePanelInfoV10>();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if (collection2 != null) {
            arrayList.addAll(collection2);
        }
        for (SidePanelInfoV10 sidePanelInfoV10 : arrayList) {
            if (!(sidePanelInfoV10 instanceof CustomWallInfo)) continue;
            CustomWallInfo customWallInfo = (CustomWallInfo)sidePanelInfoV10;
            if (customWallInfo.mPlasmaclusterNum == null || customWallInfo.mPlasmaclusterNum <= 0) continue;
            customWallInfo.mPlasmaclusterNum = 0;
        }
    }
}

