/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2.dao;

import java.util.Collection;
import option.cocoma2.entity.SidePanelPatternInfo;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.SidePanelComboType;
import option.cocoma2.type.StrengthType;
import option.cocoma2.type.TerraceDepthType;
import option.gad.client.dao.AbstractRemoteCsvDao;
import option.gad.core.dao.GdDao;
import option.gad.core.util.EnumUtil;

@GdDao(entity=SidePanelPatternInfo.class)
public class SidePanelPatternDao
extends AbstractRemoteCsvDao<SidePanelPatternInfo> {
    public Collection<SidePanelPatternInfo> findManyForLeft(KoshikabeType koshikabeType, EnforcementType enforcementType, SidePanelComboType sidePanelComboType, TerraceDepthType terraceDepthType, Float f) {
        if (enforcementType != EnforcementType.PARTIAL_IRISUMI_L) {
            enforcementType = EnforcementType.STANDARD;
            terraceDepthType = null;
        }
        return this.findMany(koshikabeType, enforcementType, sidePanelComboType, terraceDepthType, f);
    }

    public Collection<SidePanelPatternInfo> findManyForRight(KoshikabeType koshikabeType, EnforcementType enforcementType, SidePanelComboType sidePanelComboType, TerraceDepthType terraceDepthType, Float f) {
        if (enforcementType != EnforcementType.PARTIAL_IRISUMI_R) {
            enforcementType = EnforcementType.STANDARD;
            terraceDepthType = null;
        }
        return this.findMany(koshikabeType, enforcementType, sidePanelComboType, terraceDepthType, f);
    }

    public Collection<SidePanelPatternInfo> findMany(KoshikabeType koshikabeType, EnforcementType enforcementType, SidePanelComboType sidePanelComboType, TerraceDepthType terraceDepthType, Float f) {
        EnforcementType enforcementType2 = this.convEnforcementType(enforcementType);
        SidePanelPatternInfo sidePanelPatternInfo = new SidePanelPatternInfo();
        sidePanelPatternInfo.mKoshikabeType = EnumUtil.getId((Enum)koshikabeType);
        sidePanelPatternInfo.mEnforcementType = EnumUtil.getId((Enum)enforcementType2);
        sidePanelPatternInfo.mSidePanelComboType = EnumUtil.getId((Enum)sidePanelComboType);
        sidePanelPatternInfo.mTerraceDepthType = EnumUtil.getId((Enum)terraceDepthType);
        sidePanelPatternInfo.mDepthMin = f;
        sidePanelPatternInfo.mDepthMax = f;
        return this.findMany(sidePanelPatternInfo, new boolean[]{true, true});
    }

    public Collection<SidePanelPatternInfo> findMany(KoshikabeType koshikabeType, EnforcementType enforcementType, SidePanelComboType sidePanelComboType, float f) {
        EnforcementType enforcementType2 = this.convEnforcementType(enforcementType);
        SidePanelPatternInfo sidePanelPatternInfo = new SidePanelPatternInfo();
        sidePanelPatternInfo.mKoshikabeType = koshikabeType.mId;
        sidePanelPatternInfo.mEnforcementType = enforcementType2.mId;
        sidePanelPatternInfo.mSidePanelComboType = sidePanelComboType.mId;
        sidePanelPatternInfo.mDepthMin = Float.valueOf(f);
        sidePanelPatternInfo.mDepthMax = Float.valueOf(f);
        return this.findMany(sidePanelPatternInfo, new boolean[]{true, true});
    }

    public Collection<SidePanelPatternInfo> findMany(KoshikabeType koshikabeType, StrengthType strengthType, EnforcementType enforcementType) {
        return this.findMany(koshikabeType, strengthType, enforcementType, null);
    }

    public Collection<SidePanelPatternInfo> findMany(KoshikabeType koshikabeType, StrengthType strengthType, EnforcementType enforcementType, TerraceDepthType terraceDepthType) {
        EnforcementType enforcementType2 = this.convEnforcementType(enforcementType);
        SidePanelPatternInfo sidePanelPatternInfo = new SidePanelPatternInfo();
        sidePanelPatternInfo.mKoshikabeType = EnumUtil.getId((Enum)koshikabeType);
        sidePanelPatternInfo.mStrengthType = EnumUtil.getId((Enum)strengthType);
        sidePanelPatternInfo.mEnforcementType = EnumUtil.getId((Enum)enforcementType2);
        sidePanelPatternInfo.mSidePanelComboType = EnumUtil.getId((Enum)this.detectSidePanelComboType(koshikabeType));
        sidePanelPatternInfo.mTerraceDepthType = EnumUtil.getId((Enum)terraceDepthType);
        return this.findMany(sidePanelPatternInfo, new boolean[]{true, true});
    }

    private EnforcementType convEnforcementType(EnforcementType enforcementType) {
        EnforcementType enforcementType2 = null;
        enforcementType2 = enforcementType == EnforcementType.PARTIAL_IRISUMI_L || enforcementType == EnforcementType.PARTIAL_IRISUMI_R ? enforcementType : EnforcementType.STANDARD;
        return enforcementType2;
    }

    private SidePanelComboType detectSidePanelComboType(KoshikabeType koshikabeType) {
        SidePanelComboType sidePanelComboType = SidePanelComboType.ORIDO;
        if (koshikabeType != KoshikabeType.NONE) {
            sidePanelComboType = SidePanelComboType.KOSHIKABE_FIX;
        }
        return sidePanelComboType;
    }
}

