/*
 * Decompiled with CFR 0.152.
 */
package option.cocoma2;

import java.awt.Color;
import option.cocoma2.type.CM2ColorType;
import option.cocoma2.type.paneloption.FrontPanelOptionType;
import option.cocoma2.type.paneloption.SidePanelOptionType;

public class CM2Color {
    public static final int COLOR_AB = 0;
    public static final int COLOR_IW = 1;
    public static final int COLOR_SC = 2;
    public static final int COLOR_BAROQUE_TEAK = 3;
    public static final int COLOR_ITALIAN_WALNUT = 4;
    public static final int COLOR_PERSIMMON_TANNIN = 5;
    public static final int COLOR_Silver = 6;
    public static final int COLOR_MILD_BLACK = 7;
    public static final int COLOR_NATURAL_SILVER_F = 8;
    public static final int COLOR_PURE_NORCHE = 9;
    public static final int COLOR_SILKY_IVORY = 10;
    public static final int COLOR_CLIE_PALE = 11;
    public static final int COLOR_CLIE_RUSK = 12;
    public static final int COLOR_CLIE_MOCHA = 13;
    public static final int COLOR_CLIE_DARK = 14;
    public static final int COLOR_OAK = 15;
    public static final int COLOR_CHERRY_WOOD = 16;
    public static final int COLOR_RUSTIC_OAK_E = 17;
    public static final int[] values;
    public static final String[] descs;
    private static Color[] colors;

    static {
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        values = nArray;
        descs = new String[]{"\u30aa\u30fc\u30bf\u30e0\u30d6\u30e9\u30a6\u30f3", "\u30db\u30ef\u30a4\u30c8", "\u30b7\u30e3\u30a4\u30f3\u30b0\u30ec\u30fc", "\u30d0\u30ed\u30c3\u30af\u30c1\u30fc\u30af", "\u30a4\u30bf\u30ea\u30a2\u30f3\u30a6\u30a9\u30fc\u30eb\u30ca\u30c3\u30c8", "\u67ff\u6e0b", "\u30b7\u30eb\u30d0\u30fc", "\u30de\u30a4\u30eb\u30c9\u30d6\u30e9\u30c3\u30af", "\u30ca\u30c1\u30e5\u30e9\u30eb\u30b7\u30eb\u30d0\u30fcF", "\u30d4\u30e5\u30a2\u30ce\u30fc\u30c1\u30a7", "\u30b7\u30eb\u30ad\u30fc\u30a2\u30a4\u30dc\u30ea\u30fc", "\u30af\u30ea\u30a8\u30da\u30fc\u30eb", "\u30af\u30ea\u30a8\u30e9\u30b9\u30af", "\u30af\u30ea\u30a8\u30e2\u30ab", "\u30af\u30ea\u30a8\u30c0\u30fc\u30af", "\u30aa\u30fc\u30af", "\u30c1\u30a7\u30ea\u30fc\u30a6\u30c3\u30c9", "\u30e9\u30b9\u30c6\u30a3\u30c3\u30af\u30aa\u30fc\u30af"};
        colors = new Color[values.length];
        CM2Color.colors[0] = new Color(106, 86, 77);
        CM2Color.colors[1] = new Color(245, 245, 223);
        CM2Color.colors[2] = new Color(199, 189, 177);
        CM2Color.colors[3] = new Color(116, 88, 85);
        CM2Color.colors[4] = new Color(198, 184, 117);
        CM2Color.colors[5] = new Color(92, 63, 44);
        CM2Color.colors[6] = new Color(100, 100, 100);
        CM2Color.colors[7] = new Color(46, 46, 46);
        CM2Color.colors[8] = new Color(225, 225, 225);
        CM2Color.colors[9] = new Color(195, 150, 109);
        CM2Color.colors[10] = new Color(236, 224, 208);
        CM2Color.colors[11] = new Color(219, 193, 121);
        CM2Color.colors[12] = new Color(178, 108, 49);
        CM2Color.colors[13] = new Color(76, 42, 23);
        CM2Color.colors[14] = new Color(48, 27, 15);
        CM2Color.colors[15] = new Color(196, 167, 132);
        CM2Color.colors[16] = new Color(148, 115, 73);
        CM2Color.colors[17] = new Color(111, 97, 76);
    }

    public static void setColor(int n, Color color) {
        int n2 = 0;
        while (n2 < values.length) {
            if (values[n2] == n) {
                CM2Color.colors[n2] = color;
                return;
            }
            ++n2;
        }
    }

    public static Color getColor(int n) {
        int n2 = 0;
        while (n2 < values.length) {
            if (values[n2] == n) {
                return colors[n2];
            }
            ++n2;
        }
        return Color.WHITE;
    }

    public static Color getFrontPanelOptionColor(FrontPanelOptionType frontPanelOptionType, CM2ColorType cM2ColorType) {
        if (cM2ColorType == null) {
            return Color.white;
        }
        switch (frontPanelOptionType) {
            case ROLL_SCREEN: 
            case MD_ROLL_SCREEN: 
            case MD_ROMAN_SHADE: {
                return cM2ColorType.mColor;
            }
            case FRONT_DESIGN_SCREEN: {
                return CM2Color.getWrappingColor(cM2ColorType);
            }
        }
        return Color.white;
    }

    public static Color getFrontPanelOptionColor2(FrontPanelOptionType frontPanelOptionType, CM2ColorType cM2ColorType, CM2ColorType cM2ColorType2) {
        switch (frontPanelOptionType) {
            case ROLL_SCREEN: 
            case MD_ROMAN_SHADE: {
                return CM2Color.getMaterialColor(cM2ColorType2);
            }
            case MD_ROLL_SCREEN: {
                return CM2Color.getColor(2);
            }
            case FRONT_DESIGN_SCREEN: {
                return CM2Color.getWrappingColor(cM2ColorType);
            }
        }
        return CM2Color.getColor(2);
    }

    public static Color getSidePanelOptionColor(SidePanelOptionType sidePanelOptionType, CM2ColorType cM2ColorType) {
        switch (sidePanelOptionType) {
            case CLEAR_WALL: {
                return CM2Color.getWrappingColor(cM2ColorType);
            }
        }
        return CM2Color.getColor(2);
    }

    public static Color getSideCustomWallColor(CM2ColorType cM2ColorType) {
        Color color = CM2Color.getWrappingColor(cM2ColorType);
        if (color == colors[2] || color == colors[1]) {
            color = colors[13];
        }
        return color;
    }

    private static Color getWrappingColor(CM2ColorType cM2ColorType) {
        switch (cM2ColorType) {
            case SHINE_GRAY: {
                return colors[2];
            }
            case CLIE_MOCHA: 
            case SHINE_GRAY_CLIE_MOCHA: 
            case IVORY_WHITE_CLIE_MOCHA: {
                return colors[13];
            }
            case CLIE_DARK: 
            case SHINE_GRAY_CLIE_DARK: 
            case IVORY_WHITE_CLIE_DARK: {
                return colors[14];
            }
            case IVORY_WHITE: {
                return colors[1];
            }
            case OAK: 
            case SHINE_GRAY_OAK: 
            case IVORY_WHITE_OAK: {
                return colors[15];
            }
            case CHERRY_WOOD: 
            case SHINE_GRAY_CHERRY_WOOD: 
            case IVORY_WHITE_CHERRY_WOOD: {
                return colors[16];
            }
            case RUSTIC_OAK_E: 
            case SHINE_GRAY_RUSTIC_OAK_E: 
            case IVORY_WHITE_RUSTIC_OAK_E: {
                return colors[17];
            }
            case CLIE_PALE: 
            case SHINE_GRAY_CLIE_PALE: 
            case IVORY_WHITE_CLIE_PALE: {
                return colors[11];
            }
            case CLIE_RUSK: 
            case SHINE_GRAY_CLIE_RUSK: 
            case IVORY_WHITE_CLIE_RUSK: {
                return colors[12];
            }
            case SILKY_IVORY: 
            case IVORY_WHITE_SILKY_IVORY: 
            case SHINE_GRAY_SILKY_IVORY: {
                return colors[10];
            }
        }
        return colors[1];
    }

    private static Color getMaterialColor(CM2ColorType cM2ColorType) {
        switch (cM2ColorType) {
            case IVORY_WHITE: 
            case IVORY_WHITE_CLIE_MOCHA: 
            case IVORY_WHITE_CLIE_DARK: 
            case IVORY_WHITE_OAK: 
            case IVORY_WHITE_CHERRY_WOOD: 
            case IVORY_WHITE_RUSTIC_OAK_E: {
                return colors[1];
            }
            case SHINE_GRAY: 
            case SHINE_GRAY_CLIE_MOCHA: 
            case SHINE_GRAY_CLIE_DARK: 
            case SHINE_GRAY_OAK: 
            case SHINE_GRAY_CHERRY_WOOD: 
            case SHINE_GRAY_RUSTIC_OAK_E: {
                return colors[2];
            }
            case CLIE_MOCHA: {
                return colors[13];
            }
            case CLIE_DARK: {
                return colors[14];
            }
            case OAK: {
                return colors[15];
            }
            case CHERRY_WOOD: {
                return colors[16];
            }
            case RUSTIC_OAK_E: {
                return colors[17];
            }
        }
        return colors[2];
    }

    public static Color getAmadoiColor(CM2ColorType cM2ColorType) {
        switch (cM2ColorType) {
            case SHINE_GRAY: {
                return colors[0];
            }
            case IVORY_WHITE: {
                return colors[1];
            }
        }
        return colors[0];
    }
}

