/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollBar;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KKeyEvent;
import jp.kitec.kwt.KMouseEvent;
import jp.kitec.kwt.KViewPort;
import jp.kitec.richui.AScrollBar;
import nethome.NethomeLookAndFeel;
import nethome.doc.Project;
import nethome.ui.Canvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.CanvasRedrawTimer;
import nethome.ui.command.Command;
import nethome.ui.command.ICommandInfo;
import option.gad.client.util.NetHomeUtil;

public class ComViewControl
extends Command
implements ActionListener,
MouseListener,
KeyListener,
AdjustmentListener {
    public JScrollBar mVert;
    public JScrollBar mHor;
    public AScrollBar mZoom;
    private boolean mIsUpdateNow = false;
    private short mFinalMode = (short)-1;
    private CanvasRedrawTimer mTimer = null;

    public void play() {
    }

    public void updateInterface() {
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return;
        }
        Project project = canvas2D.getProject();
        Area area = project.getCurrentLayer().getWorkSheet().getArea();
        KViewPort kViewPort = canvas2D.mAbstCanvas.getViewPort();
        int n = 30;
        int n2 = this.mHor.getSize().width;
        int n3 = this.mVert.getSize().height;
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n4 = Math.round((area.maxX - area.minX) * (float)n / (float)n2 / (float)(1 - n / n2));
        int n5 = Math.round((area.maxY - area.minY) * (float)n / (float)n3 / (float)(1 - n / n3));
        int n6 = Math.round(kViewPort.cx);
        int n7 = Math.round(area.maxY - kViewPort.cy);
        if ((float)n6 > area.maxX) {
            n6 = (int)area.maxX;
        } else if ((float)n6 < area.minX) {
            n6 = (int)area.minX;
        }
        if ((float)n7 > area.maxY) {
            n7 = (int)area.maxY;
        } else if ((float)n7 < area.minY) {
            n7 = (int)area.minY;
        }
        this.mIsUpdateNow = true;
        this.mVert.setValues(n7, n5, (int)area.minY, (int)(area.maxY + (float)n5));
        this.mHor.setValues(n6, n4, (int)area.minX, (int)(area.maxX + (float)n4));
        this.mIsUpdateNow = false;
        this.mZoom.setValues(50.0f, 500.0f, (float)canvas2D.getZoomRatio());
        this.mZoom.setInterval(100.0f, 100.0f, "%");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return;
        }
        if (this.mFinalMode < 0) {
            this.mFinalMode = canvas2D.getDrawMode();
        }
        if (actionEvent.getSource() == this.mZoom) {
            if (actionEvent.getActionCommand() == "DRAG") {
                canvas2D.setDrawMode((short)2);
            }
            canvas2D.setZoomAsScale(this.mZoom.getValue());
        }
        if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equalsIgnoreCase("FINAL")) {
            canvas2D.setDrawMode(this.mFinalMode);
            this.mFinalMode = (short)-1;
        } else {
            canvas2D.setDrawMode((short)2);
        }
        canvas2D.forceImageUpdate();
        canvas2D.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.mIsUpdateNow) {
            return;
        }
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return;
        }
        if (adjustmentEvent.getSource() == this.mHor || adjustmentEvent.getSource() == this.mVert) {
            if (adjustmentEvent.getSource() == this.mHor) {
                if (this.mHor.getValueIsAdjusting()) {
                    canvas2D.setDrawMode((short)2);
                } else {
                    canvas2D.setDrawMode((short)0);
                }
            } else if (this.mVert.getValueIsAdjusting()) {
                canvas2D.setDrawMode((short)2);
            } else {
                canvas2D.setDrawMode((short)0);
            }
            float f = this.mHor.getValue();
            float f2 = this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount();
            canvas2D.mAbstCanvas.setViewCenter(f, f2);
            Graphics graphics = canvas2D.getGraphics();
            canvas2D.forceImageUpdate();
            canvas2D.update(graphics);
            graphics.dispose();
        }
    }

    private Canvas2D getTargetCanvas() {
        Object t = NetHomeUtil.getActiveCanvas();
        return t;
    }

    public Component createComponent(ICommandInfo iCommandInfo) {
        super.createComponent(iCommandInfo);
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        this.mZoom = new AScrollBar(AScrollBar.MODE_HOR, true, false, mainComponent.getApplication().getImageObserver(), KColor.lightGray2, true, mainComponent.getTipsMessage());
        this.mZoom.setBackground(NethomeLookAndFeel.TOOLBAR_BACK_DEF_COLOR);
        this.mZoom.setPrefSize(150, 26);
        this.mHor = new JScrollBar(0);
        this.mHor.addAdjustmentListener(this);
        this.mHor.addMouseListener(this);
        this.mHor.setBlockIncrement(500);
        this.mHor.setUnitIncrement(500);
        this.mVert = new JScrollBar(1);
        this.mVert.addAdjustmentListener(this);
        this.mVert.addMouseListener(this);
        this.mVert.setBlockIncrement(500);
        this.mVert.setUnitIncrement(500);
        this.mZoom.setOffset(25.0f, 0.0f);
        this.mZoom.addActionListener((ActionListener)this);
        this.updateInterface();
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void wheelUp(int n, int n2, int n3) {
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setDrawMode((short)2);
        this.mIsUpdateNow = true;
        this.timerSet(canvas2D);
        float f = canvas2D.mAbstCanvas.getViewPort().cx;
        float f2 = canvas2D.mAbstCanvas.getViewPort().cy;
        if (KMouseEvent.isCtrlButtonMask((int)n3)) {
            float f3 = canvas2D.mAbstCanvas.devToRealX(n);
            float f4 = canvas2D.mAbstCanvas.devToRealY(n2);
            this.mZoom.inc();
            canvas2D.setZoomAsScale(this.mZoom.getValue());
            float f5 = canvas2D.mAbstCanvas.devToRealX(n);
            float f6 = canvas2D.mAbstCanvas.devToRealY(n2);
            canvas2D.mAbstCanvas.setViewCenter(f += f3 - f5, f2 += f4 - f6);
        } else if (KMouseEvent.isShiftButtonMask((int)n3)) {
            this.updown(this.mHor, -1);
        } else {
            this.updown(this.mVert, 1);
        }
        this.mIsUpdateNow = false;
        canvas2D.forceImageUpdate();
        canvas2D.updateViewControl();
        canvas2D.repaint();
        mainComponent.updateUserInterface();
    }

    public void wheelDown(int n, int n2, int n3) {
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return;
        }
        this.mIsUpdateNow = true;
        canvas2D.setDrawMode((short)2);
        this.timerSet(canvas2D);
        float f = canvas2D.mAbstCanvas.getViewPort().cx;
        float f2 = canvas2D.mAbstCanvas.getViewPort().cy;
        if (KMouseEvent.isCtrlButtonMask((int)n3)) {
            float f3 = canvas2D.mAbstCanvas.devToRealX(n);
            float f4 = canvas2D.mAbstCanvas.devToRealY(n2);
            this.mZoom.dec();
            canvas2D.setZoomAsScale(this.mZoom.getValue());
            float f5 = canvas2D.mAbstCanvas.devToRealX(n);
            float f6 = canvas2D.mAbstCanvas.devToRealY(n2);
            canvas2D.mAbstCanvas.setViewCenter(f += f3 - f5, f2 += f4 - f6);
        } else if (KMouseEvent.isShiftButtonMask((int)n3)) {
            this.updown(this.mHor, 1);
        } else {
            this.updown(this.mVert, -1);
        }
        this.mIsUpdateNow = false;
        canvas2D.forceImageUpdate();
        canvas2D.updateViewControl();
        canvas2D.repaint();
        mainComponent.updateUserInterface();
    }

    public boolean keyPress(int n, int n2) {
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D == null) {
            return false;
        }
        if (KKeyEvent.isMutchKey((int)n, (String)"UP")) {
            this.updown(this.mVert, 1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"DOWN")) {
            this.updown(this.mVert, -1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"LEFT")) {
            this.updown(this.mHor, -1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"RIGHT")) {
            this.updown(this.mHor, 1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"PAGE_UP")) {
            this.mZoom.inc();
            canvas2D.setZoomAsScale(this.mZoom.getValue());
        } else if (KKeyEvent.isMutchKey((int)n, (String)"PAGE_DOWN")) {
            this.mZoom.dec();
            canvas2D.setZoomAsScale(this.mZoom.getValue());
        } else if (KKeyEvent.isMutchKey((int)n, (String)"HOME")) {
            canvas2D.resetView();
        } else {
            return false;
        }
        canvas2D.updateViewControl();
        canvas2D.forceImageUpdate();
        canvas2D.repaint();
        return true;
    }

    private void updown(Object object, int n) {
        Canvas2D canvas2D = this.getTargetCanvas();
        KViewPort kViewPort = canvas2D.mAbstCanvas.getViewPort();
        float f = kViewPort.cx;
        float f2 = kViewPort.cy;
        if (object == this.mVert) {
            if (n > 0) {
                this.mVert.setValue(this.mVert.getValue() - this.mVert.getBlockIncrement());
                canvas2D.mAbstCanvas.setViewCenter(f, (float)(this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount()));
            } else {
                this.mVert.setValue(this.mVert.getValue() + this.mVert.getBlockIncrement());
                canvas2D.mAbstCanvas.setViewCenter(f, (float)(this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount()));
            }
        } else if (object == this.mHor) {
            if (n > 0) {
                this.mHor.setValue(this.mHor.getValue() + this.mHor.getBlockIncrement());
                canvas2D.mAbstCanvas.setViewCenter((float)this.mHor.getValue(), f2);
            } else {
                this.mHor.setValue(this.mHor.getValue() - this.mHor.getBlockIncrement());
                canvas2D.mAbstCanvas.setViewCenter((float)this.mHor.getValue(), f2);
            }
        }
    }

    private void timerSet(Canvas2D canvas2D) {
        if (this.mTimer != null) {
            if (this.mTimer.isRunning()) {
                this.mTimer.setCount(2);
            } else {
                this.mTimer = null;
            }
        }
        if (this.mTimer == null) {
            this.mTimer = new CanvasRedrawTimer(canvas2D, 200);
            this.mTimer.setCount(2);
            this.mTimer.start();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyPress(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void initInterface() {
        Canvas2D canvas2D = this.getTargetCanvas();
        if (canvas2D != null) {
            this.mZoom.setOffset(10.0f, 0.0f);
        }
    }
}

