/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwtex.sumnail;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import jp.kitec.kwt.KVFlowLayout;
import jp.kitec.kwt.util.ImageTool;
import jp.kitec.kwtex.sumnail.SumDirControl;
import jp.kitec.richui.ImagePanel;
import nethome.NethomeLookAndFeel;
import nethome.NethomeResource;
import nethome.geom.primitive.Geometory;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import option.gad.client.util.NetHomeUtil;

public class Sumnail
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final String ROTATE = "ROT";
    protected String mCommand = null;
    protected Geometory mObj;
    protected boolean mEnter;
    protected boolean mActive = false;
    protected ActionListener mActionListener;
    protected SumDirControl mSumControl;
    protected Image img;
    protected Image mOffI = null;
    protected Graphics mOffG = null;
    protected int imageW = 70;
    protected int imageH = 70;
    protected ImagePanel mImagePanel;
    protected static int ofh = 0;
    protected boolean mFlipX;
    protected boolean mFlipY;
    protected boolean mRotable = true;
    protected Color mBack;
    protected KRichGraphics mGraphics;
    protected Command mCom;

    public Sumnail(MainComponent mainComponent, KRichGraphics kRichGraphics, Command command, String string, short s, Geometory geometory, SumDirControl sumDirControl, Color color) {
        this.mCom = command;
        this.mBack = color;
        this.mSumControl = sumDirControl;
        this.mEnter = false;
        this.mGraphics = kRichGraphics;
        this.mRotable = (s & 4) != 0;
        this.mFlipX = (s & 1) != 0;
        this.mFlipY = (s & 2) != 0;
        this.mObj = geometory;
        this.mImagePanel = new ImagePanel();
        this.updateImage();
        this.setLayout((LayoutManager)new KVFlowLayout(0, 2));
        this.add((Component)this.mImagePanel);
        ImageTool imageTool = MainComponent.getInstance().getImageTool();
        Image image = imageTool.createStrImage(string, NethomeResource.mDefFont, Color.black, color, 0, 8, 4);
        this.add((Component)new ImagePanel(image, (Container)MainComponent.getInstance()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mImagePanel.addMouseMotionListener((MouseMotionListener)this);
        this.mImagePanel.addMouseListener((MouseListener)this);
        this.setBackground(this.mBack);
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListener = actionListener;
    }

    public Object getGeom() {
        return this.mObj;
    }

    protected int getImageW() {
        return this.imageW;
    }

    protected int getImageH() {
        return this.imageH;
    }

    protected void update() {
        Color color = null;
        int n = 0;
        boolean bl = true;
        if (this.mActive) {
            color = NethomeLookAndFeel.SUMNAIL_ACTIVE_COLOR;
            bl = false;
            n = 1;
        } else if (this.mEnter) {
            color = NethomeLookAndFeel.SUMNAIL_HILIGHT_COLOR;
            bl = true;
            n = 0;
        }
        if (!NethomeLookAndFeel.SUMNAIL_FRAME_3D) {
            n = 0;
        }
        this.mOffG.drawImage(this.img, n, n, null);
        if (color != null) {
            this.mOffG.setColor(color);
            int n2 = 0;
            while (n2 < NethomeLookAndFeel.SUMNAIL_FRAME_WIDTH) {
                if (NethomeLookAndFeel.SUMNAIL_FRAME_3D) {
                    this.mOffG.draw3DRect(n2, n2, this.getImageW() - 1 - n2 * 2, this.getImageH() - 1 + ofh - n2 * 2, bl);
                } else {
                    this.mOffG.drawRect(n2, n2, this.getImageW() - 1 - n2 * 2, this.getImageH() - 1 + ofh - n2 * 2);
                }
                ++n2;
            }
        }
        if (this.mEnter) {
            this.mSumControl.paint(this.mOffG, this.mRotable, this.mFlipX, this.mFlipY);
        }
        this.mImagePanel.repaint();
    }

    protected void updateImage() {
        if (this.img != null) {
            this.img.flush();
        }
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        Container container = mainComponent.getImageTool().getObserver();
        this.img = container.createImage(this.getImageW(), this.getImageH());
        Graphics graphics = this.img.getGraphics();
        graphics.setColor(this.mBack);
        graphics.fillRect(0, 0, this.getImageW(), this.getImageH());
        this.mGraphics.setGC(graphics);
        this.mGraphics.setSize(this.getImageW(), this.getImageH());
        Area area = this.mObj.getArea();
        float f = area.maxX - area.minX > area.maxY - area.minY ? area.maxX - area.minX : area.maxY - area.minY;
        float f2 = f / 4.0f;
        this.mGraphics.setView(this.mObj.getArea().minX - f2, this.mObj.getArea().minY - f2, this.mObj.getArea().maxX + f2, this.mObj.getArea().maxY + f2);
        this.mGraphics.setViewCenter((this.mObj.getArea().minX + this.mObj.getArea().maxX) / 2.0f, (this.mObj.getArea().minY + this.mObj.getArea().maxY) / 2.0f);
        this.mObj.setGeomColor(Color.black);
        this.mObj.drawGeom((IRichGraphics)this.mGraphics);
        graphics.dispose();
        if (this.img != null) {
            this.mOffI = container.createImage(this.getImageW(), this.getImageH());
            this.mOffG = this.mOffI.getGraphics();
            this.mOffG.drawImage(this.img, 0, 0, null);
            this.mImagePanel.setImage(this.mOffI, this.getImageW(), this.getImageH());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mEnter = true;
        this.update();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mEnter = false;
        this.update();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        NetHomeUtil.getMainComponent();
        Object t = NetHomeUtil.getActiveCanvas();
        try {
            Point point = this.getLocationOnScreen();
            Point point2 = t.getLocationOnScreen();
            int n = point.x + mouseEvent.getPoint().x - point2.x;
            int n2 = point.y + mouseEvent.getPoint().y - point2.y;
            t.getCurrentMousePos().x = n;
            t.getCurrentMousePos().y = n2;
        }
        catch (Exception exception) {}
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        NetHomeUtil.getMainComponent();
        Object t = NetHomeUtil.getActiveCanvas();
        Point point = this.getLocationOnScreen();
        Point point2 = t.getLocationOnScreen();
        point = this.mImagePanel.getLocationOnScreen();
        int n = point.x + mouseEvent.getPoint().x - point2.x;
        int n2 = point.y + mouseEvent.getPoint().y - point2.y;
        this.mCom.mouseMove(n, n2, 0);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        short s = this.mSumControl.isInner(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        switch (s) {
            case 4: {
                this.mCommand = ROTATE;
                this.rachet(this.mObj);
                this.updateImage();
                break;
            }
            case 1: {
                this.mCommand = ROTATE;
                this.flipx(this.mObj);
                this.updateImage();
                break;
            }
            case 2: {
                this.mCommand = ROTATE;
                this.flipy(this.mObj);
                this.updateImage();
                break;
            }
            case 8: {
                this.mCommand = ROTATE;
                break;
            }
            default: {
                this.mCommand = null;
            }
        }
        this.press();
        this.action();
        this.mouseDragged(mouseEvent);
        this.update();
    }

    protected void press() {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        Object t = NetHomeUtil.getActiveCanvas();
        Point point = this.getLocationOnScreen();
        Point point2 = t.getLocationOnScreen();
        int n = point.x + mouseEvent.getPoint().x - point2.x;
        int n2 = point.y + mouseEvent.getPoint().y - point2.y;
        if (n > 0 && n2 > 0 && n < t.getSize().width && n2 < t.getSize().height) {
            this.mCom.mouseRelease(n, n2, 0);
            this.mEnter = false;
            this.mActive = false;
        } else {
            this.mCom.end();
            t.repaint();
        }
        this.update();
        if (this.mSumControl.isInner(mouseEvent.getPoint().x, mouseEvent.getPoint().y) == 0) {
            t.setMouseCommand(null);
            mainComponent.updateUserInterface();
        }
    }

    protected void action() {
        if (this.mActionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 0, this.mCommand);
            this.mActionListener.actionPerformed(actionEvent);
        }
    }

    protected void rachet(Geometory geometory) {
    }

    protected void flipx(Geometory geometory) {
    }

    protected void flipy(Geometory geometory) {
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setActive(boolean bl) {
        this.mActive = bl;
    }
}

