/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwtex;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import jp.kitec.richui.TipsMessage;
import nethome.ui.gui.NethomeCommonDialog;

public class KProgressBar
extends NethomeCommonDialog
implements TipsMessage {
    private Label mMessage;
    private Label mMsgLabel;
    private MsgThread mThread;
    private long mInterval;

    public KProgressBar(Frame frame, String string, int n) {
        this(frame, string, n, 750L);
    }

    public KProgressBar(Frame frame, String string, int n, long l) {
        super(frame, string, false);
        this.mInterval = l;
        this.mMsgLabel = this.createProgressComponent(n);
        Panel panel = new Panel();
        panel.setBackground(this.getBackground());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagLayout.setConstraints(this.mMsgLabel, gridBagConstraints);
        panel.add(this.mMsgLabel);
        this.setUI(panel);
    }

    private Label createProgressComponent(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal progressbar length " + n + " <= 0");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\u25a0");
            ++n2;
        }
        Label label = new Label(stringBuffer.toString());
        label.setForeground(new Color(8, 36, 107));
        return label;
    }

    private void setMesssage(String string) {
        this.mMsgLabel.setText(string);
        this.mMsgLabel.repaint();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.stopMessage();
        }
        super.setVisible(bl);
    }

    public void setVisible(boolean bl, Component component, int n) {
        if (bl) {
            this.startMessage();
        }
        super.setVisible(bl, component, n);
    }

    private void startMessage() {
        if (this.mThread != null) {
            this.stopMessage();
        }
        this.mThread = new MsgThread(this.mMsgLabel.getText(), this.mInterval);
        this.mMsgLabel.setText("");
        this.mThread.start();
    }

    private void stopMessage() {
        if (this.mThread != null) {
            this.mThread.stopShowing();
            this.mThread = null;
        }
    }

    public void close() {
    }

    public Component getComponenet() {
        return this.mMessage;
    }

    public String getNullMessage() {
        return "";
    }

    public void setMessage(String string) {
        this.mMessage.setText(string);
    }

    public void setNullMessage(String string) {
    }

    public void update() {
        this.pack();
    }

    private class MsgThread
    extends Thread {
        private final String mMsg;
        private final int mMax;
        private int mLen;
        private boolean mShowing;

        public MsgThread(String string, long l) {
            this.mMsg = string;
            this.mMax = this.mMsg.length();
            this.mLen = 0;
            KProgressBar.this.mInterval = l;
        }

        public synchronized void stopShowing() {
            this.mShowing = false;
        }

        private synchronized boolean isShowing() {
            return this.mShowing;
        }

        @Override
        public void run() {
            this.mShowing = true;
            while (this.isShowing()) {
                if (this.mLen > this.mMax) {
                    this.mLen = 0;
                }
                KProgressBar.this.setMesssage(this.mMsg.substring(0, this.mLen));
                ++this.mLen;
                try {
                    MsgThread.sleep(750L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

