/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.gui.event.CallBackListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import javax.swing.JTextField;
import jp.kitec.kwt.JTFKeyAdapter;

class KLimitedNumberFieldC
extends JTextField
implements FocusListener {
    private static short mInputMode = 0;
    private double mMin = 0.0;
    private double mMax = 0.0;
    private double mLastValue;
    private Object mCallbackSource;
    private JTFKeyAdapter mAdapter = new JTFKeyAdapter(this);

    public KLimitedNumberFieldC(double d, short s, boolean bl, Object object) {
        if (s == 0) {
            this.mAdapter.inputInt(bl);
        } else {
            this.mAdapter.inputDouble(bl);
        }
        mInputMode = s;
        this.mLastValue = d;
        this.mCallbackSource = object;
        if (s == 0) {
            this.setText(Integer.toString((int)Math.round(this.mLastValue)), false);
        } else {
            this.setText(Double.toString(this.mLastValue), false);
        }
        this.addFocusListener(this);
    }

    public void addCallbackListener(CallBackListener callBackListener) {
        this.mAdapter.addCallbackListener(callBackListener);
    }

    public void setMinMax(double d, double d2) {
        this.mAdapter.setMinMax(d, d2);
        this.mMin = d;
        this.mMax = d2;
    }

    public void setValue(double d) {
        this.setValue(d, true);
    }

    public void setValue(double d, boolean bl) {
        if (this.getValue() == d) {
            return;
        }
        d = this.getCorrectVal(d);
        this.setText(this.createText(d), bl);
    }

    @Override
    public void setText(String string) {
        this.setText(string, true);
    }

    private void setText(String string, boolean bl) {
        super.setText(string);
        if (bl && this.mAdapter.getCallbackListener() != null) {
            this.mAdapter.getCallbackListener().actionCallBack(this.mCallbackSource);
        }
    }

    public Object getCallbackSource() {
        return this.mCallbackSource;
    }

    private String createText(double d) {
        String string = null;
        string = mInputMode == 0 ? Integer.toString((int)d) : (d % 1.0 != 0.0 ? "" + new BigDecimal(d).setScale(2, 4) : Integer.toString((int)d));
        return string;
    }

    public double getValue() {
        return this.getValue(this.getText());
    }

    private double getValue(String string) {
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        if (string != null && string.length() == 1 && string.equalsIgnoreCase("-")) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private double getCorrectVal(double d) {
        if (this.mMin == this.mMax || this.mMin <= d && d <= this.mMax) {
            return d;
        }
        return this.mMin > d ? this.mMin : this.mMax;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.getInputContext().setCharacterSubsets(null);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

