/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.gui.event.CallBackListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import jp.kitec.kwt.KLimitedNumberFieldC;
import jp.kitec.kwt.ValueVerifier;

class JTFKeyAdapter {
    private double mMin = 0.0;
    private double mMax = 0.0;
    private CallBackListener mCallbackListener;
    private boolean nonNegative;
    private KLimitedNumberFieldC jTF;
    private boolean typeIsInt;
    static final String EDIT_DBL = ".eE-";

    public JTFKeyAdapter(KLimitedNumberFieldC kLimitedNumberFieldC) {
        this.jTF = kLimitedNumberFieldC;
    }

    public JTFKeyAdapter(KLimitedNumberFieldC kLimitedNumberFieldC, boolean bl, int n) {
        this(kLimitedNumberFieldC);
        this.typeIsInt = bl;
        if (bl) {
            this.inputInt(n > 0);
        } else {
            this.inputDouble(n > 0);
        }
    }

    public void setMinMax(double d, double d2) {
        this.mMin = d;
        this.mMax = d2;
    }

    public void addCallbackListener(CallBackListener callBackListener) {
        this.mCallbackListener = callBackListener;
    }

    public CallBackListener getCallbackListener() {
        return this.mCallbackListener;
    }

    public boolean ok(double d) {
        return true;
    }

    public boolean ok(int n) {
        return true;
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean charEditInt(char c, KeyEvent keyEvent) {
        return c == '\b' || JTFKeyAdapter.isDigit(c);
    }

    private boolean charEditDouble(char c, KeyEvent keyEvent) {
        if (JTFKeyAdapter.charEditInt(c, keyEvent)) {
            return true;
        }
        if (EDIT_DBL.indexOf(c) < 0) {
            return false;
        }
        if (c == 'E') {
            c = (char)101;
        }
        int n = this.jTF.getCaretPosition();
        String string = this.jTF.getText().replace('E', 'e');
        string = String.valueOf(string.substring(0, n)) + c + string.substring(n);
        int n2 = string.indexOf(101);
        int n3 = string.length();
        if (n2 > 0 && string.charAt(n3 - 1) == 'e') {
            return string.indexOf("e", n2 + 1) < 0;
        }
        if (n2 <= 0 || !JTFKeyAdapter.isDigit(string.charAt(n3 - 1))) {
            if (c == '-') {
                if (n == 0 && this.nonNegative) {
                    return false;
                }
                if (n3 == 1) {
                    return true;
                }
                if (n2 > 0 && n == n2 + 1) {
                    return true;
                }
            } else if (c == '.') {
                if (n3 == 1) {
                    return true;
                }
                if (n3 == 2 && string.equals("-.")) {
                    return true;
                }
            }
        }
        return this.passParseTest(string, true);
    }

    String jTFText() {
        return this.jTF.getText();
    }

    public boolean passParseTest(String string, boolean bl) {
        if (string.length() == 0) {
            return false;
        }
        boolean bl2 = true;
        try {
            bl2 = this.typeIsInt ? this.ok(Integer.parseInt(string)) : this.ok(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        return bl2;
    }

    public void inputInt(boolean bl) {
        this.nonNegative = bl;
        this.jTF.setInputVerifier(new ValueVerifier(this));
        this.jTF.addKeyListener(new KeyAdapter(){
            private double lastValue;

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.lastValue = JTFKeyAdapter.this.jTF.getValue();
                char c = keyEvent.getKeyChar();
                if ((JTFKeyAdapter.this.jTF.getCaretPosition() != 0 || JTFKeyAdapter.this.nonNegative || c != '-') && !JTFKeyAdapter.charEditInt(c, keyEvent)) {
                    keyEvent.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                double d = JTFKeyAdapter.this.jTF.getValue();
                if (JTFKeyAdapter.this.mMin != JTFKeyAdapter.this.mMax && (JTFKeyAdapter.this.mMin > d || d > JTFKeyAdapter.this.mMax)) {
                    JTFKeyAdapter.this.jTF.setValue(this.lastValue);
                    return;
                }
                if (JTFKeyAdapter.this.mCallbackListener != null) {
                    JTFKeyAdapter.this.mCallbackListener.actionCallBack(JTFKeyAdapter.this.jTF.getCallbackSource());
                }
            }
        });
    }

    public void inputDouble(boolean bl) {
        this.nonNegative = bl;
        this.jTF.setInputVerifier(new ValueVerifier(this));
        this.jTF.addKeyListener(new KeyAdapter(){
            private double lastValue;

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.lastValue = JTFKeyAdapter.this.jTF.getValue();
                char c = keyEvent.getKeyChar();
                if ((JTFKeyAdapter.this.jTF.getCaretPosition() != 0 || JTFKeyAdapter.this.nonNegative || c != '-') && !JTFKeyAdapter.this.charEditDouble(c, keyEvent)) {
                    keyEvent.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                double d = JTFKeyAdapter.this.jTF.getValue();
                if (JTFKeyAdapter.this.mMin != JTFKeyAdapter.this.mMax && (JTFKeyAdapter.this.mMin > d || d > JTFKeyAdapter.this.mMax)) {
                    JTFKeyAdapter.this.jTF.setValue(this.lastValue);
                    return;
                }
                if (JTFKeyAdapter.this.mCallbackListener != null) {
                    JTFKeyAdapter.this.mCallbackListener.actionCallBack(JTFKeyAdapter.this.jTF.getCallbackSource());
                }
            }
        });
    }
}

