/*
 * Decompiled with CFR 0.152.
 */
package danran.multispan.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import danran.multispan.MultiSpanTerrace;
import java.util.Collection;
import java.util.LinkedList;
import option.danran.dxo.DRNSaveDataConverter;
import option.danran.entity.BasicInfo;
import option.danran.entity.DRNInfos;
import option.danran.entity.FrontPanelOptionInfo;
import option.danran.entity.IBasicInfo;
import option.danran.entity.IFrontPanelOptionInfo;
import option.danran.entity.IOptionInfo;
import option.danran.entity.IPanelInfo;
import option.danran.entity.IPanelOptionInfo;
import option.danran.entity.ISidePanelOptionInfo;
import option.danran.entity.ITerraceInfo;
import option.danran.entity.ITerracesInfo;
import option.danran.entity.PanelInfo;
import option.danran.entity.PanelOptionInfo;
import option.danran.entity.SidePanelOptionInfo;
import option.danran.entity.TerraceInfo;
import option.danran.entity.TerracesInfo;
import option.danranmodelset.NodeNameDanran;
import option.gad.core.annotation.GdProperty;
import option.gad.core.dao.GdAbstractSaveFileDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectFolderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable
public abstract class DRNModelSetDao<PER, DOC, TSI extends ITerracesInfo, TI extends ITerraceInfo, BI extends IBasicInfo, FPI extends IPanelInfo, FPIS extends Collection<FPI>, LSPI extends IPanelInfo, LSPIS extends Collection<LSPI>, RSPI extends IPanelInfo, RSPIS extends Collection<RSPI>, FPOI extends IFrontPanelOptionInfo, FPOIS extends Collection<FPOI>, LSPOI extends ISidePanelOptionInfo, LSPOIS extends Collection<LSPOI>, RSPOI extends ISidePanelOptionInfo, RSPOIS extends Collection<RSPOI>, POI extends IPanelOptionInfo, POIS extends Collection<POI>, OPI extends IOptionInfo, OPIS extends Collection<OPI>>
extends GdAbstractSaveFileDao<PER, PER, DOC> {
    @GdInject
    private DRNSaveDataConverter mConverter;
    private static final Log mLog = LogFactory.getLog(DRNModelSetDao.class);

    protected DRNModelSetDao() {
    }

    public void save(ObjectFolder objectFolder, MultiSpanTerrace multiSpanTerrace) {
        this.saveFolder(objectFolder, NodeNameDanran.BASICINFO.name(), multiSpanTerrace.getBasicInfo());
        this.saveFolders(objectFolder, NodeNameDanran.FRONTPANELINFOS.name(), NodeNameDanran.FRONTPANELINFO.name(), multiSpanTerrace.getFrontPanelInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.LEFTPANELINFOS.name(), NodeNameDanran.LEFTPANELINFO.name(), multiSpanTerrace.getLeftPanelInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.RIGHTPANELINFOS.name(), NodeNameDanran.RIGHTPANELINFO.name(), multiSpanTerrace.getRightPanelInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.FRONTPANELOPTIONINFOS.name(), NodeNameDanran.FRONTPANELOPTIONINFO.name(), multiSpanTerrace.getFrontPanelOptionInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.LEFTPANELOPTIONINFOS.name(), NodeNameDanran.LEFTPANELOPTIONINFO.name(), multiSpanTerrace.getLeftPanelOptionInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.RIGHTPANELOPTIONINFOS.name(), NodeNameDanran.RIGHTPANELOPTIONINFO.name(), multiSpanTerrace.getRightPanelOptionInfoList());
        this.saveFolders(objectFolder, NodeNameDanran.PANELOPTIONINFOS.name(), NodeNameDanran.PANELOPTIONINFO.name(), multiSpanTerrace.getPanelOptionInfoList());
        ObjectFolder objectFolder2 = new ObjectFolder(NodeNameDanran.TERRACEINFOS.name());
        for (TerraceInfo terraceInfo : multiSpanTerrace.getTerraceInfoList()) {
            objectFolder2.addChild((ObjectNode)ObjectFolderUtil.createFolder((Object)terraceInfo, (String)NodeNameDanran.TERRACEINFO.name(), GdProperty.class), true);
        }
        ObjectFolderUtil.addObject((ObjectFolder)objectFolder2, (Object)multiSpanTerrace.getTerracesInfo(), GdProperty.class);
        objectFolder.addChild((ObjectNode)objectFolder2);
    }

    public void load(ObjectFolder objectFolder, MultiSpanTerrace multiSpanTerrace) {
        BI BI = this.loadBasicInfo(objectFolder);
        TSI TSI = this.loadTerracesInfo(objectFolder);
        Collection<TI> collection = this.loadTerraceInfos(objectFolder);
        Collection<FPI> collection2 = this.loadFrontPanelInfo(objectFolder);
        Collection<LSPI> collection3 = this.loadLeftPanelInfo(objectFolder);
        Collection<RSPI> collection4 = this.loadRighrPanelInfo(objectFolder);
        Collection<FPOI> collection5 = this.loadFrontPanelOptionInfo(objectFolder);
        Collection<LSPOI> collection6 = this.loadLeftPanelOptionInfo(objectFolder);
        Collection<RSPOI> collection7 = this.loadRighrPanelOptionInfo(objectFolder);
        Collection<POI> collection8 = this.loadPanelOptionInfo(objectFolder);
        DRNInfos dRNInfos = DRNInfos.newInstance();
        dRNInfos.value1 = TSI;
        dRNInfos.value2 = collection;
        dRNInfos.value3 = BI;
        dRNInfos.value4 = collection2;
        dRNInfos.value5 = collection3;
        dRNInfos.value6 = collection4;
        dRNInfos.value7 = collection5;
        dRNInfos.value8 = collection6;
        dRNInfos.value9 = collection7;
        dRNInfos.value10 = collection8;
        this.repair((IBasicInfo)dRNInfos.value3, (ITerracesInfo)dRNInfos.value1, (Collection)dRNInfos.value2, (Collection)dRNInfos.value4, (Collection)dRNInfos.value5, (Collection)dRNInfos.value6, (Collection)dRNInfos.value7, (Collection)dRNInfos.value8, (Collection)dRNInfos.value9, (Collection)dRNInfos.value10);
        DRNInfos dRNInfos2 = (DRNInfos)this.mConverter.convert(multiSpanTerrace.getVersion(), dRNInfos);
        this.restore(multiSpanTerrace, (BasicInfo)dRNInfos2.value3, (TerracesInfo)dRNInfos2.value1, (Collection)dRNInfos2.value2, (Collection)dRNInfos2.value4, (Collection)dRNInfos2.value5, (Collection)dRNInfos2.value6, (Collection)dRNInfos2.value7, (Collection)dRNInfos2.value8, (Collection)dRNInfos2.value9, (Collection)dRNInfos2.value10);
    }

    protected BI loadBasicInfo(ObjectFolder objectFolder) {
        return (BI)((IBasicInfo)this.loadFolder(objectFolder, NodeNameDanran.BASICINFO.name()));
    }

    protected Collection<FPI> loadFrontPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.FRONTPANELINFOS.name(), NodeNameDanran.FRONTPANELINFO.name());
    }

    protected Collection<LSPI> loadLeftPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.LEFTPANELINFOS.name(), NodeNameDanran.LEFTPANELINFO.name());
    }

    protected Collection<RSPI> loadRighrPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.RIGHTPANELINFOS.name(), NodeNameDanran.RIGHTPANELINFO.name());
    }

    protected Collection<FPOI> loadFrontPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.FRONTPANELOPTIONINFOS.name(), NodeNameDanran.FRONTPANELOPTIONINFO.name());
    }

    protected Collection<LSPOI> loadLeftPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.LEFTPANELOPTIONINFOS.name(), NodeNameDanran.LEFTPANELOPTIONINFO.name());
    }

    protected Collection<RSPOI> loadRighrPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.RIGHTPANELOPTIONINFOS.name(), NodeNameDanran.RIGHTPANELOPTIONINFO.name());
    }

    protected Collection<POI> loadPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameDanran.PANELOPTIONINFOS.name(), NodeNameDanran.PANELOPTIONINFO.name());
    }

    protected TSI loadTerracesInfo(ObjectFolder objectFolder) {
        return (TSI)((ITerracesInfo)this.loadFolder(objectFolder, NodeNameDanran.TERRACEINFOS.name()));
    }

    protected Collection<TI> loadTerraceInfos(ObjectFolder objectFolder) {
        ObjectFolder objectFolder22;
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)NodeNameDanran.TERRACEINFO.name());
        ObjectFolder objectFolder3 = new ObjectFolder(NodeNameDanran.TERRACEINFOS.name());
        objectFolder3.addChild(new ObjectNode("type", (Object)"java.util.ArrayList"));
        for (ObjectFolder objectFolder22 : collection) {
            objectFolder3.addChild((ObjectNode)objectFolder22, true);
        }
        objectFolder22 = new ObjectFolder("root");
        objectFolder22.addChild((ObjectNode)objectFolder3);
        return this.loadFolders(objectFolder22, NodeNameDanran.TERRACEINFOS.name(), NodeNameDanran.TERRACEINFO.name(), TerraceInfo.class);
    }

    protected void repair(BI BI, TSI TSI, Collection<TI> collection, Collection<FPI> collection2, Collection<LSPI> collection3, Collection<RSPI> collection4, Collection<FPOI> collection5, Collection<LSPOI> collection6, Collection<RSPOI> collection7, Collection<POI> collection8) {
    }

    protected void restore(MultiSpanTerrace multiSpanTerrace, BasicInfo basicInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, Collection<PanelInfo> collection2, Collection<PanelInfo> collection3, Collection<PanelInfo> collection4, Collection<FrontPanelOptionInfo> collection5, Collection<SidePanelOptionInfo> collection6, Collection<SidePanelOptionInfo> collection7, Collection<PanelOptionInfo> collection8) {
        multiSpanTerrace.setBasicInfo(basicInfo);
        multiSpanTerrace.setTerracesInfo(terracesInfo);
        multiSpanTerrace.setTerraceInfoList(new LinkedList<TerraceInfo>(collection));
        multiSpanTerrace.setFrontPanelInfoList(new LinkedList<PanelInfo>(collection2));
        multiSpanTerrace.setLeftPanelInfoList(new LinkedList<PanelInfo>(collection3));
        multiSpanTerrace.setRightPanelInfoList(new LinkedList<PanelInfo>(collection4));
        multiSpanTerrace.setFrontPanelOptionInfoList(new LinkedList<FrontPanelOptionInfo>(collection5));
        multiSpanTerrace.setLeftPanelOptionInfoList(new LinkedList<SidePanelOptionInfo>(collection6));
        multiSpanTerrace.setRightPanelOptionInfoList(new LinkedList<SidePanelOptionInfo>(collection7));
        multiSpanTerrace.setPanelOptionInfoList(new LinkedList<PanelOptionInfo>(collection8));
    }
}

