/*
 * Decompiled with CFR 0.152.
 */
package danran.multispan.creator;

import java.util.List;
import option.danran.parts.DanranFullFixPanel;
import option.danran.parts.DanranFullFixPanelWithKoshikabe;
import option.danran.parts.DanranFullPanel;
import option.danran.parts.DanranFullPanelWithKoshikabe;
import option.danran.parts.DanranLowerFixPanel;
import option.danran.parts.DanranLowerPanel;
import option.danran.parts.DanranPanel;
import option.danran.parts.DanranUpperFixPanel;
import option.danran.parts.DanranUpperPanel;
import option.danran.parts.panel.DnPartsMainPanel;
import option.danran.type.PanelPartsType;

public class PanelPartsFactory {
    public static DanranPanel getPanel(List<PanelPartsType> list) {
        if (list.size() == 1) {
            return PanelPartsFactory.getFixPanel(list.get(0));
        }
        if (list.size() == 2) {
            return PanelPartsFactory.getOridoPanel(list.get(0), list.get(1));
        }
        return PanelPartsFactory.getOridoPanel(PanelPartsType.FULL_GLASS, PanelPartsType.FULL_GLASS);
    }

    public static DanranPanel getKoshikabePanel(List<PanelPartsType> list) {
        if (list.size() == 1) {
            return PanelPartsFactory.getKoshikabeFixPanel(list.get(0));
        }
        if (list.size() == 2) {
            return PanelPartsFactory.getKoshikabeOridoPanel(list.get(0), list.get(1));
        }
        return PanelPartsFactory.getKoshikabeOridoPanel(PanelPartsType.FULL_GLASS, PanelPartsType.FULL_GLASS);
    }

    public static DanranPanel getOridoPanel(PanelPartsType panelPartsType, PanelPartsType panelPartsType2) {
        DanranPanel danranPanel = null;
        DnPartsMainPanel.UpperPanelType upperPanelType = PanelPartsFactory.convertUpperPanelType(panelPartsType);
        DnPartsMainPanel.LowerPanelType lowerPanelType = PanelPartsFactory.convertLowerPanelType(panelPartsType);
        DnPartsMainPanel.UpperPanelType upperPanelType2 = PanelPartsFactory.convertUpperPanelType(panelPartsType2);
        DnPartsMainPanel.LowerPanelType lowerPanelType2 = PanelPartsFactory.convertLowerPanelType(panelPartsType2);
        switch (panelPartsType) {
            case UPPER_GLASS: 
            case UPPER_LATTICE: 
            case UPPER_KANKIPANEL: {
                danranPanel = new DanranUpperPanel(upperPanelType, upperPanelType2);
                break;
            }
            case LOWER_GLASS: 
            case LOWER_LATTICE: 
            case DESIGN_A: 
            case DESIGN_B: {
                danranPanel = new DanranLowerPanel(lowerPanelType, lowerPanelType2);
                break;
            }
            case KOSHIKABE: 
            case FULL_GLASS: 
            case FULL_LATTICE: 
            case UPPER_GLASS_DESIGN_A: 
            case UPPER_LATTICE_DESIGN_A: 
            case UPPER_GLASS_DESIGN_B: 
            case UPPER_LATTICE_DESIGN_B: 
            case UPPER_GLASS_KOSHIKABE: 
            case UPPER_LATTICE_KOSHIKABE: 
            case UPPER_LATTICE_LOWER_GLASS: 
            case UPPER_GLASS_LOWER_LATTICE: 
            case UPPER_KANKIPANEL_LOWER_GLASS: 
            case UPPER_KANKIPANEL_LOWER_LATTICE: 
            case UPPER_KANKIPANEL_DESIGN_A: 
            case UPPER_KANKIPANEL_DESIGN_B: 
            case UPPER_KANKIPANEL_KOSHIKABE: {
                danranPanel = new DanranFullPanel(upperPanelType, lowerPanelType, upperPanelType2, lowerPanelType2);
                break;
            }
            default: {
                danranPanel = new DanranFullPanel(DnPartsMainPanel.UpperPanelType.NONE, DnPartsMainPanel.LowerPanelType.NONE, DnPartsMainPanel.UpperPanelType.NONE, DnPartsMainPanel.LowerPanelType.NONE);
            }
        }
        return danranPanel;
    }

    public static DanranPanel getKoshikabeOridoPanel(PanelPartsType panelPartsType, PanelPartsType panelPartsType2) {
        DnPartsMainPanel.UpperPanelType upperPanelType = PanelPartsFactory.convertUpperPanelType(panelPartsType);
        DnPartsMainPanel.UpperPanelType upperPanelType2 = PanelPartsFactory.convertUpperPanelType(panelPartsType2);
        DanranFullPanelWithKoshikabe danranFullPanelWithKoshikabe = new DanranFullPanelWithKoshikabe(upperPanelType, upperPanelType2);
        return danranFullPanelWithKoshikabe;
    }

    public static DanranPanel getFixPanel(PanelPartsType panelPartsType) {
        DanranPanel danranPanel = null;
        DnPartsMainPanel.UpperPanelType upperPanelType = PanelPartsFactory.convertUpperPanelType(panelPartsType);
        DnPartsMainPanel.LowerPanelType lowerPanelType = PanelPartsFactory.convertLowerPanelType(panelPartsType);
        switch (panelPartsType) {
            case UPPER_GLASS: 
            case UPPER_LATTICE: 
            case UPPER_KANKIPANEL: {
                danranPanel = new DanranUpperFixPanel(upperPanelType);
                break;
            }
            case LOWER_GLASS: 
            case LOWER_LATTICE: 
            case DESIGN_A: 
            case DESIGN_B: {
                danranPanel = new DanranLowerFixPanel(lowerPanelType);
                break;
            }
            case KOSHIKABE: 
            case FULL_GLASS: 
            case FULL_LATTICE: 
            case UPPER_GLASS_DESIGN_A: 
            case UPPER_LATTICE_DESIGN_A: 
            case UPPER_GLASS_DESIGN_B: 
            case UPPER_LATTICE_DESIGN_B: 
            case UPPER_GLASS_KOSHIKABE: 
            case UPPER_LATTICE_KOSHIKABE: 
            case UPPER_LATTICE_LOWER_GLASS: 
            case UPPER_GLASS_LOWER_LATTICE: 
            case UPPER_KANKIPANEL_LOWER_GLASS: 
            case UPPER_KANKIPANEL_LOWER_LATTICE: 
            case UPPER_KANKIPANEL_DESIGN_A: 
            case UPPER_KANKIPANEL_DESIGN_B: 
            case UPPER_KANKIPANEL_KOSHIKABE: {
                danranPanel = new DanranFullFixPanel(upperPanelType, lowerPanelType);
                break;
            }
            default: {
                danranPanel = new DanranFullFixPanel(DnPartsMainPanel.UpperPanelType.NONE, DnPartsMainPanel.LowerPanelType.NONE);
            }
        }
        return danranPanel;
    }

    public static DanranPanel getKoshikabeFixPanel(PanelPartsType panelPartsType) {
        DnPartsMainPanel.UpperPanelType upperPanelType = PanelPartsFactory.convertUpperPanelType(panelPartsType);
        DanranFullFixPanelWithKoshikabe danranFullFixPanelWithKoshikabe = new DanranFullFixPanelWithKoshikabe(upperPanelType);
        return danranFullFixPanelWithKoshikabe;
    }

    private static DnPartsMainPanel.UpperPanelType convertUpperPanelType(PanelPartsType panelPartsType) {
        DnPartsMainPanel.UpperPanelType upperPanelType;
        switch (panelPartsType) {
            case UPPER_GLASS: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case UPPER_LATTICE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_KANKIPANEL: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            case FULL_GLASS: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case FULL_LATTICE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_GLASS_DESIGN_A: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case UPPER_LATTICE_DESIGN_A: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_KANKIPANEL_DESIGN_A: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            case UPPER_GLASS_DESIGN_B: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case UPPER_LATTICE_DESIGN_B: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_KANKIPANEL_DESIGN_B: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            case UPPER_GLASS_KOSHIKABE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case UPPER_LATTICE_KOSHIKABE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_KANKIPANEL_KOSHIKABE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            case UPPER_LATTICE_LOWER_GLASS: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.DECORATED;
                break;
            }
            case UPPER_GLASS_LOWER_LATTICE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.GLASS;
                break;
            }
            case UPPER_KANKIPANEL_LOWER_GLASS: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            case UPPER_KANKIPANEL_LOWER_LATTICE: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.KANKIPANEL;
                break;
            }
            default: {
                upperPanelType = DnPartsMainPanel.UpperPanelType.NONE;
            }
        }
        return upperPanelType;
    }

    private static DnPartsMainPanel.LowerPanelType convertLowerPanelType(PanelPartsType panelPartsType) {
        DnPartsMainPanel.LowerPanelType lowerPanelType;
        switch (panelPartsType) {
            case LOWER_LATTICE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.DECORATED;
                break;
            }
            case LOWER_GLASS: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.GLASS;
                break;
            }
            case DESIGN_A: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_A;
                break;
            }
            case DESIGN_B: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_B;
                break;
            }
            case KOSHIKABE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHIKABE;
                break;
            }
            case FULL_GLASS: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.GLASS;
                break;
            }
            case FULL_LATTICE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.DECORATED;
                break;
            }
            case UPPER_GLASS_DESIGN_A: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_A;
                break;
            }
            case UPPER_LATTICE_DESIGN_A: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_A;
                break;
            }
            case UPPER_KANKIPANEL_DESIGN_A: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_A;
                break;
            }
            case UPPER_GLASS_DESIGN_B: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_B;
                break;
            }
            case UPPER_LATTICE_DESIGN_B: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_B;
                break;
            }
            case UPPER_KANKIPANEL_DESIGN_B: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHI_B;
                break;
            }
            case UPPER_GLASS_KOSHIKABE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHIKABE;
                break;
            }
            case UPPER_LATTICE_KOSHIKABE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHIKABE;
                break;
            }
            case UPPER_KANKIPANEL_KOSHIKABE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.KOSHIKABE;
                break;
            }
            case UPPER_LATTICE_LOWER_GLASS: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.GLASS;
                break;
            }
            case UPPER_GLASS_LOWER_LATTICE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.DECORATED;
                break;
            }
            case UPPER_KANKIPANEL_LOWER_GLASS: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.GLASS;
                break;
            }
            case UPPER_KANKIPANEL_LOWER_LATTICE: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.DECORATED;
                break;
            }
            default: {
                lowerPanelType = DnPartsMainPanel.LowerPanelType.NONE;
            }
        }
        return lowerPanelType;
    }
}

