/*
 * Decompiled with CFR 0.152.
 */
package danran.multispan;

import danran.multispan.AbstractTerraceUnit;
import danran.multispan.RailProperty;
import danran.multispan.types.ZtPanel;
import danran.multispan.types.ZtPanelState;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model.item.Item;
import model.shape.primitive.TransForm2f;
import option.danran.DRNColor;
import option.danran.DRNPanelColor;
import option.danran.adapter.DRNColorAdapter;
import option.danran.adapter.YaneColorAdapter;
import option.danran.entity.BasicInfo;
import option.danran.entity.DomaTileInfo;
import option.danran.entity.FrontPanelOptionInfo;
import option.danran.entity.InnerDeckInfo;
import option.danran.entity.KiraraStageInnerDeckInfo;
import option.danran.entity.PanelInfo;
import option.danran.entity.PanelOptionInfo;
import option.danran.entity.SidePanelOptionInfo;
import option.danran.entity.TerraceInfo;
import option.danran.entity.TerracesInfo;
import option.danran.model.util.create.DRNUnitCreator;
import option.danran.model.util.update.DRNTerraceUpdateUtil;
import option.danran.type.EnforcementType;
import option.danran.type.FloorType;
import option.danran.type.PanelMaterialType;
import option.danran.type.TerraceDepthType;
import option.gad.core.util.ObjectUtil;

public class MultiSpanTerrace
extends Item
implements Serializable {
    private static final int INDEX_GROUP_MAIN = 0;
    private static final int INDEX_GROUP_KASAGI = 1;
    private static final int INDEX_GROUP_KASAGI_SG = 2;
    private static final int INDEX_GROUP_OTHER = 3;
    private static final int INDEX_GROUP_PANEL_L = 4;
    private static final int INDEX_GROUP_PANEL_R = 5;
    private static final int INDEX_GROUP_YANE = 6;
    private static final int INDEX_GROUP_TERRACE_L = 7;
    private static final int INDEX_GROUP_TERRACE_R = 8;
    private static final int INDEX_GROUP_ROOM_L = 9;
    private static final int INDEX_GROUP_ROOM_R = 10;
    private static final int INDEX_GROUP_UPPER_FIX = 11;
    private static final int INDEX_GROUP_PANEL_INNER = 12;
    private String mVersion;
    private TerracesInfo mTerracesInfo;
    public LinkedList<TerraceInfo> mTerraceInfoList = new LinkedList();
    private BasicInfo mBasicInfo;
    private DomaTileInfo mDomaTile;
    private InnerDeckInfo mInnerDeckInfo;
    private KiraraStageInnerDeckInfo mKiraraStageInnerDeckInfo;
    private LinkedList<PanelInfo> mFrontPanelInfoList = new LinkedList();
    private LinkedList<PanelInfo> mLeftPanelInfoList = new LinkedList();
    private LinkedList<PanelInfo> mRightPanelInfoList = new LinkedList();
    private LinkedList<FrontPanelOptionInfo> mFrontPanelOptionInfoList = new LinkedList();
    private LinkedList<SidePanelOptionInfo> mLeftPanelOptionInfoList = new LinkedList();
    private LinkedList<SidePanelOptionInfo> mRightPanelOptionInfoList = new LinkedList();
    private LinkedList<PanelOptionInfo> mPanelOptionInfoList = new LinkedList();
    private List<AbstractTerraceUnit> units = null;
    private float floorlevel = 400.0f;
    private TransForm2f trans;
    private boolean mVisibleKutai = false;

    public MultiSpanTerrace() {
        super(13);
        this.color_group[0] = 0;
        this.color_group[12] = 14;
        this.color_group[3] = 3;
        this.color_group[4] = 4;
        this.color_group[5] = 5;
        this.color_group[6] = 6;
        this.color_group[7] = 8;
        this.color_group[8] = 9;
        this.color_group[9] = 11;
        this.color_group[10] = 12;
        this.color_group[11] = 13;
        this.trans = new TransForm2f();
        this.setColorChanged(true);
        this.units = new ArrayList<AbstractTerraceUnit>();
    }

    public List<AbstractTerraceUnit> getUnits() {
        return this.units;
    }

    public void setVersion(String string) {
        this.mVersion = string;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setTerracesInfo(TerracesInfo terracesInfo) {
        this.mTerracesInfo = terracesInfo;
    }

    public TerracesInfo getTerracesInfo() {
        return this.mTerracesInfo;
    }

    public void setTerraceInfoList(LinkedList<TerraceInfo> linkedList) {
        this.mTerraceInfoList = linkedList;
    }

    public LinkedList<TerraceInfo> getTerraceInfoList() {
        return this.mTerraceInfoList;
    }

    public void setBasicInfo(BasicInfo basicInfo) {
        this.mBasicInfo = basicInfo;
    }

    public BasicInfo getBasicInfo() {
        return this.mBasicInfo;
    }

    public void setDomaTileInfo(DomaTileInfo domaTileInfo) {
        this.mDomaTile = domaTileInfo;
    }

    public DomaTileInfo getDomaTileInfo() {
        return this.mDomaTile;
    }

    public void setInnerDeckInfo(InnerDeckInfo innerDeckInfo) {
        this.mInnerDeckInfo = innerDeckInfo;
    }

    public InnerDeckInfo getInnerDeckInfo() {
        return this.mInnerDeckInfo;
    }

    public void setKiraraStageInnerDeckInfo(KiraraStageInnerDeckInfo kiraraStageInnerDeckInfo) {
        this.mKiraraStageInnerDeckInfo = kiraraStageInnerDeckInfo;
    }

    public KiraraStageInnerDeckInfo getKiraraStageInnerDeckInfo() {
        return this.mKiraraStageInnerDeckInfo;
    }

    public LinkedList<PanelInfo> getFrontPanelInfoList() {
        return this.mFrontPanelInfoList;
    }

    public void setFrontPanelInfoList(LinkedList<PanelInfo> linkedList) {
        this.mFrontPanelInfoList = linkedList;
    }

    public void setLeftPanelInfoList(LinkedList<PanelInfo> linkedList) {
        this.mLeftPanelInfoList = linkedList;
    }

    public LinkedList<PanelInfo> getLeftPanelInfoList() {
        return this.mLeftPanelInfoList;
    }

    public void setRightPanelInfoList(LinkedList<PanelInfo> linkedList) {
        this.mRightPanelInfoList = linkedList;
    }

    public LinkedList<PanelInfo> getRightPanelInfoList() {
        return this.mRightPanelInfoList;
    }

    public void setFrontPanelOptionInfoList(LinkedList<FrontPanelOptionInfo> linkedList) {
        this.mFrontPanelOptionInfoList = linkedList;
    }

    public LinkedList<FrontPanelOptionInfo> getFrontPanelOptionInfoList() {
        return this.mFrontPanelOptionInfoList;
    }

    public void setLeftPanelOptionInfoList(LinkedList<SidePanelOptionInfo> linkedList) {
        this.mLeftPanelOptionInfoList = linkedList;
    }

    public LinkedList<SidePanelOptionInfo> getLeftPanelOptionInfoList() {
        return this.mLeftPanelOptionInfoList;
    }

    public void setRightPanelOptionInfoList(LinkedList<SidePanelOptionInfo> linkedList) {
        this.mRightPanelOptionInfoList = linkedList;
    }

    public LinkedList<SidePanelOptionInfo> getRightPanelOptionInfoList() {
        return this.mRightPanelOptionInfoList;
    }

    public void setPanelOptionInfoList(LinkedList<PanelOptionInfo> linkedList) {
        this.mPanelOptionInfoList = linkedList;
    }

    public LinkedList<PanelOptionInfo> getPanelOptionInfoList() {
        return this.mPanelOptionInfoList;
    }

    public float getFloorlevel() {
        return this.floorlevel;
    }

    public TransForm2f getTrans() {
        return this.trans;
    }

    public void setFL(float f) {
        this.setFloorlevel(f);
    }

    public void setFloorlevel(float f) {
        this.floorlevel = f;
    }

    public void setAxis(float f, float f2, float f3) {
        this.trans.x = f;
        this.trans.y = f2;
        this.trans.angle = f3;
    }

    public float getHeightMM() {
        return this.mTerracesInfo.mHeightType.mTumadarukiHeight;
    }

    public float getheightTumabari() {
        return this.mTerracesInfo.mHeightType.mTumabariHeight;
    }

    public float getDepthInner() {
        return this.mTerracesInfo.mDepth.floatValue() - 105.0f;
    }

    public float getTotalHeight() {
        return this.getHeightByRoomType() + this.getH2ByRoomType(this.mTerracesInfo.mDepth.floatValue());
    }

    public int getGroup_color_other() {
        return this.color_code[3];
    }

    public void setGroup_color_other(int n) {
        this.setColor(3, n);
    }

    public int getGroup_color_panel_L() {
        return this.color_code[4];
    }

    public void setGroup_color_panel_L(int n) {
        this.setColor(4, n);
    }

    public int getGroup_color_panel_R() {
        return this.color_code[5];
    }

    public void setGroup_color_panel_R(int n) {
        this.setColor(5, n);
    }

    public int getGroup_color_main() {
        return this.color_code[0];
    }

    public void setGroup_color_main(int n) {
        this.setColor(0, n);
    }

    public int getGroup_color_kasagi() {
        return this.color_code[1];
    }

    public void setGroup_color_kasagi(int n) {
        this.setColor(1, n);
    }

    public int getGroup_color_kasagi_sg() {
        return this.color_code[2];
    }

    public void setGroup_color_kasagi_sg(int n) {
        this.setColor(2, n);
    }

    public int getYanezai() {
        return this.color_code[6];
    }

    public void setYanezai(int n) {
        this.setColor(6, n);
    }

    public void setUpperLeft(int n) {
        this.setColor(7, n);
    }

    public void setUpperRight(int n) {
        this.setColor(8, n);
    }

    public void setUpperRoomLeft(int n) {
        this.setColor(9, n);
    }

    public void setUpperRoomRight(int n) {
        this.setColor(10, n);
    }

    public int getUpperLeft() {
        return this.color_code[7];
    }

    public int getUpperRight() {
        return this.color_code[8];
    }

    public int getUpperRoomLeft() {
        return this.color_code[9];
    }

    public int getUpperRoomRight() {
        return this.color_code[10];
    }

    public void setUpperFix(int n) {
        this.setColor(11, n);
    }

    public int getUpperFix() {
        return this.color_code[11];
    }

    public int getGroup_color_panel_inner() {
        return this.color_code[12];
    }

    public void setGroup_color_panel_inner(int n) {
        this.setColor(12, n);
    }

    public Color getIndexColor(int n) {
        if (n >= 6) {
            return DRNPanelColor.getColor(this.color_code[n]);
        }
        return DRNColor.getColor(this.color_code[n]);
    }

    public float getTotalWidthInLength() {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : this.getTerraceInfoList()) {
            f += terraceInfo.mWidth;
        }
        return f;
    }

    public void setClosePanel(boolean bl) {
        for (AbstractTerraceUnit abstractTerraceUnit : this.units) {
            this.setClosePanel(abstractTerraceUnit.getLeftRail(), bl, ZtPanelState.OPEN_NEXT);
            this.setClosePanel(abstractTerraceUnit.getRightRail(), bl, ZtPanelState.OPEN_PREV);
            this.setClosePanel(abstractTerraceUnit.getFrontRail(), bl, ZtPanelState.OPEN_PREV);
        }
    }

    private void setClosePanel(RailProperty railProperty, boolean bl, ZtPanelState ztPanelState) {
        if (railProperty == null) {
            return;
        }
        ZtPanelState ztPanelState2 = ZtPanelState.CLOSE;
        if (!bl) {
            ztPanelState2 = ztPanelState;
        }
        if (!railProperty.getPanel().equals((Object)ZtPanel.ORIDO)) {
            ztPanelState2 = ZtPanelState.CLOSE;
        }
        railProperty.setPanelState(ztPanelState2);
    }

    public AbstractTerraceUnit getFirstUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        for (AbstractTerraceUnit abstractTerraceUnit : this.getUnits()) {
            if (!abstractTerraceUnit.getTerraceInfo().mIsLeftEnd.booleanValue()) continue;
            return abstractTerraceUnit;
        }
        return null;
    }

    public AbstractTerraceUnit getLastUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        for (AbstractTerraceUnit abstractTerraceUnit : this.getUnits()) {
            if (!abstractTerraceUnit.getTerraceInfo().mIsRightEnd.booleanValue()) continue;
            return abstractTerraceUnit;
        }
        return null;
    }

    public float getHeightByRoomType() {
        return this.mTerracesInfo.mHeightType.mTumabariHeight;
    }

    public float getH2ByRoomType(float f) {
        TerraceDepthType terraceDepthType = this.mTerracesInfo.mDepthType;
        float f2 = terraceDepthType.mDetailTsumabari;
        float f3 = terraceDepthType.mDetailValue - 105.0f - f;
        f2 = (float)((double)f2 - (double)f3 * Math.tan(Math.toRadians(5.0)));
        return f2;
    }

    public AbstractTerraceUnit findUnitById(int n) {
        for (AbstractTerraceUnit abstractTerraceUnit : this.getUnits()) {
            if (abstractTerraceUnit.getTerraceInfo().mId != n) continue;
            return abstractTerraceUnit;
        }
        return null;
    }

    public boolean isVisibleKutai() {
        return this.mVisibleKutai;
    }

    public void setVisibleKutai(boolean bl) {
        this.mVisibleKutai = bl;
    }

    public void updateByInfos() {
        this.updateFloorLevel();
        this.updateUsed();
        this.updateUnits();
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : this.mTerraceInfoList) {
            if (!terraceInfo2.mIsMaster.booleanValue()) continue;
            terraceInfo = terraceInfo2;
        }
        this.updateColor(this.mBasicInfo, this.mLeftPanelInfoList, this.mRightPanelInfoList, terraceInfo);
    }

    public void updateFloorLevel() {
        if (this.mBasicInfo.mFloorType == FloorType.INNER_DECK) {
            this.setFL(this.mInnerDeckInfo.mFloorLevel.floatValue());
        } else if (this.mBasicInfo.mFloorType == FloorType.KIRARA_STAGE_INNER_DECK) {
            this.setFL(this.mKiraraStageInnerDeckInfo.mFloorLevel.floatValue());
        } else if (this.mBasicInfo.mFloorType == FloorType.DOMA) {
            this.setFL(this.mDomaTile.mFloorLevel.mValue);
        } else {
            this.setFL(0.0f);
        }
    }

    public void updateUsed() {
        this.setUsed(true);
        this.setColorChanged(false);
    }

    public void updateUnits() {
        Object object;
        int n;
        List<AbstractTerraceUnit> list = this.getUnits();
        if (list.size() != 0) {
            for (AbstractTerraceUnit object22 : list) {
                object22.clear();
            }
            list.clear();
        }
        EnforcementType enforcementType = this.mTerracesInfo.mEnforcementType;
        int n2 = this.mTerraceInfoList.size();
        float[] fArray = new float[n2];
        int f = 0;
        while (f < n2) {
            fArray[f] = this.mTerraceInfoList.get((int)f).mWidthType.mValue;
            ++f;
        }
        f = 0;
        while (f < fArray.length) {
            AbstractTerraceUnit f2 = DRNUnitCreator.createUnit(this, fArray.length, f, enforcementType);
            list.add(f2);
            ++f;
        }
        float f2 = this.getTotalWidthInLength();
        float f3 = -f2 / 2.0f;
        if (this.mTerraceInfoList != null) {
            Iterator f32 = this.mTerraceInfoList.iterator();
            n = 0;
            while (n < list.size()) {
                object = (TerraceInfo)f32.next();
                TerraceInfo f4 = new TerraceInfo();
                ObjectUtil.shallowCopy((Object)object, (Object)f4);
                list.get(n).setTerraceInfo(f4);
                list.get(n).setTerracesInfo(this.getTerracesInfo());
                ++n;
            }
        }
        float f4 = f3;
        n = 0;
        while (n < fArray.length) {
            boolean bl;
            float f5;
            object = list.get(n);
            float f6 = f5 = ((AbstractTerraceUnit)((Object)object)).getTerraceInfo().mWidth;
            float f7 = f5 / 2.0f;
            boolean bl2 = n > 0;
            boolean bl3 = bl = n < fArray.length - 1;
            if (bl2) {
                ((AbstractTerraceUnit)((Object)object)).setPrev(list.get(n - 1));
            }
            if (bl) {
                ((AbstractTerraceUnit)((Object)object)).setNext(list.get(n + 1));
            }
            ((AbstractTerraceUnit)((Object)object)).setCx(f4 + f7);
            f4 += f6;
            ++n;
        }
        DRNTerraceUpdateUtil.updateUnits(this);
    }

    public void updateColor(BasicInfo basicInfo, LinkedList<PanelInfo> linkedList, LinkedList<PanelInfo> linkedList2, TerraceInfo terraceInfo) {
        this.setGroup_color_main(DRNColorAdapter.getModelColor(basicInfo.mBodyColor.mId));
        this.setGroup_color_panel_inner(DRNColorAdapter.getPanelInnerColor(basicInfo.mPanelInnerColor.mId));
        this.setYanezai(YaneColorAdapter.getYaneColor(basicInfo.mYaneMaterialType.mId));
        if (linkedList.size() != 0) {
            this.setGroup_color_panel_L(YaneColorAdapter.getYaneColor(PanelMaterialType.GLASS.mId));
        }
        if (linkedList2.size() != 0) {
            this.setGroup_color_panel_R(YaneColorAdapter.getYaneColor(PanelMaterialType.GLASS.mId));
        }
        List<AbstractTerraceUnit> list = this.getUnits();
        for (AbstractTerraceUnit abstractTerraceUnit : list) {
            if (abstractTerraceUnit.getLeftSide() != null && terraceInfo.mLeftTsumabariUpperMaterialType != null) {
                abstractTerraceUnit.getLeftSide().setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mLeftTsumabariUpperMaterialType.mId));
            }
            if (abstractTerraceUnit.getRightSide() == null || terraceInfo.mRightTsumabariUpperMaterialType == null) continue;
            abstractTerraceUnit.getRightSide().setMaterial(YaneColorAdapter.getYaneColor(terraceInfo.mRightTsumabariUpperMaterialType.mId));
        }
    }
}

