/*
 * Decompiled with CFR 0.152.
 */
package cocoma2.multispan.dao;

import cocoma2.multispan.MultiSpanTerrace;
import com.kt.annotation.Reflectable;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.Collection;
import java.util.LinkedList;
import option.cocoma2.dxo.CM2SaveDataConverter;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.CM2Infos;
import option.cocoma2.entity.FrontPanelInfo;
import option.cocoma2.entity.FrontPanelOptionInfo;
import option.cocoma2.entity.IBasicInfo;
import option.cocoma2.entity.IFrontPanelInfo;
import option.cocoma2.entity.IFrontPanelOptionInfo;
import option.cocoma2.entity.ISidePanelInfo;
import option.cocoma2.entity.ISidePanelOptionInfo;
import option.cocoma2.entity.ITerraceInfo;
import option.cocoma2.entity.ITerracesInfo;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.entity.SidePanelOptionInfo;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2modelset.NodeNameCocoma2;
import option.gad.core.annotation.GdProperty;
import option.gad.core.dao.GdAbstractSaveFileDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectFolderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable
public abstract class CM2ModelSetDao<PER, DOC, TSI extends ITerracesInfo, TI extends ITerraceInfo, BI extends IBasicInfo, FPI extends IFrontPanelInfo, FPIS extends Collection<FPI>, LSPI extends ISidePanelInfo, LSPIS extends Collection<LSPI>, RSPI extends ISidePanelInfo, RSPIS extends Collection<RSPI>, FPOI extends IFrontPanelOptionInfo, FPOIS extends Collection<FPOI>, LSPOI extends ISidePanelOptionInfo, LSPOIS extends Collection<LSPOI>, RSPOI extends ISidePanelOptionInfo, RSPOIS extends Collection<RSPOI>>
extends GdAbstractSaveFileDao<PER, PER, DOC> {
    @GdInject
    private CM2SaveDataConverter mConverter;
    private static final Log mLog = LogFactory.getLog(CM2ModelSetDao.class);

    protected CM2ModelSetDao() {
    }

    public void save(ObjectFolder objectFolder, MultiSpanTerrace multiSpanTerrace) {
        this.saveFolder(objectFolder, NodeNameCocoma2.BASICINFO.name(), multiSpanTerrace.getBasicInfo());
        this.saveFolders(objectFolder, NodeNameCocoma2.FRONTPANELINFOS.name(), NodeNameCocoma2.FRONTPANELINFO.name(), multiSpanTerrace.getFrontPanelInfoList());
        this.saveFolders(objectFolder, NodeNameCocoma2.LEFTPANELINFOS.name(), NodeNameCocoma2.LEFTPANELINFO.name(), multiSpanTerrace.getLeftPanelInfoList());
        this.saveFolders(objectFolder, NodeNameCocoma2.RIGHTPANELINFOS.name(), NodeNameCocoma2.RIGHTPANELINFO.name(), multiSpanTerrace.getRightPanelInfoList());
        this.saveFolders(objectFolder, NodeNameCocoma2.FRONTPANELOPTIONINFOS.name(), NodeNameCocoma2.FRONTPANELOPTIONINFO.name(), multiSpanTerrace.getFrontPanelOptionInfoList());
        this.saveFolders(objectFolder, NodeNameCocoma2.LEFTPANELOPTIONINFOS.name(), NodeNameCocoma2.LEFTPANELOPTIONINFO.name(), multiSpanTerrace.getLeftPanelOptionInfoList());
        this.saveFolders(objectFolder, NodeNameCocoma2.RIGHTPANELOPTIONINFOS.name(), NodeNameCocoma2.RIGHTPANELOPTIONINFO.name(), multiSpanTerrace.getRightPanelOptionInfoList());
        ObjectFolder objectFolder2 = new ObjectFolder(NodeNameCocoma2.TERRACEINFOS.name());
        for (TerraceInfo terraceInfo : multiSpanTerrace.getTerraceInfoList()) {
            objectFolder2.addChild((ObjectNode)ObjectFolderUtil.createFolder((Object)terraceInfo, (String)NodeNameCocoma2.TERRACEINFO.name(), GdProperty.class), true);
        }
        ObjectFolderUtil.addObject((ObjectFolder)objectFolder2, (Object)multiSpanTerrace.getTerracesInfo(), GdProperty.class);
        objectFolder.addChild((ObjectNode)objectFolder2);
    }

    public void load(ObjectFolder objectFolder, MultiSpanTerrace multiSpanTerrace) {
        BI BI = this.loadBasicInfo(objectFolder);
        TSI TSI = this.loadTerracesInfo(objectFolder);
        Collection<TI> collection = this.loadTerraceInfos(objectFolder);
        Collection<FPI> collection2 = this.loadFrontPanelInfo(objectFolder);
        Collection<LSPI> collection3 = this.loadLeftPanelInfo(objectFolder);
        Collection<RSPI> collection4 = this.loadRighrPanelInfo(objectFolder);
        Collection<FPOI> collection5 = this.loadFrontPanelOptionInfo(objectFolder);
        Collection<LSPOI> collection6 = this.loadLeftPanelOptionInfo(objectFolder);
        Collection<RSPOI> collection7 = this.loadRighrPanelOptionInfo(objectFolder);
        CM2Infos cM2Infos = CM2Infos.newInstance();
        cM2Infos.value1 = TSI;
        cM2Infos.value2 = collection;
        cM2Infos.value3 = BI;
        cM2Infos.value4 = collection2;
        cM2Infos.value5 = collection3;
        cM2Infos.value6 = collection4;
        cM2Infos.value7 = collection5;
        cM2Infos.value8 = collection6;
        cM2Infos.value9 = collection7;
        this.repair((IBasicInfo)cM2Infos.value3, (ITerracesInfo)cM2Infos.value1, (Collection)cM2Infos.value2, (Collection)cM2Infos.value4, (Collection)cM2Infos.value5, (Collection)cM2Infos.value6, (Collection)cM2Infos.value7, (Collection)cM2Infos.value8, (Collection)cM2Infos.value9);
        CM2Infos cM2Infos2 = (CM2Infos)this.mConverter.convert(multiSpanTerrace.getVersion(), cM2Infos);
        this.restore(multiSpanTerrace, (BasicInfo)cM2Infos2.value3, (TerracesInfo)cM2Infos2.value1, (Collection)cM2Infos2.value2, (Collection)cM2Infos2.value4, (Collection)cM2Infos2.value5, (Collection)cM2Infos2.value6, (Collection)cM2Infos2.value7, (Collection)cM2Infos2.value8, (Collection)cM2Infos2.value9);
    }

    protected BI loadBasicInfo(ObjectFolder objectFolder) {
        return (BI)((IBasicInfo)this.loadFolder(objectFolder, NodeNameCocoma2.BASICINFO.name()));
    }

    protected Collection<FPI> loadFrontPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.FRONTPANELINFOS.name(), NodeNameCocoma2.FRONTPANELINFO.name());
    }

    protected Collection<LSPI> loadLeftPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.LEFTPANELINFOS.name(), NodeNameCocoma2.LEFTPANELINFO.name());
    }

    protected Collection<RSPI> loadRighrPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.RIGHTPANELINFOS.name(), NodeNameCocoma2.RIGHTPANELINFO.name());
    }

    protected Collection<FPOI> loadFrontPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.FRONTPANELOPTIONINFOS.name(), NodeNameCocoma2.FRONTPANELOPTIONINFO.name());
    }

    protected Collection<LSPOI> loadLeftPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.LEFTPANELOPTIONINFOS.name(), NodeNameCocoma2.LEFTPANELOPTIONINFO.name());
    }

    protected Collection<RSPOI> loadRighrPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameCocoma2.RIGHTPANELOPTIONINFOS.name(), NodeNameCocoma2.RIGHTPANELOPTIONINFO.name());
    }

    protected TSI loadTerracesInfo(ObjectFolder objectFolder) {
        return (TSI)((ITerracesInfo)this.loadFolder(objectFolder, NodeNameCocoma2.TERRACEINFOS.name()));
    }

    protected Collection<TI> loadTerraceInfos(ObjectFolder objectFolder) {
        ObjectFolder objectFolder22;
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)NodeNameCocoma2.TERRACEINFO.name());
        ObjectFolder objectFolder3 = new ObjectFolder(NodeNameCocoma2.TERRACEINFOS.name());
        objectFolder3.addChild(new ObjectNode("type", (Object)"java.util.ArrayList"));
        for (ObjectFolder objectFolder22 : collection) {
            objectFolder3.addChild((ObjectNode)objectFolder22, true);
        }
        objectFolder22 = new ObjectFolder("root");
        objectFolder22.addChild((ObjectNode)objectFolder3);
        return this.loadFolders(objectFolder22, NodeNameCocoma2.TERRACEINFOS.name(), NodeNameCocoma2.TERRACEINFO.name(), TerraceInfo.class);
    }

    protected void repair(BI BI, TSI TSI, Collection<TI> collection, Collection<FPI> collection2, Collection<LSPI> collection3, Collection<RSPI> collection4, Collection<FPOI> collection5, Collection<LSPOI> collection6, Collection<RSPOI> collection7) {
    }

    protected void restore(MultiSpanTerrace multiSpanTerrace, BasicInfo basicInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, Collection<FrontPanelInfo> collection2, Collection<SidePanelInfo> collection3, Collection<SidePanelInfo> collection4, Collection<FrontPanelOptionInfo> collection5, Collection<SidePanelOptionInfo> collection6, Collection<SidePanelOptionInfo> collection7) {
        multiSpanTerrace.setBasicInfo(basicInfo);
        multiSpanTerrace.setTerracesInfo(terracesInfo);
        multiSpanTerrace.setTerraceInfoList(new LinkedList<TerraceInfo>(collection));
        multiSpanTerrace.setFrontPanelInfoList(new LinkedList<FrontPanelInfo>(collection2));
        multiSpanTerrace.setLeftPanelInfoList(new LinkedList<SidePanelInfo>(collection3));
        multiSpanTerrace.setRightPanelInfoList(new LinkedList<SidePanelInfo>(collection4));
        multiSpanTerrace.setFrontPanelOptionInfoList(new LinkedList<FrontPanelOptionInfo>(collection5));
        multiSpanTerrace.setLeftPanelOptionInfoList(new LinkedList<SidePanelOptionInfo>(collection6));
        multiSpanTerrace.setRightPanelOptionInfoList(new LinkedList<SidePanelOptionInfo>(collection7));
    }
}

