/*
 * Decompiled with CFR 0.152.
 */
package cocoma2.multispan.creator;

import cocoma2.multispan.AbstractTerraceUnit;
import cocoma2.multispan.MultiSpanTerrace;
import cocoma2.multispan.creator.TerraceUnitCreator;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import model.shape.primitive.SMatrix4d;
import option.cocoma2.CM2Color;
import option.cocoma2.CM2PanelColor;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.entity.paneloption.CustomWallInfo;
import option.cocoma2.parts.PMiddleHoutate;
import option.cocoma2.parts.PSideOridoBeat;
import option.cocoma2.parts.PSideOridoChoseiFixBeat;
import option.cocoma2.parts.PSideOridoChoseiFixUke;
import option.cocoma2.parts.PTatewakuBuzai;
import option.cocoma2.parts.sidepanel.PLeftFixPanel;
import option.cocoma2.parts.sidepanel.PRightFixPanel;
import option.cocoma2.parts.sidepanel.SideCustomWallLeftParts;
import option.cocoma2.parts.sidepanel.SideCustomWallRightParts;
import option.cocoma2.parts.sidepanel.SideFixLeftParts;
import option.cocoma2.parts.sidepanel.SideFixRightParts;
import option.cocoma2.parts.sidepanel.SideHikidoLeftParts;
import option.cocoma2.parts.sidepanel.SideHikidoRightParts;
import option.cocoma2.parts.sidepanel.SideOridoChoseiFixLeftParts;
import option.cocoma2.parts.sidepanel.SideOridoChoseiFixRightParts;
import option.cocoma2.parts.sidepanel.SideOridoLeftParts;
import option.cocoma2.parts.sidepanel.SideOridoRightParts;
import option.cocoma2.parts.sidepanel.SideTatesuberidashiLeftParts;
import option.cocoma2.parts.sidepanel.SideTatesuberidashiRightParts;
import option.cocoma2.scene.creator.ScreenPanelColorManager;
import option.cocoma2.service.CommonService;
import option.cocoma2.service.KoshikabeService;
import option.cocoma2.service.SidePanelService;
import option.cocoma2.service.SidePanelShapeService;
import option.cocoma2.service.TerraceService;
import option.cocoma2.type.FloorType;
import option.cocoma2.type.PanelMaterialType;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.SidePanelType;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInstanceFactory;

public class MsUnitSidePanelsCreator
extends TerraceUnitCreator {
    @GdInject
    private KoshikabeService mKoshikabeService = (KoshikabeService)GdInstanceFactory.getInstance().getInstance(KoshikabeService.class, new Object[0]);
    @GdInject
    private SidePanelService mSidePanelService = (SidePanelService)GdInstanceFactory.getInstance().getInstance(SidePanelService.class, new Object[0]);
    @GdInject
    private TerraceService mTerraceService = (TerraceService)GdInstanceFactory.getInstance().getInstance(TerraceService.class, new Object[0]);

    @Override
    public void create(AbstractTerraceUnit abstractTerraceUnit, Parts parts) {
        throw new UnsupportedOperationException();
    }

    public Parts create(MultiSpanTerrace multiSpanTerrace, boolean bl) {
        return this.create(null, null, multiSpanTerrace, bl);
    }

    public Parts create(AbstractTerraceUnit abstractTerraceUnit, Parts parts, MultiSpanTerrace multiSpanTerrace) {
        return this.create(abstractTerraceUnit, parts, multiSpanTerrace, true);
    }

    private Parts create(AbstractTerraceUnit abstractTerraceUnit, Parts parts, MultiSpanTerrace multiSpanTerrace, boolean bl) {
        if (parts == null) {
            parts = new Parts();
            parts.mat = new SMatrix4d();
            parts.mat.init();
        }
        LinkedList<SidePanelInfo> linkedList = multiSpanTerrace.getLeftPanelInfoList();
        LinkedList<SidePanelInfo> linkedList2 = multiSpanTerrace.getRightPanelInfoList();
        if (linkedList.size() == 0 && linkedList2.size() == 0) {
            return parts;
        }
        Vector vector = parts.getChildren(true);
        BasicInfo basicInfo = multiSpanTerrace.getBasicInfo();
        float f = multiSpanTerrace.getFloorlevel();
        float f2 = this.mKoshikabeService.getKoshikabeHeight(multiSpanTerrace) + this.mKoshikabeService.calcKoshikabeFL(multiSpanTerrace);
        float f3 = multiSpanTerrace.getheightTumabari();
        float f4 = multiSpanTerrace.getDepthInner();
        Color color = CM2Color.getColor(multiSpanTerrace.getGroup_color_main_material());
        if (abstractTerraceUnit != null) {
            if (abstractTerraceUnit.getTerraceInfo().mRoomType != RoomType.GARDEN_ROOM) {
                return parts;
            }
            boolean bl2 = this.mTerraceService.isKoshikabeL(abstractTerraceUnit.getTerraceInfo(), basicInfo, true);
            float f5 = bl2 ? f2 : f + 36.0f;
            float f6 = SidePanelShapeService.calcLeftKutaiSidePanelY(abstractTerraceUnit, linkedList, f4);
            this.createLeftPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList, f, f5, f3, f2, f6, bl2, color, false);
            bl2 = this.mTerraceService.isKoshikabeL(abstractTerraceUnit.getTerraceInfo(), basicInfo, false);
            f5 = bl2 ? f2 : f + 36.0f;
            f6 = SidePanelShapeService.calcRightKutaiSidePanelY(abstractTerraceUnit, linkedList2, f4);
            this.createRightPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList2, f, f5, f3, f2, f6, bl2, color, false);
        } else if (bl) {
            abstractTerraceUnit = CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
            boolean bl3 = this.mTerraceService.isKoshikabeL(abstractTerraceUnit.getTerraceInfo(), basicInfo, bl);
            float f7 = bl3 ? f2 : f + 36.0f;
            float f8 = SidePanelShapeService.calcLeftKutaiSidePanelY(abstractTerraceUnit, linkedList, f4);
            this.createLeftPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList, f, f7, f3, f2, f8, bl3, color, true);
        } else {
            abstractTerraceUnit = CommonService.getLastUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
            boolean bl4 = this.mTerraceService.isKoshikabeL(abstractTerraceUnit.getTerraceInfo(), basicInfo, bl);
            float f9 = bl4 ? f2 : f + 36.0f;
            float f10 = SidePanelShapeService.calcRightKutaiSidePanelY(abstractTerraceUnit, linkedList2, f4);
            this.createRightPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList2, f, f9, f3, f2, f10, bl4, color, true);
        }
        return parts;
    }

    public Parts create(MultiSpanTerrace multiSpanTerrace, boolean bl, LinkedList<SidePanelInfo> linkedList) {
        Parts parts = new Parts();
        parts.mat = new SMatrix4d();
        parts.mat.init();
        AbstractTerraceUnit abstractTerraceUnit = bl ? CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM) : CommonService.getLastUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
        this.create(abstractTerraceUnit, parts, bl, linkedList);
        return parts;
    }

    private void create(AbstractTerraceUnit abstractTerraceUnit, Parts parts, boolean bl, LinkedList<SidePanelInfo> linkedList) {
        if (abstractTerraceUnit.getTerraceInfo().mRoomType != RoomType.GARDEN_ROOM) {
            return;
        }
        MultiSpanTerrace multiSpanTerrace = abstractTerraceUnit.getTerrace();
        BasicInfo basicInfo = multiSpanTerrace.getBasicInfo();
        Vector vector = parts.getChildren(true);
        boolean bl2 = this.mTerraceService.isKoshikabeL(abstractTerraceUnit.getTerraceInfo(), basicInfo, bl);
        boolean bl3 = basicInfo.mFloorType == FloorType.INNER_DECK;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = bl2 ? f2 : f;
        float f5 = this.calcTsumabariHeight(multiSpanTerrace, bl2, bl3);
        Color color = CM2Color.getColor(multiSpanTerrace.getGroup_color_main_material());
        if (bl) {
            this.createLeftPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList, f, f4, f5, f2, f3, bl2, color, true);
        } else {
            this.createRightPanels(abstractTerraceUnit, vector, multiSpanTerrace, linkedList, f, f4, f5, f2, f3, bl2, color, true);
        }
    }

    private float calcTsumabariHeight(MultiSpanTerrace multiSpanTerrace, boolean bl, boolean bl2) {
        float f = multiSpanTerrace.getheightTumabari();
        f = bl ? f - this.mKoshikabeService.getKoshikabeHeight(multiSpanTerrace) : f;
        f = bl && bl2 ? f + multiSpanTerrace.getFloorlevel() : f;
        return f;
    }

    private void createLeftPanels(AbstractTerraceUnit abstractTerraceUnit, List<Parts> list, MultiSpanTerrace multiSpanTerrace, LinkedList<SidePanelInfo> linkedList, float f, float f2, float f3, float f4, float f5, boolean bl, Color color, boolean bl2) {
        if (!SidePanelShapeService.hasLeftPanel(abstractTerraceUnit, multiSpanTerrace, linkedList)) {
            return;
        }
        int n = linkedList.size();
        int n2 = -1;
        float f6 = abstractTerraceUnit.getWidthL() - 30.0f - 2.5f;
        float f7 = f5;
        double d = 0.0;
        boolean bl3 = multiSpanTerrace.getClosePanel();
        boolean bl4 = abstractTerraceUnit == CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
        int n3 = 0;
        while (n3 < n) {
            SidePanelInfo sidePanelInfo = this.mSidePanelService.findOneSidePanelByIndex(linkedList, n - 1 - n3);
            if (sidePanelInfo != null) {
                boolean bl5 = sidePanelInfo.mPanelType == SidePanelType.ORIDO;
                float f8 = sidePanelInfo.mWidth.floatValue();
                float f9 = bl5 ? f8 * 2.0f : f8;
                PanelMaterialType panelMaterialType = sidePanelInfo.mMaterialType;
                Color color2 = null;
                if (panelMaterialType != null) {
                    color2 = bl2 ? ScreenPanelColorManager.getColor2D(panelMaterialType) : CM2PanelColor.getColor(panelMaterialType);
                }
                if (bl4 && sidePanelInfo.mGroupId != n2) {
                    Parts parts;
                    if (sidePanelInfo.mPanelType == SidePanelType.ORIDO) {
                        f6 = abstractTerraceUnit.getWidthL() - 30.0f - 2.5f;
                        if (bl3) {
                            parts = new SideOridoLeftParts();
                            parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 6);
                            list.add(parts);
                        } else {
                            float f10 = 127.0f;
                            double d2 = d == 0.0 ? (double)f7 : d;
                            double d3 = f9 / 2.0f;
                            double d4 = SidePanelShapeService.calcAngleForOpenOrido(f9 / 2.0f, 55.0, f10);
                            double d5 = Math.cos(d4);
                            double d6 = Math.sin(d4);
                            double d7 = (double)f6 + 20.0 * d5 - 25.0 * d6;
                            double d8 = (d2 -= (double)f10) + 25.0 * d5;
                            double d9 = d7 - d3 * d5;
                            double d10 = d8 + d3 * d6;
                            double d11 = d9;
                            double d12 = 2.0 * (d2 + (double)(f10 / 2.0f)) - d10;
                            double d13 = d11 + d3 * d5;
                            double d14 = d12 + d3 * d6;
                            SideOridoLeftParts sideOridoLeftParts = new SideOridoLeftParts();
                            sideOridoLeftParts.set(d7, d8, d9, d10, d11, d12, d13, d14, f + 36.0f, f + f3, color, color2, 6);
                            list.add(sideOridoLeftParts);
                            d = d2;
                        }
                    } else if (sidePanelInfo.mPanelType == SidePanelType.HIKIDO) {
                        f6 = abstractTerraceUnit.getWidthL() - 58.0f + 60.0f;
                        parts = new SideHikidoLeftParts();
                        parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 6);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.TATESUBERI) {
                        f6 = abstractTerraceUnit.getWidthL() + 82.0f - 60.0f;
                        parts = new SideTatesuberidashiLeftParts();
                        parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 6);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.FIX || sidePanelInfo.mPanelType == SidePanelType.KOSHIKABE_FIX) {
                        f6 = abstractTerraceUnit.getWidthL() - 60.0f;
                        parts = new SideFixLeftParts();
                        parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 6, bl);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.ORIDO_ADJUSTMENT_FIX) {
                        f6 = abstractTerraceUnit.getWidthL() + 9.0f - 60.0f;
                        f7 = this.createOridoChoseFixUke(list, abstractTerraceUnit.getWidthL(), f7, f2, f + f3, color, -1);
                        parts = new SideOridoChoseiFixLeftParts();
                        parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 6);
                        list.add(parts);
                        this.createOridoChoseiFixBeat(list, abstractTerraceUnit.getWidthL(), f7 - f9, f2, f + f3, color, -1);
                        f9 += 11.0f;
                    } else if (sidePanelInfo.mPanelType == SidePanelType.ADJUSTMENT_FIX) {
                        f6 = abstractTerraceUnit.getWidthL() - 30.0f - 2.5f;
                        parts = new PLeftFixPanel();
                        parts.set(f6, f7 - f9, f6, f7, f2, f + f3, color, color2, 6);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.MIDDLE_MULLION) {
                        f6 = abstractTerraceUnit.getWidthL() - 30.0f;
                        parts = new PMiddleHoutate();
                        parts.set(f6, f7, f2, f + f3, color);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.TATEWAKU) {
                        f6 = abstractTerraceUnit.getWidthL() - 30.0f;
                        parts = new PTatewakuBuzai();
                        parts.set(f6, f7, f2, f + f3, color);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.CUSTOM_WALL) {
                        f6 = abstractTerraceUnit.getWidthL();
                        parts = new SideCustomWallLeftParts();
                        CustomWallInfo customWallInfo = (CustomWallInfo)sidePanelInfo;
                        Color color3 = CM2Color.getSideCustomWallColor(customWallInfo.mColorType);
                        float f11 = f7 - f9 - 60.0f;
                        float f12 = f7;
                        parts.set(f6, f11, f12, f, f + f3, color3);
                        list.add(parts);
                        f7 -= 60.0f;
                    }
                }
                if (sidePanelInfo.mGroupId != n2) {
                    f7 -= f9;
                }
                n2 = sidePanelInfo.mGroupId;
            }
            ++n3;
        }
        if (this.mSidePanelService.hasSidePanelType(linkedList, SidePanelType.ORIDO)) {
            this.createOridoBeat(list, f6, f7, f2, f + f3, color);
        }
    }

    private void createRightPanels(AbstractTerraceUnit abstractTerraceUnit, List<Parts> list, MultiSpanTerrace multiSpanTerrace, LinkedList<SidePanelInfo> linkedList, float f, float f2, float f3, float f4, float f5, boolean bl, Color color, boolean bl2) {
        if (!SidePanelShapeService.hasRightPanel(abstractTerraceUnit, multiSpanTerrace, linkedList)) {
            return;
        }
        int n = linkedList.size();
        int n2 = -1;
        float f6 = abstractTerraceUnit.getWidthR() + 30.0f + 2.5f;
        float f7 = f5;
        double d = 0.0;
        boolean bl3 = multiSpanTerrace.getClosePanel();
        boolean bl4 = abstractTerraceUnit == CommonService.getLastUnit(multiSpanTerrace, RoomType.GARDEN_ROOM);
        int n3 = 0;
        while (n3 < n) {
            SidePanelInfo sidePanelInfo = this.mSidePanelService.findOneSidePanelByIndex(linkedList, n - 1 - n3);
            if (sidePanelInfo != null) {
                boolean bl5 = sidePanelInfo.mPanelType == SidePanelType.ORIDO;
                float f8 = sidePanelInfo.mWidth.floatValue();
                float f9 = bl5 ? f8 * 2.0f : f8;
                PanelMaterialType panelMaterialType = sidePanelInfo.mMaterialType;
                Color color2 = null;
                if (panelMaterialType != null) {
                    color2 = bl2 ? ScreenPanelColorManager.getColor2D(panelMaterialType) : CM2PanelColor.getColor(panelMaterialType);
                }
                if (bl4 && sidePanelInfo.mGroupId != n2) {
                    Parts parts;
                    if (sidePanelInfo.mPanelType == SidePanelType.ORIDO) {
                        f6 = abstractTerraceUnit.getWidthR() + 30.0f + 2.5f;
                        if (bl3) {
                            parts = new SideOridoRightParts();
                            parts.set(f6, f7, f7 - f9, f2, f + f3, color, color2, 7);
                            list.add(parts);
                        } else {
                            double d2;
                            float f10 = 127.0f;
                            double d3 = d == 0.0 ? (double)f7 : d;
                            double d4 = f9 / 2.0f;
                            double d5 = SidePanelShapeService.calcAngleForOpenOrido(f9 / 2.0f, 55.0, f10);
                            double d6 = Math.cos(d5);
                            double d7 = Math.sin(d5);
                            double d8 = (double)f6 + 20.0 * d6 - 25.0 * d7;
                            double d9 = (d3 -= (double)f10) + 25.0 * d6;
                            double d10 = d8 - d4 * d6;
                            double d11 = d9 + d4 * d7;
                            double d12 = d10;
                            double d13 = 2.0 * (d3 + (double)(f10 / 2.0f)) - d11;
                            double d14 = d12 + d4 * d6;
                            double d15 = d13 + d4 * d7;
                            double d16 = d8;
                            double d17 = d10;
                            double d18 = d12;
                            d8 = d2 = d14;
                            d10 = d18;
                            d12 = d17;
                            d14 = d16;
                            d8 = (double)(f6 * 2.0f) - d8;
                            d10 = (double)(f6 * 2.0f) - d10;
                            d12 = (double)(f6 * 2.0f) - d12;
                            d14 = (double)(f6 * 2.0f) - d14;
                            d16 = d9;
                            d17 = d11;
                            d18 = d13;
                            d9 = d2 = d15;
                            d11 = d18;
                            d13 = d17;
                            d15 = d16;
                            SideOridoRightParts sideOridoRightParts = new SideOridoRightParts();
                            sideOridoRightParts.set(d8, d9, d10, d11, d12, d13, d14, d15, f + 36.0f, f + f3, color, color2, 7);
                            list.add(sideOridoRightParts);
                            d = d3;
                        }
                    } else if (sidePanelInfo.mPanelType == SidePanelType.HIKIDO) {
                        f6 = abstractTerraceUnit.getWidthR() + 58.0f;
                        parts = new SideHikidoRightParts();
                        parts.set(f6, f7 - f9, f7, f2, f + f3, color, color2, 7);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.TATESUBERI) {
                        f6 = abstractTerraceUnit.getWidthR() - 82.0f + 60.0f;
                        parts = new SideTatesuberidashiRightParts();
                        parts.set(f6, f7, f7 - f9, f2, f + f3, color, color2, 7);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.FIX || sidePanelInfo.mPanelType == SidePanelType.KOSHIKABE_FIX) {
                        f6 = abstractTerraceUnit.getWidthR() + 60.0f;
                        parts = new SideFixRightParts();
                        parts.set(f6, f7, f7 - f9, f2, f + f3, color, color2, 7, bl);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.ORIDO_ADJUSTMENT_FIX) {
                        f6 = abstractTerraceUnit.getWidthR() - 9.0f + 60.0f;
                        f7 = this.createOridoChoseFixUke(list, abstractTerraceUnit.getWidthR(), f7, f2, f + f3, color, 1);
                        parts = new SideOridoChoseiFixRightParts();
                        parts.set(f6, f7, f7 - f9, f2, f + f3, color, color2, 7);
                        list.add(parts);
                        this.createOridoChoseiFixBeat(list, abstractTerraceUnit.getWidthR(), f7 - f9, f2, f + f3, color, 1);
                        f9 += 11.0f;
                    } else if (sidePanelInfo.mPanelType == SidePanelType.ADJUSTMENT_FIX) {
                        f6 = abstractTerraceUnit.getWidthR() + 30.0f + 2.5f;
                        parts = new PRightFixPanel();
                        parts.set(f6, f7 - f9, f6, f7, f2, f + f3, color, color2, 7);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.MIDDLE_MULLION) {
                        f6 = abstractTerraceUnit.getWidthR() + 30.0f;
                        parts = new PMiddleHoutate();
                        parts.set(f6, f7, f2, f + f3, color);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.TATEWAKU) {
                        f6 = abstractTerraceUnit.getWidthR() + 30.0f;
                        parts = new PTatewakuBuzai();
                        parts.set(f6, f7, f2, f + f3, color);
                        list.add(parts);
                    } else if (sidePanelInfo.mPanelType == SidePanelType.CUSTOM_WALL) {
                        f6 = abstractTerraceUnit.getWidthR() + 60.0f;
                        parts = new SideCustomWallRightParts();
                        CustomWallInfo customWallInfo = (CustomWallInfo)sidePanelInfo;
                        Color color3 = CM2Color.getSideCustomWallColor(customWallInfo.mColorType);
                        float f11 = f7 - f9 - 60.0f;
                        float f12 = f7;
                        parts.set(f6, f11, f12, f, f + f3, color3);
                        list.add(parts);
                        f7 -= 60.0f;
                    }
                }
                if (sidePanelInfo.mGroupId != n2) {
                    f7 -= f9;
                }
                n2 = sidePanelInfo.mGroupId;
            }
            ++n3;
        }
        if (this.mSidePanelService.hasSidePanelType(linkedList, SidePanelType.ORIDO)) {
            this.createOridoBeat(list, f6, f7, f2, f + f3, color);
        }
    }

    private float createOridoChoseFixUke(List<Parts> list, float f, float f2, float f3, float f4, Color color, int n) {
        float f5 = f + (float)(3 * n) + 60.0f * (float)n / 2.0f;
        PSideOridoChoseiFixUke pSideOridoChoseiFixUke = new PSideOridoChoseiFixUke();
        pSideOridoChoseiFixUke.set(f5, f2, f3, f4, color);
        list.add(pSideOridoChoseiFixUke);
        return f2 - 16.0f;
    }

    private void createOridoChoseiFixBeat(List<Parts> list, float f, float f2, float f3, float f4, Color color, int n) {
        float f5 = f + (float)(3 * n) + 60.0f * (float)n / 2.0f;
        PSideOridoChoseiFixBeat pSideOridoChoseiFixBeat = new PSideOridoChoseiFixBeat();
        pSideOridoChoseiFixBeat.set(f5, f2, f3, f4, color);
        list.add(pSideOridoChoseiFixBeat);
    }

    private void createOridoBeat(List<Parts> list, float f, float f2, float f3, float f4, Color color) {
        PSideOridoBeat pSideOridoBeat = new PSideOridoBeat();
        pSideOridoBeat.set(f, f2, f3, f4, color);
        list.add(pSideOridoBeat);
    }
}

