/*
 * Decompiled with CFR 0.152.
 */
package cocoma2.multispan.creator;

import cocoma2.multispan.AbstractTerraceUnit;
import cocoma2.multispan.MultiSpanTerrace;
import cocoma2.multispan.creator.AbstractMsOptionCreator;
import cocoma2.multispan.item.MsItemClearWall;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.cocoma2.entity.BasicInfo;
import option.cocoma2.entity.SidePanelInfo;
import option.cocoma2.entity.SidePanelOptionInfo;
import option.cocoma2.entity.paneloption.ClearWallInfo;
import option.cocoma2.service.CommonService;
import option.cocoma2.service.KoshikabeService;
import option.cocoma2.service.PanelOptionService;
import option.cocoma2.service.SidePanelOptionService;
import option.cocoma2.service.SidePanelService;
import option.cocoma2.service.SidePanelShapeService;
import option.cocoma2.type.KoshikabePosType;
import option.cocoma2.type.KoshikabeType;
import option.cocoma2.type.RoomType;
import option.cocoma2.type.SidePanelType;
import option.cocoma2.type.paneloption.SidePanelOptionType;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInstanceFactory;
import option.parts.cocoma2misc.ClearWallLeftParts;
import option.parts.cocoma2misc.ClearWallRightParts;

public class MsClearWallCreator
extends AbstractMsOptionCreator<MsItemClearWall> {
    @GdInject
    private KoshikabeService mKoshikabeService = (KoshikabeService)GdInstanceFactory.getInstance().getInstance(KoshikabeService.class, new Object[0]);
    @GdInject
    private PanelOptionService mPanelOptionService = (PanelOptionService)GdInstanceFactory.getInstance().getInstance(PanelOptionService.class, new Object[0]);
    @GdInject
    private SidePanelService mSidePanelService = (SidePanelService)GdInstanceFactory.getInstance().getInstance(SidePanelService.class, new Object[0]);

    @Override
    public void create(MsItemClearWall msItemClearWall, AbstractTerraceUnit abstractTerraceUnit, Parts parts) {
        MultiSpanTerrace multiSpanTerrace = abstractTerraceUnit.getTerrace();
        float f = multiSpanTerrace.getFloorlevel();
        float f2 = multiSpanTerrace.getheightTumabari();
        float f3 = this.mKoshikabeService.getKoshikabeHeight(multiSpanTerrace) + this.mKoshikabeService.calcKoshikabeFL(multiSpanTerrace);
        Vector vector = parts.getChildren(true);
        this.createLeftClearWall(abstractTerraceUnit, vector, f, f3, f2);
        this.createRightClearWall(abstractTerraceUnit, vector, f, f3, f2);
    }

    private void createLeftClearWall(AbstractTerraceUnit abstractTerraceUnit, List<Parts> list, float f, float f2, float f3) {
        MultiSpanTerrace multiSpanTerrace = abstractTerraceUnit.getTerrace();
        LinkedList<SidePanelOptionInfo> linkedList = multiSpanTerrace.getLeftPanelOptionInfoList();
        if (!this.mPanelOptionService.hasSidePanelOption(SidePanelOptionType.CLEAR_WALL, linkedList) || abstractTerraceUnit != CommonService.getFirstUnit(multiSpanTerrace, RoomType.GARDEN_ROOM)) {
            return;
        }
        BasicInfo basicInfo = multiSpanTerrace.getBasicInfo();
        LinkedList<SidePanelInfo> linkedList2 = multiSpanTerrace.getLeftPanelInfoList();
        boolean bl = abstractTerraceUnit.getTerraceInfo().mFrontKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.LEFT_L;
        float f4 = multiSpanTerrace.getDepthInner();
        float f5 = abstractTerraceUnit.getWidthL() + 58.0f;
        float f6 = SidePanelShapeService.calcLeftKutaiSidePanelY(abstractTerraceUnit, linkedList2, f4);
        float f7 = bl ? f2 : f + 36.0f;
        int n = linkedList2.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - 1 - n2;
            SidePanelInfo sidePanelInfo = this.mSidePanelService.findOneSidePanelByIndex(linkedList2, n3);
            if (sidePanelInfo != null) {
                SidePanelOptionInfo sidePanelOptionInfo;
                float f8 = sidePanelInfo.mWidth.floatValue();
                if (sidePanelInfo.mPanelType == SidePanelType.FIX && (sidePanelOptionInfo = SidePanelOptionService.findSidePanelOptionInfo(linkedList, SidePanelOptionType.CLEAR_WALL, n3)) != null && sidePanelOptionInfo instanceof ClearWallInfo) {
                    ClearWallInfo clearWallInfo = (ClearWallInfo)sidePanelOptionInfo;
                    ClearWallLeftParts clearWallLeftParts = new ClearWallLeftParts();
                    clearWallLeftParts.set(f5, f6, f6 - f8, f7, f + f3, clearWallInfo.mShelfNum, clearWallInfo.mColorType.mColor);
                    list.add(clearWallLeftParts);
                }
                f6 -= f8;
            }
            ++n2;
        }
    }

    private void createRightClearWall(AbstractTerraceUnit abstractTerraceUnit, List<Parts> list, float f, float f2, float f3) {
        MultiSpanTerrace multiSpanTerrace = abstractTerraceUnit.getTerrace();
        LinkedList<SidePanelOptionInfo> linkedList = multiSpanTerrace.getRightPanelOptionInfoList();
        if (!this.mPanelOptionService.hasSidePanelOption(SidePanelOptionType.CLEAR_WALL, linkedList) || abstractTerraceUnit != CommonService.getLastUnit(multiSpanTerrace, RoomType.GARDEN_ROOM)) {
            return;
        }
        BasicInfo basicInfo = multiSpanTerrace.getBasicInfo();
        LinkedList<SidePanelInfo> linkedList2 = multiSpanTerrace.getRightPanelInfoList();
        boolean bl = abstractTerraceUnit.getTerraceInfo().mFrontKoshikabeType != KoshikabeType.NONE && basicInfo.mKoshikabePosType == KoshikabePosType.RIGHT_L;
        float f4 = multiSpanTerrace.getDepthInner();
        float f5 = abstractTerraceUnit.getWidthR() + 42.0f;
        float f6 = SidePanelShapeService.calcRightKutaiSidePanelY(abstractTerraceUnit, linkedList2, f4);
        float f7 = bl ? f2 : f + 36.0f;
        int n = linkedList2.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - 1 - n2;
            SidePanelInfo sidePanelInfo = this.mSidePanelService.findOneSidePanelByIndex(linkedList2, n3);
            if (sidePanelInfo != null) {
                SidePanelOptionInfo sidePanelOptionInfo;
                float f8 = sidePanelInfo.mWidth.floatValue();
                if (sidePanelInfo.mPanelType == SidePanelType.FIX && (sidePanelOptionInfo = SidePanelOptionService.findSidePanelOptionInfo(linkedList, SidePanelOptionType.CLEAR_WALL, n3)) != null && sidePanelOptionInfo instanceof ClearWallInfo) {
                    ClearWallInfo clearWallInfo = (ClearWallInfo)sidePanelOptionInfo;
                    ClearWallRightParts clearWallRightParts = new ClearWallRightParts();
                    clearWallRightParts.set(f5, f6, f6 - f8, f7, f + f3, clearWallInfo.mShelfNum, clearWallInfo.mColorType.mColor);
                    list.add(clearWallRightParts);
                }
                f6 -= f8;
            }
            ++n2;
        }
    }
}

