/*
 * Decompiled with CFR 0.152.
 */
package cocoma2.multispan;

import cocoma2.multispan.MultiSpanCocoma2UnitType;
import cocoma2.multispan.MultiSpanTerrace;
import cocoma2.multispan.SidePanelProperty;
import com.kt.util.tree.ObjectFolder;
import kinoki3exchange.KxModule;
import model.item.Item;
import option.cocoma2.entity.TerraceInfo;
import option.cocoma2.entity.TerracesInfo;
import option.cocoma2.type.EnforcementType;
import option.cocoma2.type.TerraceWidthType;

public abstract class AbstractTerraceUnit
extends Item
implements KxModule {
    protected MultiSpanTerrace terrace = null;
    protected AbstractTerraceUnit prev = null;
    protected AbstractTerraceUnit next = null;
    protected SidePanelProperty leftSide = null;
    protected SidePanelProperty rightSide = null;
    protected TerracesInfo terracesInfo = null;
    protected TerraceInfo terraceInfo = new TerraceInfo();
    protected EnforcementType enforcementType = EnforcementType.STANDARD;
    protected float cx;
    protected MultiSpanCocoma2UnitType unitType = MultiSpanCocoma2UnitType.GENERIC;
    protected float[] mPitches;

    public AbstractTerraceUnit(MultiSpanTerrace multiSpanTerrace) {
        this.terrace = multiSpanTerrace;
    }

    public AbstractTerraceUnit() {
    }

    public MultiSpanTerrace getTerrace() {
        return this.terrace;
    }

    public void setTerrace(MultiSpanTerrace multiSpanTerrace) {
        this.terrace = multiSpanTerrace;
    }

    public AbstractTerraceUnit getPrev() {
        return this.prev;
    }

    public AbstractTerraceUnit getNext() {
        return this.next;
    }

    public void setPrev(AbstractTerraceUnit abstractTerraceUnit) {
        this.prev = abstractTerraceUnit;
    }

    public void setNext(AbstractTerraceUnit abstractTerraceUnit) {
        this.next = abstractTerraceUnit;
    }

    public void clear() {
        this.terrace = null;
        this.next = null;
        this.prev = null;
        this.rightSide = null;
        this.leftSide = null;
        this.enforcementType = null;
    }

    public TerracesInfo getTerracesInfo() {
        return this.terracesInfo;
    }

    public void setTerracesInfo(TerracesInfo terracesInfo) {
        this.terracesInfo = terracesInfo;
    }

    public TerraceInfo getTerraceInfo() {
        return this.terraceInfo;
    }

    public void setTerraceInfo(TerraceInfo terraceInfo) {
        this.terraceInfo = terraceInfo;
    }

    public SidePanelProperty getLeftSide() {
        return this.leftSide;
    }

    public SidePanelProperty getRightSide() {
        return this.rightSide;
    }

    public EnforcementType getEnforcementType() {
        return this.enforcementType;
    }

    public float getCx() {
        return this.cx;
    }

    public float getFrameDepthCut() {
        if (this.terracesInfo == null || this.terracesInfo.mDepthType == null || this.terracesInfo.mDepth == null) {
            return 0.0f;
        }
        return this.terracesInfo.mDepthType.mDetailValue - this.terracesInfo.mDepth.floatValue();
    }

    public void setLeftSide(SidePanelProperty sidePanelProperty) {
        this.leftSide = sidePanelProperty;
    }

    public void setRightSide(SidePanelProperty sidePanelProperty) {
        this.rightSide = sidePanelProperty;
    }

    public void setEnforcementType(EnforcementType enforcementType) {
        this.enforcementType = enforcementType;
    }

    public void setCx(float f) {
        this.cx = f;
    }

    public TerraceWidthType getPanelWidth() {
        return this.terraceInfo.mWidthType;
    }

    public MultiSpanCocoma2UnitType getUnitType() {
        return this.unitType;
    }

    public void setUnitType(MultiSpanCocoma2UnitType multiSpanCocoma2UnitType) {
        this.unitType = multiSpanCocoma2UnitType;
    }

    public void saveCommon(ObjectFolder objectFolder) {
    }

    public void loadCommon(ObjectFolder objectFolder) {
    }

    public float getLeftKutaiBase() {
        return 0.0f;
    }

    public float getRightKutaiBase() {
        return 0.0f;
    }

    public float getWidthL() {
        return -(this.terraceInfo.mWidth - 60.0f) / 2.0f;
    }

    public float getWidthR() {
        return (this.terraceInfo.mWidth - 60.0f) / 2.0f;
    }

    public int getSpanNum() {
        return (int)((this.terraceInfo.mWidthType.mDetailValue + 60.0f) / 910.0f);
    }

    public float[] getPitches() {
        return this.mPitches;
    }

    public void setPitches(float[] fArray) {
        this.mPitches = fArray;
    }
}

