/*
 * Decompiled with CFR 0.152.
 */
package exsior.library;

import com.kt.io.AbstFile;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import com.kt.util.xml.XMLManager;
import exsior.prims.EsField;
import exsior.prims.EsFields;
import exsior.prims.EsProperty;
import exsior.prims.EsPropertyField;
import exsior.prims.EsRecord;
import exsior.prims.EsResource;
import exsior.prims.EsResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EsAbstractResource<P extends EsProperty, R extends EsResult>
implements EsResource<P, R> {
    private List<EsRecord<R>> records = new ArrayList<EsRecord<R>>();

    public List<EsRecord<R>> getRecords() {
        return this.records;
    }

    @Override
    public R get(P p) {
        if (p == null) {
            return null;
        }
        EsFields esFields = this.create(p);
        for (EsRecord<R> esRecord : this.records) {
            if (!esRecord.fields.equals(esFields)) continue;
            return esRecord.result;
        }
        System.out.println("resource not Found");
        return null;
    }

    protected EsFields create(P p) {
        EsFields esFields = new EsFields();
        Class<?> clazz = p.getClass();
        Field[] fieldArray = clazz.getFields();
        if (fieldArray != null) {
            Field[] fieldArray2 = fieldArray;
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray2[n2];
                EsPropertyField esPropertyField = field.getAnnotation(EsPropertyField.class);
                if (esPropertyField != null) {
                    String string = esPropertyField.desc();
                    try {
                        String string2 = field.get(p).toString();
                        if (esFields.fields == null) {
                            esFields.fields = new ArrayList<EsField>();
                        }
                        EsField esField = new EsField();
                        esField.name = string;
                        esField.object = string2;
                        esFields.fields.add(esField);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return esFields;
    }

    public void loadXML(InputStream inputStream) {
        try {
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                inputStream.read(byArray, n2, 1);
                ++n2;
            }
            inputStream.close();
            this.loadXML(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadXML(byte[] byArray) {
        AbstFile abstFile = new AbstFile();
        abstFile.setData(byArray);
        XMLManager xMLManager = new XMLManager();
        xMLManager.load(abstFile);
        ObjectFolder objectFolder = xMLManager.getTree();
        Vector vector = objectFolder.getNamedElement("item");
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.elementAt(n);
                if (e instanceof ObjectFolder) {
                    this.load((ObjectFolder)e);
                }
                ++n;
            }
        }
    }

    protected void load(ObjectFolder objectFolder) {
        Vector vector = objectFolder.getChildlen();
        EsFields esFields = new EsFields();
        int n = 0;
        while (n < vector.size()) {
            ObjectNode objectNode;
            String string;
            Object e = vector.get(n);
            if (!(e instanceof ObjectFolder || (string = (objectNode = (ObjectNode)e).getName()).equalsIgnoreCase("value") || string.equalsIgnoreCase("values"))) {
                if (esFields.fields == null) {
                    esFields.fields = new ArrayList<EsField>();
                }
                EsField esField = new EsField();
                esField.name = string;
                esField.object = ObjectFolder.getNodeString((ObjectNode)objectNode);
                esFields.fields.add(esField);
            }
            ++n;
        }
        R r = this.loadData(objectFolder);
        if (r != null) {
            this.records.add(new EsRecord<R>(esFields, r));
        }
    }

    protected abstract R loadData(ObjectFolder var1);
}

