/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import com.kt.gui.event.AccelKey;
import com.kt.util.Vector2;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.Vector;
import jp.kitec.kwt.util.ImageTool;
import jp.kitec.richui.TipsMessage;
import nethome.NethomeLookAndFeel;
import nethome.UserInfo;
import nethome.doc.CopyBuffer;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.lib.ObjectLibrary;
import nethome.ui.Canvas2D;
import nethome.ui.GuiCreator;
import nethome.ui.ICanvas2D;
import nethome.ui.MainApplication;
import nethome.ui.MaskCommand;
import nethome.ui.ProjectList;
import nethome.ui.command.Command;
import nethome.ui.gui.BasicDialog;
import nethome.ui.gui.NethomeDialog;
import nethome.ui.gui.NethomeDialogComponent;
import nethome.ui.gui.NethomeDialogInnerComponent;
import nethome.ui.gui.WindowContainer;
import nethome.ui.gui.WindowSystemClient;

public class MainComponent
extends Panel
implements KeyListener {
    private static MainComponent j = null;
    private MainApplication k;
    private Vector2 l;
    public TipsMessage mStatusBar;
    private WindowContainer m;
    private GuiCreator n;
    private ProjectList o;
    private Hashtable p;
    private Vector q;
    private UserInfo r;
    private ImageTool s;
    private CopyBuffer t;
    private Vector u;
    private CardLayout v;

    public static MainComponent createInstance(MainApplication mainApplication) {
        j = new MainComponent(mainApplication);
        return j;
    }

    public static void clearInstance() {
        if (j != null) {
            j.removeAll();
        }
        j = null;
    }

    public static MainComponent createInstance(MainApplication mainApplication, Container container, int n) {
        j = new MainComponent(mainApplication);
        return j;
    }

    public static MainComponent getInstance() {
        return j;
    }

    private MainComponent(MainApplication mainApplication) {
        j = this;
        this.k = mainApplication;
        this.u = new Vector();
        this.r = new UserInfo();
        this.q = new Vector();
        this.l = new Vector2();
        this.p = new Hashtable();
        this.t = new CopyBuffer();
        MainComponent.j.v = new CardLayout();
        this.setLayout(MainComponent.j.v);
    }

    public void init(GuiCreator guiCreator, WindowContainer windowContainer, String string) {
        this.s = new ImageTool(this.k.getImageObserver());
        this.n = guiCreator;
        this.m = windowContainer;
        this.o = new ProjectList(this.m);
        if (this.n == null) {
            return;
        }
        this.n.createInterface(this, this.m, this.l, string);
        this.appendKeyListener(this);
    }

    public void clearCurrentProject() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            canvas2D = canvas2D.getProject();
            canvas2D.documentReflesh();
        }
    }

    public Document getActiveDocument() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D == null) {
            return null;
        }
        return canvas2D.getDocument();
    }

    public Canvas2D getActiveCanvas() {
        WindowSystemClient windowSystemClient = this.m.getActiveClient();
        if (windowSystemClient != null) {
            return (Canvas2D)windowSystemClient.getCanvas();
        }
        return null;
    }

    public void setActiveCanvas(Canvas2D canvas2D) {
        if ((canvas2D = this.o.setActiveProject((ICanvas2D)canvas2D)) != null) {
            this.m.update((WindowSystemClient)canvas2D, false);
            this.updateUserInterface();
        }
    }

    public Project getActiveProject() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D == null) {
            return null;
        }
        canvas2D = canvas2D.getProject();
        return canvas2D;
    }

    public void registLibrary(String string, ObjectLibrary objectLibrary) {
        if (string != null && objectLibrary != null) {
            this.p.put(string, objectLibrary);
        }
    }

    public ObjectLibrary getLibrary(String string) {
        if ((string = this.p.get(string)) != null && string instanceof ObjectLibrary) {
            return (ObjectLibrary)string;
        }
        return null;
    }

    public ProjectList getProjectList() {
        return this.o;
    }

    public WindowContainer getWindowContainer() {
        return this.m;
    }

    public UserInfo getUserInfo() {
        return this.r;
    }

    public GuiCreator getGuiCreator() {
        return this.n;
    }

    public void registAccel(AccelKey accelKey) {
        this.q.addElement(accelKey);
    }

    public AccelKey getAccel(KeyEvent keyEvent) {
        for (int i = 0; i < this.q.size(); ++i) {
            AccelKey accelKey = (AccelKey)this.q.elementAt(i);
            if (!accelKey.equal(keyEvent.getModifiers(), keyEvent.getKeyCode())) continue;
            return accelKey;
        }
        return null;
    }

    public void registMaskEvent(Command command, int n) {
        this.u.addElement(new MaskCommand(command, n));
    }

    public Command getMaskCommand(int n) {
        for (int i = 0; i < this.u.size(); ++i) {
            MaskCommand maskCommand = (MaskCommand)this.u.elementAt(i);
            if (!maskCommand.isMutchMask(n & 1 | n & 8 | n & 2)) continue;
            return maskCommand.getCommand();
        }
        return null;
    }

    public Vector2 getCommandCollection() {
        return this.l;
    }

    public Command getCommand(Class clazz) {
        for (int i = 0; i < this.l.size(); ++i) {
            Command command = (Command)this.l.elementAt(i);
            if (!command.getClass().equals(clazz)) continue;
            return command;
        }
        return null;
    }

    public void block() {
        this.setEnabled(false);
    }

    public void unblock() {
        this.setEnabled(true);
    }

    public Class getMainClass() {
        return this.k.getClass();
    }

    public MainApplication getApplication() {
        return this.k;
    }

    public void preFrameClose() {
        Vector2 vector2 = this.getCommandCollection();
        for (int i = 0; i < vector2.size(); ++i) {
            Command command = (Command)vector2.elementAt(i);
            command.frameClosing();
        }
    }

    public boolean doModal(Frame frame, Object object, int n, boolean bl, String string, boolean bl2) {
        return this.doModal(frame, object, n, bl, string, null, bl2, -1, -1);
    }

    public boolean doModal(Frame frame, Object object, int n, boolean bl, String string, Component component, boolean bl2) {
        return this.doModal(frame, object, n, bl, string, null, bl2, -1, -1);
    }

    public boolean doModal(Frame window, Object object, int n, boolean bl, String string, Component component, boolean bl2, int n2, int n3) {
        if (window == null) {
            window = this.getParentFrame();
        }
        window = new NethomeDialog((Frame)window, object, n, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        if (object instanceof NethomeDialogInnerComponent) {
            ((NethomeDialogInnerComponent)object).setParentDialog((NethomeDialogComponent)((Object)window));
        }
        ((BasicDialog)window).setInitFocus(component);
        ((Dialog)window).setTitle(string);
        ((Dialog)window).setResizable(bl);
        if (n2 > 0 && n3 > 0) {
            window.setSize(n2, n3);
        }
        this.block();
        if (bl2) {
            ((BasicDialog)window).setVisible(true, true);
        } else {
            ((BasicDialog)window).setVisible(true, true, this.getActiveCanvas());
        }
        this.unblock();
        boolean bl3 = ((BasicDialog)window).getCloseState() == 0;
        window.dispose();
        return bl3;
    }

    public Dialog doModeless(Frame frame, Object object, int n, int n2, boolean bl, String string, Component component, boolean bl2, int n3, int n4) {
        object = new NethomeDialog(frame, object, n, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        ((Dialog)object).setModal(false);
        ((BasicDialog)object).setInitFocus(component);
        ((Dialog)object).setTitle(string);
        ((Dialog)object).setResizable(bl);
        if (n3 > 0 && n4 > 0) {
            ((Window)object).setSize(n3, n4);
        } else {
            ((Window)object).pack();
        }
        if (n2 >= 0) {
            ((BasicDialog)object).setVisible(true, frame, n2);
        } else if (bl2) {
            ((BasicDialog)object).setVisible(true, true);
        } else {
            ((BasicDialog)object).setVisible(true, true, this.getActiveCanvas());
        }
        return object;
    }

    public void appendKeyListener(Object componentArray) {
        if (componentArray instanceof Container) {
            componentArray = (Container)componentArray;
            componentArray.addKeyListener(this);
            if (componentArray.getComponentCount() != 0 && (componentArray = componentArray.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    this.appendKeyListener(componentArray[i]);
                }
            }
            return;
        }
        if (componentArray instanceof Component) {
            componentArray = (Component)componentArray;
            componentArray.addKeyListener(this);
        }
    }

    public ImageTool getImageTool() {
        return this.s;
    }

    public static void updateLayout() {
        MainComponent mainComponent = MainComponent.getInstance();
        if (mainComponent != null) {
            MainComponent.updateLayout(mainComponent);
            ((Component)mainComponent).validate();
            ((Component)mainComponent).doLayout();
        }
    }

    public static void updateLayout(Object componentArray) {
        if (componentArray instanceof Container) {
            componentArray = (Container)componentArray;
            componentArray.invalidate();
            if (componentArray.getComponentCount() != 0 && (componentArray = componentArray.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    MainComponent.updateLayout(componentArray[i]);
                }
            }
            return;
        }
        if (componentArray instanceof Component) {
            componentArray = (Component)componentArray;
            componentArray.invalidate();
        }
    }

    public Frame getParentFrame() {
        return this.k.getParentFrame();
    }

    public TipsMessage getTipsMessage() {
        return this.mStatusBar;
    }

    public void initUserInterface() {
        for (int i = 0; i < this.l.size(); ++i) {
            Command command = (Command)this.l.elementAt(i);
            command.initInterface();
        }
    }

    public void updateUserInterface() {
        for (int i = 0; i < this.l.size(); ++i) {
            Command command = (Command)this.l.elementAt(i);
            command.updateInterface();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            canvas2D.keyPress(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            canvas2D.keyRelease(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public CopyBuffer getCopyBuffer() {
        return this.t;
    }

    public void addPage(String string, Component component) {
        this.add(component, string);
    }

    public void changePage(String string) {
        this.v.show(this, string);
    }

    public Component getActivePage() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isVisible()) continue;
                return componentArray[i];
            }
        }
        return null;
    }

    public void setCursor(Cursor cursor) {
        Component[] componentArray;
        super.setCursor(cursor);
        if (this.getComponentCount() != 0 && (componentArray = this.getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.setCursor(cursor, componentArray[i]);
            }
        }
    }

    public void setCursor(Cursor cursor, Object componentArray) {
        if (componentArray instanceof Container) {
            componentArray = (Container)componentArray;
            componentArray.setCursor(cursor);
            if (componentArray.getComponentCount() != 0 && (componentArray = componentArray.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    this.setCursor(cursor, componentArray[i]);
                }
            }
            return;
        }
        if (componentArray instanceof Component) {
            componentArray = (Component)componentArray;
            componentArray.setCursor(cursor);
        }
    }
}

