/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import java.awt.Container;
import java.util.Vector;
import nethome.ui.ICanvas2D;
import nethome.ui.gui.WindowContainer;
import nethome.ui.gui.WindowSystemClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectList {
    private Vector<WindowSystemClient> mList;
    private WindowSystemClient mActiveProject;
    private WindowContainer mCanvasContainer;

    public ProjectList(WindowContainer windowContainer) {
        this.mCanvasContainer = windowContainer;
        this.mList = new Vector();
    }

    public void addProjectList(WindowSystemClient windowSystemClient) {
        if (!this.mList.contains(windowSystemClient)) {
            this.mList.addElement(windowSystemClient);
            if (this.mCanvasContainer != null) {
                this.mCanvasContainer.addChild(windowSystemClient);
            }
            this.updateActive(windowSystemClient);
        }
    }

    public WindowSystemClient getActiveProject() {
        return this.mActiveProject;
    }

    public WindowSystemClient setActiveProject(ICanvas2D iCanvas2D) {
        WindowSystemClient windowSystemClient = null;
        for (int i = 0; i < this.mList.size(); ++i) {
            WindowSystemClient windowSystemClient2;
            WindowSystemClient windowSystemClient3 = this.mList.elementAt(i);
            if (!(windowSystemClient3 instanceof WindowSystemClient) || (windowSystemClient2 = windowSystemClient3).getCanvas() != iCanvas2D) continue;
            windowSystemClient = windowSystemClient2;
            break;
        }
        if (windowSystemClient != null && windowSystemClient != this.mActiveProject) {
            this.updateActive(windowSystemClient);
            return this.mActiveProject;
        }
        return null;
    }

    private void updateActive(WindowSystemClient windowSystemClient) {
        if (this.mActiveProject != null) {
            this.mActiveProject.setActive(false);
        }
        this.mActiveProject = windowSystemClient;
        this.mActiveProject.setActive(true);
        if (this.mCanvasContainer != null) {
            this.mCanvasContainer.update(this.mActiveProject, false);
            this.mCanvasContainer.getContaner().validate();
        }
    }

    public void removeActiveProject() {
        WindowSystemClient windowSystemClient = this.getActiveProject();
        if (windowSystemClient != null && this.mCanvasContainer != null) {
            if (this.mList.contains(windowSystemClient)) {
                this.mList.removeElement(windowSystemClient);
            }
            this.mCanvasContainer.getContaner().remove((Container)((Object)windowSystemClient));
            this.mCanvasContainer.getContaner().validate();
        }
        if (this.mList.size() > 0) {
            WindowSystemClient windowSystemClient2 = this.mList.lastElement();
            if (windowSystemClient2 != null && windowSystemClient2 instanceof WindowSystemClient) {
                this.updateActive(windowSystemClient2);
            }
        } else {
            this.mActiveProject = null;
        }
    }

    public void removeCanvasChild(WindowSystemClient windowSystemClient) {
        if (windowSystemClient == this.getActiveProject()) {
            this.removeActiveProject();
            return;
        }
        if (windowSystemClient != null && this.mCanvasContainer != null) {
            if (this.mList.contains(windowSystemClient)) {
                this.mList.removeElement(windowSystemClient);
            }
            this.mCanvasContainer.getContaner().remove((Container)((Object)windowSystemClient));
            this.mCanvasContainer.getContaner().validate();
        }
    }

    public Vector<WindowSystemClient> getList() {
        return this.mList;
    }
}

