/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.io.AbstFile;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import java.util.StringTokenizer;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPolygon
extends Geometory
implements Primitive,
IFillableGeometory {
    private static final String GEOMNAME = "POLYGON";
    protected RefList<GPoint2Df> mPoints;
    private transient RefList<GPoint2Df> _pbuf = new RefList();
    public float mLineWidth;
    public int mSmooth;
    public boolean mFill = false;
    private Color mFillColor;

    public GPolygon() {
        this((RefList<GPoint2Df>)new RefList(), 0);
    }

    public GPolygon(RefList<GPoint2Df> refList, int n) {
        this.setGeomName(GEOMNAME);
        this.mPoints = refList;
        this.mSmooth = n;
        this.mGeomColor = Color.black;
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    @Override
    public void getSnapLoop(Vector2<? super GPoint2Df> vector2) {
        for (int i = 0; i <= this.mPoints.size(); ++i) {
            vector2.addElement(this.mPoints.elementAt(i));
        }
    }

    @Override
    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    @Override
    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f3 >= 0.0f) || !(f4 < f) || !(f4 < f2)) continue;
            f2 = f4;
            gPoint2Df3 = gPoint2Df4;
        }
        return gPoint2Df3;
    }

    @Override
    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 >= 0.0f) || !(f5 < f3)) continue;
            gPoint2DfArray[0] = gPoint2Df;
            gPoint2DfArray[1] = gPoint2Df2;
            bl = true;
        }
        return bl;
    }

    @Override
    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    @Override
    public void updateMinMax(Area area) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
        }
    }

    @Override
    public Geometory getCopy() {
        return this.getCopy(new GPolygon());
    }

    @Override
    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GPolygon)) {
            return null;
        }
        GPolygon gPolygon = (GPolygon)geometory;
        RefList refList = new RefList();
        for (int i = 0; i < this.mPoints.size(); ++i) {
            refList.addElement((Object)((GPoint2Df)((Geometory)this.mPoints.elementAt(i)).getCopy()));
        }
        gPolygon.mPoints = refList;
        gPolygon.mFill = this.mFill;
        gPolygon.setFillColor(this.mFillColor);
        gPolygon.setGeomColor(this.mGeomColor);
        gPolygon.mSmooth = this.mSmooth;
        gPolygon.area.maximize();
        gPolygon.updateMinMax(gPolygon.area);
        return gPolygon;
    }

    @Override
    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df2;
        }
        return gPoint2Df;
    }

    @Override
    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = null;
            GPoint2Df gPoint2Df2 = null;
            gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            gPoint2Df2 = i == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 < 0.0f || !(f4 < f3)) continue;
            f3 = f4;
        }
        return f3;
    }

    @Override
    public void offset(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).offset(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).rotate(f, f2, f3);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean isInner(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = i == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(i + 1);
            boolean bl = false;
            boolean bl2 = false;
            if (gPoint2Df.x > f && gPoint2Df.x < f3 && gPoint2Df.y > f2 && gPoint2Df.y < f4) {
                bl = true;
            }
            if (gPoint2Df2.x > f && gPoint2Df2.x < f3 && gPoint2Df2.y > f2 && gPoint2Df2.y < f4) {
                bl2 = true;
            }
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<GPoint2Df> refList) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = i == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(i + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    public RefList<GPoint2Df> getPoints() {
        return this.mPoints;
    }

    public static Object readData(AbstFile abstFile, float f) throws Exception {
        String string;
        GPolygon gPolygon = null;
        RefList refList = new RefList();
        int n = Integer.valueOf(abstFile.readLineFromBuffer().trim());
        int n2 = Integer.valueOf(abstFile.readLineFromBuffer().trim());
        for (int i = 0; i < n2; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(abstFile.readLineFromBuffer(), " ,");
            float f2 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
            float f3 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
            refList.addElement((Object)new GPoint2Df(f2, f3));
        }
        gPolygon = new GPolygon((RefList<GPoint2Df>)refList, n);
        while ((string = abstFile.readLineFromBuffer()) != null && !string.trim().equalsIgnoreCase("</POLYGON>")) {
        }
        return gPolygon;
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName(GEOMNAME);
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("smooth", (Object)Integer.toString(this.mSmooth)));
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("pointsize", (Object)Integer.toString(this.mPoints.size())));
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            objectFolder.addChild(new ObjectNode("x" + (i + 1), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode("y" + (i + 1), (Object)Float.toString(gPoint2Df.y)));
        }
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawAbstDevice(iRichGraphics, this.mGeomColor, this.mFillColor, null);
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    @Override
    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = this.mGeomColor;
        }
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        int n;
        RefList<GPoint2Df> refList = null;
        if (this._pbuf != null) {
            this._pbuf.removeAllElements();
        } else {
            this._pbuf = new RefList();
        }
        if (localAxis2Df != null) {
            for (n = 0; n < this.mPoints.size(); ++n) {
                GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
                float f = localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                float f2 = localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                this._pbuf.addElement((Object)new GPoint2Df(f, f2));
            }
            refList = this._pbuf;
        } else {
            refList = this.mPoints;
        }
        n = 0;
        if (color != null && color2 != null && color.getRed() == color2.getRed() && color.getGreen() == color2.getGreen() && color.getBlue() == color2.getBlue()) {
            n = 1;
        }
        if (refList.size() > 1) {
            if (this.mFill && color2 != null) {
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon(refList, null);
            }
            if (this.mFill && n != 0) {
                return;
            }
            if (color != null) {
                iRichGraphics.setColor(color);
                iRichGraphics.drawPolygon(refList, null);
            }
        }
        this._pbuf.removeAllElements();
    }

    @Override
    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        int n;
        if (bl) {
            n = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(iRichGraphics, color, color, null);
            this.mFill = n;
        }
        for (n = 0; n < this.mPoints.size(); ++n) {
            ((GPoint2Df)this.mPoints.elementAt(n)).drawHighLight(iRichGraphics, color, false);
        }
    }

    public GLine getNearAsLine(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        GPoint2Df gPoint2Df2 = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df3 = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y);
            if (f4 < 0.0f || !(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df3;
            gPoint2Df2 = gPoint2Df4;
        }
        if (gPoint2Df != null && gPoint2Df2 != null) {
            return new GLine(gPoint2Df, gPoint2Df2);
        }
        return null;
    }

    @Override
    public void flipx(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipx(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipy(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipy(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rot(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).rot(f, f2, f3, f4);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    @Override
    public boolean isFillMode() {
        return this.mFill;
    }

    @Override
    public Color getFillColor() {
        return this.mFillColor;
    }

    @Override
    public void setFillColor(Color color) {
        this.mFillColor = color;
    }
}

