/*
 * Decompiled with CFR 0.152.
 */
package nethome.doc;

import com.kt.io.AbstFile;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import java.util.Vector;
import jp.kitec.kwt.KViewPort;
import nethome.doc.Document;
import nethome.geom.WorkSheet;
import nethome.geom.primitive.Geometory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
implements Serializable {
    private String mName;
    protected WorkSheet mWorkSheet;
    protected KViewPort mViewPort;
    private boolean mVisible;
    protected Vector2<Geometory> mPrims;
    private Vector<Geometory> mSelectBuffer;
    private static Vector<Geometory> mSortTmp = new Vector();

    public Layer(WorkSheet workSheet, KViewPort kViewPort) {
        this(null, workSheet, kViewPort);
    }

    public Layer(String string, WorkSheet workSheet, KViewPort kViewPort) {
        this.mName = string;
        this.mPrims = new Vector2();
        this.mVisible = true;
        this.mViewPort = kViewPort;
        this.mWorkSheet = workSheet;
        this.mSelectBuffer = new Vector();
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setWorkSheet(WorkSheet workSheet) {
        this.mWorkSheet = workSheet;
    }

    public WorkSheet getWorkSheet() {
        return this.mWorkSheet;
    }

    public KViewPort getViewPort() {
        return this.mViewPort;
    }

    public void renumberID() {
        for (int i = 0; i < this.mPrims.size(); ++i) {
            Geometory geometory = (Geometory)this.mPrims.elementAt(i);
            geometory.setID(i + 1);
        }
    }

    public void save(ObjectFolder objectFolder) {
        objectFolder.setName("LAYER");
        objectFolder.addChild(new ObjectNode("TYPE", (Object)"LAYER"));
        for (int i = 0; i < this.mPrims.size(); ++i) {
            Geometory geometory = (Geometory)this.mPrims.elementAt(i);
            ObjectFolder objectFolder2 = new ObjectFolder("");
            geometory.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
    }

    public void addSelectBuffer(Geometory geometory, boolean bl) {
        if (!this.mPrims.contains((Object)geometory)) {
            return;
        }
        if (this.mSelectBuffer.contains(geometory)) {
            if (bl) {
                this.mSelectBuffer.removeElement(geometory);
            }
        } else {
            this.mSelectBuffer.addElement(geometory);
        }
        this.sortSelectBuffer();
    }

    public void clearSelectBuffer() {
        this.mSelectBuffer.removeAllElements();
    }

    public Vector<Geometory> getSelectBuffer() {
        return this.mSelectBuffer;
    }

    public void sortSelectBuffer() {
        int n;
        if (this.mSelectBuffer.size() == 0) {
            return;
        }
        mSortTmp.removeAllElements();
        for (n = 0; n < this.mPrims.size(); ++n) {
            Geometory geometory = (Geometory)this.mPrims.elementAt(n);
            if (!this.mSelectBuffer.contains(geometory)) continue;
            mSortTmp.addElement(geometory);
        }
        this.mSelectBuffer.removeAllElements();
        for (n = 0; n < mSortTmp.size(); ++n) {
            this.mSelectBuffer.addElement(mSortTmp.elementAt(n));
        }
        mSortTmp.removeAllElements();
    }

    public void saveGeom(AbstFile abstFile, String string) throws Exception {
    }

    public void reflesh() {
        this.mPrims.removeAllElements();
        this.mVisible = true;
    }

    public boolean isHasData() {
        return this.mPrims.size() > 0;
    }

    public static Object readData(ObjectFolder objectFolder, Document document, float f) throws Exception {
        return null;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean bl) {
        this.mVisible = bl;
    }

    public Vector2<Geometory> getPrims() {
        return this.mPrims;
    }

    public void setPrims(Vector2<Geometory> vector2) {
        this.mPrims = vector2;
    }

    public void addPrimitive(Geometory geometory) {
        this.mPrims.addElement((Object)geometory);
    }

    public void delPrimitive(Geometory geometory) {
        this.mPrims.removeElement((Object)geometory);
    }

    public void deleteAll() {
        this.mPrims.removeAllElements();
    }
}

