/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import option.io.pdfcommon.util.PdfUtil;

public class PdfMetrices {
    public static final int TRANSLATE = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    public static final int SKEW = 4;
    public static final int TEXT_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    public static final int FORM_TYPE = 3;
    private int[] k = new int[4];
    private float[][] l = new float[3][3];
    private boolean m = false;
    private boolean n = false;
    private boolean o = false;
    private boolean p = false;
    private float q;
    private float r;
    private float s;
    private float t;
    private float u;
    private float v;
    private float w;
    private int x = 0;
    private PdfUtil y = new PdfUtil();

    public PdfMetrices(int n) {
        this.x = n;
        PdfMetrices pdfMetrices = this;
        pdfMetrices.k[0] = 1;
        pdfMetrices.k[1] = 2;
        pdfMetrices.k[2] = 3;
        pdfMetrices.k[3] = 4;
    }

    public void setTranslation(float f, float f2) {
        this.q = f;
        this.r = f2;
        this.m = true;
    }

    public float getTranslationX() {
        return this.q;
    }

    public float getTranslationY() {
        return this.r;
    }

    public void setScale(float f, float f2) {
        this.s = f;
        this.t = f2;
        this.n = true;
    }

    public float getScaleX() {
        return this.s;
    }

    public float getScaleY() {
        return this.t;
    }

    public void setRotation(float f) {
        this.u = (float)Math.PI * f / 180.0f;
        this.o = true;
    }

    public float getRotateTheta() {
        return this.u;
    }

    public void setSkew(float f, float f2) {
        this.v = (float)Math.PI * f / 180.0f;
        this.w = (float)Math.PI * f2 / 180.0f;
        this.p = true;
    }

    public float getSkewX() {
        return this.v;
    }

    public float getSkewY() {
        return this.w;
    }

    public final String toString() {
        PdfMetrices.a(this.l);
        float[][] fArray = new float[3][3];
        int n = 0;
        while (n < this.k.length) {
            switch (this.k[n]) {
                case 1: {
                    if (!this.m) break;
                    PdfMetrices.a(fArray);
                    fArray[2][0] = this.q;
                    fArray[2][1] = this.r;
                    this.l = this.multiply(fArray, this.l);
                    break;
                }
                case 3: {
                    if (!this.n) break;
                    PdfMetrices.a(fArray);
                    fArray[0][0] = this.s;
                    fArray[1][1] = this.t;
                    this.l = this.multiply(fArray, this.l);
                    break;
                }
                case 2: {
                    if (!this.o) break;
                    PdfMetrices.a(fArray);
                    float f = (float)Math.cos(this.u);
                    float f2 = (float)Math.sin(this.u);
                    fArray[0][0] = f;
                    fArray[0][1] = -f2;
                    fArray[1][0] = f2;
                    fArray[1][1] = f;
                    this.l = this.multiply(fArray, this.l);
                    break;
                }
                case 4: {
                    if (!this.p) break;
                    PdfMetrices.a(fArray);
                    float f = (float)Math.tan(this.v);
                    float f2 = (float)Math.tan(this.w);
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = f;
                    fArray[1][0] = f2;
                    fArray[1][1] = 1.0f;
                    this.l = this.multiply(fArray, this.l);
                }
            }
            ++n;
        }
        return this.toString(this.l[0][0], this.l[0][1], this.l[1][0], this.l[1][1], this.l[2][0], this.l[2][1]);
    }

    private static void a(float[][] fArray) {
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                fArray[n3][n4] = n3 == n4 ? 1 : 0;
                ++n4;
            }
            ++n3;
        }
    }

    public String toString(float f, float f2, float f3, float f4, float f5, float f6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.y.formatPrint(f)) + " ");
        stringBuffer.append(String.valueOf(this.y.formatPrint(f2)) + " ");
        stringBuffer.append(String.valueOf(this.y.formatPrint(f3)) + " ");
        stringBuffer.append(String.valueOf(this.y.formatPrint(f4)) + " ");
        stringBuffer.append(String.valueOf(this.y.formatPrint(f5)) + " ");
        stringBuffer.append(String.valueOf(this.y.formatPrint(f6)) + " ");
        if (this.x == 1) {
            stringBuffer.append("Tm\n");
        } else {
            stringBuffer.append("cm\n");
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.x;
    }

    public void setType(int n) {
        this.x = n;
    }

    public int[] getTransformOrder() {
        return this.k;
    }

    public void setTransformOrder(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.k = nArray;
    }

    public float[][] multiply(float[][] fArray, float[][] fArray2) {
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray3 = new float[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    float[] fArray4 = fArray3[n3];
                    int n6 = n4;
                    fArray4[n6] = fArray4[n6] + fArray[n3][n5] * fArray2[n5][n4];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return fArray3;
    }
}

