/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class PdfFont
extends PdfIndirectObject
implements DefinedName {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    public static final int DEFAULT_CID_WIDTH = 600;
    protected PdfDictionary dict = new PdfDictionary();
    private FontDescriptor cH = null;
    private Encoding cI = new Encoding("MS932");
    private Vector cJ = new Vector();
    private float cK = 12.0f;
    CmapStream cL = null;
    EmbedFontFile cM = null;
    private Font cN;
    private FontMetrics cO;

    public PdfFont() {
        this.dict.put(TYPE, FONT);
    }

    public void setSubtype(PdfName pdfName) {
        this.dict.put(SUBTYPE, pdfName);
    }

    public void setName(PdfName pdfName) {
        this.dict.put(FONTNAME, pdfName);
    }

    public void setBaseFont(PdfName pdfName) {
        this.dict.put(BASEFONT, pdfName);
    }

    public void setFontBBox(PdfRect pdfRect) {
        this.dict.put(FONTBBOX, pdfRect);
    }

    public void setFontMatrix(PdfArray pdfArray) {
        this.dict.put(FONTMATRIX, pdfArray);
    }

    public void setEncoding(Encoding encoding) {
        this.cI = encoding;
        if (this.cI == null) {
            this.cI = new Encoding("MS932");
        }
        switch (encoding.getEncoingDataType()) {
            case 1: {
                this.dict.put(ENCODING, encoding.getEncodingPdfName());
                return;
            }
            case 2: {
                this.dict.put(ENCODING, encoding.getEncodingDict());
                this.dict.put(CHARPROCS, encoding.getCharProcs());
                this.setWidths(encoding.getWidths());
                return;
            }
        }
        this.dict.put(ENCODING, encoding.getEncodingPdfName());
    }

    public void setFirstChar(int n) {
        this.dict.put(FIRSTCHAR, new Integer(n));
    }

    public void setLastChar(int n) {
        this.dict.put(LASTCHAR, new Integer(n));
    }

    public void setWidths(PdfArray pdfArray) {
        this.dict.put(WIDTHS, pdfArray);
    }

    public void setFontDescriptor(FontDescriptor fontDescriptor) {
        this.cH = fontDescriptor;
    }

    public void setSize(float f) {
        this.cK = f;
    }

    public void setDescendantFont(CIDFont cIDFont) {
        this.cJ.addElement(cIDFont);
    }

    public PdfName getSubtype() {
        return (PdfName)this.dict.get(SUBTYPE);
    }

    public PdfName getName() {
        return (PdfName)this.dict.get(FONTNAME);
    }

    public PdfName getBaseFont() {
        return (PdfName)this.dict.get(BASEFONT);
    }

    public int getFirstChar() {
        return (Integer)this.dict.get(FIRSTCHAR);
    }

    public int getLastChar() {
        return (Integer)this.dict.get(LASTCHAR);
    }

    public PdfArray getWidths() {
        return (PdfArray)this.dict.get(WIDTHS);
    }

    public FontDescriptor getFontDescriptor() {
        return this.cH;
    }

    public PdfName getEncodingName() {
        return (PdfName)this.dict.get(ENCODING);
    }

    public Encoding getEncoding() {
        return this.cI;
    }

    public float getSize() {
        return this.cK;
    }

    public Vector getDescendantFonts() {
        return this.cJ;
    }

    public void setCmapStream(CmapStream cmapStream) {
        this.cL = cmapStream;
    }

    public CmapStream getCmapStream() {
        return this.cL;
    }

    public void setEmbedFontFile(EmbedFontFile embedFontFile) {
        this.cM = embedFontFile;
    }

    public EmbedFontFile getEmbedFontFile() {
        return this.cM;
    }

    public final String toString() {
        if (this.cH != null) {
            this.dict.put(FONTDESCRIPTOR, this.cH.getReference());
        }
        if (this.c()) {
            this.dict.put(DESCENDANTFONTS, this.d());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (PdfFont)object;
        return this.getName().equals(((PdfFont)object).getName());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public int stringWidth(String object) {
        object = ((String)object).toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            n += this.charWidth((char)object[n2]);
            ++n2;
        }
        return n;
    }

    public int charWidth(char c) {
        PdfFont pdfFont = this;
        String string = pdfFont.getBaseFont().getName();
        if (pdfFont.cN == null || !pdfFont.cN.getName().equals(string)) {
            pdfFont.cN = new Font(string, 0, 1000);
            pdfFont.cO = Toolkit.getDefaultToolkit().getFontMetrics(pdfFont.cN);
        }
        if (pdfFont.cO.charWidth(c) > 800) {
            return 1000;
        }
        return 600;
    }

    public int getAscent() {
        return 0;
    }

    public int getDescent() {
        return 0;
    }

    private boolean c() {
        return this.cJ.size() > 0;
    }

    private PdfArray d() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfArray pdfArray = new PdfArray();
        int n = this.cJ.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((CIDFont)this.cJ.elementAt(n2)).getReference();
            if (hashMap.get(string) == null) {
                hashMap.put(string, "");
                pdfArray.addElement(string);
            }
            ++n2;
        }
        return pdfArray;
    }

    public void write(PdfOutFile pdfOutFile) {
        if (this.cH != null) {
            this.dict.put(FONTDESCRIPTOR, this.cH.getReference());
            if (this.cM != null) {
                this.cH.setFontfile2(this.cM.getReference());
            }
        }
        if (this.c()) {
            this.dict.put(DESCENDANTFONTS, this.d());
        }
        if (this.cL != null) {
            this.dict.put(TOUNICODE, this.cL.getReference());
        }
        this.startObject(pdfOutFile);
        this.dict.write(pdfOutFile);
        this.endObject(pdfOutFile);
    }
}

