/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfRect {
    private float de;
    private float df;
    private float dg;
    private float dh;

    public PdfRect() {
    }

    public PdfRect(float f, float f2, float f3, float f4) {
        this.setPoints(f, f2, f3, f4);
    }

    public float getWidth() {
        return this.dg - this.de;
    }

    public float getHeight() {
        return this.dh - this.df;
    }

    public float getLux() {
        return this.de;
    }

    public float getLuy() {
        return this.df;
    }

    public float getRdx() {
        return this.dg;
    }

    public float getRdy() {
        return this.dh;
    }

    public void setPoints(float f, float f2, float f3, float f4) {
        this.setLux(f);
        this.setLuy(f2);
        this.setRdx(f3);
        this.setRdy(f4);
    }

    public void setLux(float f) {
        this.de = f;
    }

    public void setLuy(float f) {
        this.df = f;
    }

    public void setRdx(float f) {
        this.dg = f;
    }

    public void setRdy(float f) {
        this.dh = f;
    }

    public void changeDirection() {
        float f = this.dg;
        this.dg = this.dh;
        this.dh = f;
    }

    public void rotate(float f) {
        f = (float)Math.PI * f / 180.0f;
        float f2 = (float)Math.cos(f);
        f = (float)Math.sin(f);
        this.de = f2 * this.de - f * this.df;
        this.df = f * this.de + f2 * this.df;
        this.dg = f2 * this.dg - f * this.dh;
        this.dh = f * this.dg + f2 * this.dh;
    }

    public void scale(float f, float f2) {
        this.dg = this.de + (this.dg - this.de) * f;
        this.dh = this.df + (this.dh - this.df) * f2;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[ ");
        printWriter.print(this.de);
        printWriter.print(" ");
        printWriter.print(this.df);
        printWriter.print(" ");
        printWriter.print(this.dg);
        printWriter.print(" ");
        printWriter.print(this.dh);
        printWriter.print(" ]");
        printWriter.close();
        return stringWriter.toString();
    }

    public void write(PdfOutFile object) {
        object = ((PdfOutFile)object).getPrintStream();
        ((PrintStream)object).println(this.toString());
    }
}

