/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import com.kt.util.RefList;
import java.awt.Color;
import java.awt.Image;
import java.awt.Polygon;
import java.io.OutputStream;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PageSize;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.util.PdfRect;

public class PdfDrawer {
    protected PdfDocument document;
    private Contents bV;
    private PdfOutFile bW;
    protected PageSize mPageSize = new PageSize();

    public PdfDrawer() {
        this.document = new PdfDocument();
    }

    public void addPage() {
        Page page = this.getBody().createPage(this.mPageSize.getPageRect("A4"));
        this.getBody().addPage(page);
        this.bV = this.getBody().getCurrentPage().getContents();
    }

    public void addPage(int n, int n2) {
        Page page = this.document.getBody().createPage(new PdfRect(0.0f, 0.0f, n, n2));
        this.document.getBody().addPage(page);
    }

    public void addPage(float f, float f2) {
        Page page = this.document.getBody().createPage(new PdfRect(0.0f, 0.0f, (int)f, (int)f2));
        this.document.getBody().addPage(page);
    }

    public void addPage(PdfRect object) {
        object = this.document.getBody().createPage((PdfRect)object);
        this.document.getBody().addPage((Page)object);
        this.bV = this.document.getBody().getCurrentPage().getContents();
    }

    public void setNowContents(int n) {
        if (n >= 0 && n < this.document.getBody().getPagesCount()) {
            this.document.getBody().setCurrentPage(n);
            this.bV = this.document.getBody().getCurrentPage().getContents();
        }
    }

    public Contents getNowContents() {
        this.bV = this.document.getBody().getCurrentPage().getContents();
        return this.bV;
    }

    public Page getCurrentPage() {
        return this.document.getBody().getCurrentPage();
    }

    public void setPageSize(PdfRect pdfRect) {
        this.getCurrentPage().setMediabox(pdfRect);
    }

    public void writeLine(float f, float f2, float f3, float f4, Object object, Color color) {
        if (this.bV != null) {
            this.bV.writeLine(f, f2, f3, f4, object, color);
        }
    }

    public void writeRectangle(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writeRectangle(f, f2, f3, f4, object, color, bl);
        }
    }

    public void writeArc(float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writeArc(f, f2, f3, f4, f5, f6, object, color, bl);
        }
    }

    public void writeEllipse(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writeEllipse(f, f2, f3, f4, object, color, bl);
        }
    }

    public void writeCircle(float f, float f2, float f3, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writeCircle(f, f2, f3, object, color, bl);
        }
    }

    public void writePolygon(Polygon polygon, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writePolygon(polygon, object, color, bl);
        }
    }

    public void writePolygon(RefList refList, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writePolygon(refList, object, color, bl);
        }
    }

    public void writePolygon(float[] fArray, Object object, Color color, boolean bl) {
        if (this.bV != null) {
            this.bV.writePolygon(fArray, object, color, bl);
        }
    }

    public void writeImage(ImageXObject imageXObject, float f, float f2, float f3, float f4, float f5) {
        if (this.bV != null) {
            this.bV.writeImage(imageXObject, f, f2, f3, f4, f5);
        }
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5) {
        if (this.bV != null) {
            this.bV.writeForm(formXObject, f, f2, f3, f4, f5);
        }
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color) {
        if (this.bV != null) {
            this.bV.writeForm(formXObject, f, f2, f3, f4, f5, f6, object, color);
        }
    }

    public void writeImage(Image object, float f, float f2, float f3, float f4, float f5) {
        object = new ImageXObject((Image)object);
        if (this.bV != null) {
            this.bV.writeImage((ImageXObject)object, f, f2, f3, f4, f5);
        }
    }

    public void writeImage(int[] object, int n, int n2, float f, float f2, float f3, float f4, float f5) {
        object = new ImageXObject((int[])object, n, n2);
        if (this.bV != null) {
            this.bV.writeImage((ImageXObject)object, f, f2, f3, f4, f5);
        }
    }

    public void writeLink(String string, PdfRect pdfRect) {
        if (this.bV != null) {
            this.bV.writeLink(string, pdfRect);
        }
    }

    public void writeLink(PdfRect pdfRect, String string, float f) {
        if (this.bV != null) {
            this.bV.writeLink(string, pdfRect, f);
        }
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5, float f6, String string3, boolean bl2) {
        if (this.bV != null) {
            this.bV.writeText(string, f, f2, string2, f3, color, bl, n, f4, f5, f6, string3, bl2);
        }
    }

    public void openFile(String string) {
        this.bW = new PdfOutFile();
        this.bW.setFile(string);
        this.document.setOutputFile(this.bW);
    }

    public void closeFile() {
        int n = this.document.getBody().getPagesCount();
        int n2 = 0;
        while (n2 < n) {
            this.document.getBody().getPageElementAt(n2).getContents().endContents();
            ++n2;
        }
    }

    public boolean writeToFile() {
        if (this.bW == null || this.bW.getPath().equals("")) {
            return false;
        }
        return this.document.writeToFile();
    }

    public void writeToStream(OutputStream outputStream) {
        this.document.writeToStream(outputStream);
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public Body getBody() {
        return this.document.getBody();
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }

    public void flush() {
        if (this.document != null) {
            this.document.flush();
        }
    }

    public PdfOutFile getTargetFile() {
        return this.bW;
    }

    public void flushStream() {
        this.document.flush();
    }

    public void setTargetFile(PdfOutFile pdfOutFile) {
        this.bW = pdfOutFile;
    }
}

