/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Style;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class FontDescriptor
extends PdfIndirectObject
implements DefinedName {
    private PdfDictionary dict = new PdfDictionary();
    private PdfName ds;
    private EmbedFontFile dt;

    public FontDescriptor() {
        this.dict.put(TYPE, FONTDESCRIPTOR);
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        if (this.dt != null) {
            this.dict.put(FONTFILE2, this.dt.getReference());
        }
        this.startObject(pdfOutFile);
        this.dict.write(pdfOutFile);
        this.endObject(pdfOutFile);
    }

    public void setAscent(int n) {
        this.dict.put(ASCENT, new Integer(n));
    }

    public int getAscent() {
        return (Integer)this.dict.get(ASCENT);
    }

    public void setCapHeight(int n) {
        this.dict.put(CAPHEIGHT, new Integer(n));
    }

    public void setDescent(int n) {
        this.dict.put(DESCENT, new Integer(n));
    }

    public int getDescent() {
        return (Integer)this.dict.get(DESCENT);
    }

    public void setFlags(int n) {
        this.dict.put(FLAGS, new Integer(n));
    }

    public void setFontBBox(PdfRect pdfRect) {
        this.dict.put(FONTBBOX, pdfRect);
    }

    public void setFontName(PdfName pdfName) {
        this.ds = pdfName;
        this.dict.put(FONTNAME, pdfName);
    }

    public void setItalicAngle(int n) {
        this.dict.put(ITALICANGLE, new Integer(n));
    }

    public void setStemV(int n) {
        this.dict.put(STEMV, new Integer(n));
    }

    public void setAvgWidth(int n) {
        this.dict.put(AVGWIDTH, new Integer(n));
    }

    public void setLeading(int n) {
        this.dict.put(LEADING, new Integer(n));
    }

    public void setMaxWidth(int n) {
        this.dict.put(MAXWIDTH, new Integer(n));
    }

    public void setMissingWidth(int n) {
        this.dict.put(MISSINGWIDTH, new Integer(n));
    }

    public void setStemH(int n) {
        this.dict.put(STEMH, new Integer(n));
    }

    public void setXHeight(int n) {
        this.dict.put(XHEIGHT, new Integer(n));
    }

    public void setCharSet(String string) {
        this.dict.put(CHARSET, "(" + string + ")");
    }

    public void setStyle(Style style) {
        this.dict.put(STYLE, style);
    }

    public void setLang(PdfName pdfName) {
        this.dict.put(LANG, pdfName);
    }

    public void setFontfile2(String string) {
        this.dict.put(FONTFILE2, string);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (FontDescriptor)object;
        return this.getFontName().equals(((FontDescriptor)object).getFontName());
    }

    public final int hashCode() {
        return this.getFontName().hashCode();
    }

    public PdfName getFontName() {
        return this.ds;
    }

    public EmbedFontFile getMEmbedFontFile() {
        return this.dt;
    }

    public void setMEmbedFontFile(EmbedFontFile embedFontFile) {
        this.dt = embedFontFile;
    }
}

