/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfDocumentInfo
extends PdfIndirectObject
implements DefinedName {
    private String title = "";
    private String di = "";
    private String dj = "";
    private String dk = "";
    private String dl = "";
    private String dm = "";
    private PdfDictionary dict = new PdfDictionary();
    private PdfDocument document;
    private Date dn;
    private Date do;
    private PdfUtil y = new PdfUtil();

    public PdfDocumentInfo() {
        this.setCreationDate(new GregorianCalendar().getTime());
        this.setCreator("Kitec Corp");
        this.setProducer("Kitec Corp pdf Creator");
    }

    protected void finalize() throws Throwable {
        this.dict.clear();
        this.dict = null;
        super.finalize();
    }

    public PdfDocumentInfo(PdfDocument pdfDocument) {
        this();
        this.document = pdfDocument;
    }

    public PdfDictionary getDict() {
        return this.dict;
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void setDocument(PdfDocument pdfDocument) {
        this.document = pdfDocument;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.dict.put(TITLE, this.y.toTextString(string));
    }

    public String getAuthor() {
        return this.di;
    }

    public void setAuthor(String string) {
        this.di = string;
        this.dict.put(AUTHOR, this.y.toTextString(string));
    }

    public String getSubject() {
        return this.dj;
    }

    public void setSubject(String string) {
        this.dj = string;
        this.dict.put(SUBJECT, this.y.toTextString(string));
    }

    public String getKeywords() {
        return this.dk;
    }

    public void setKeywords(String string) {
        this.dk = string;
        this.dict.put(KEYWORDS, this.y.toTextString(string));
    }

    public String getCreator() {
        return this.dl;
    }

    public void setCreator(String string) {
        this.dl = string;
        this.dict.put(CREATOR, this.y.toTextString(string));
    }

    public String getProducer() {
        return this.dm;
    }

    public void setProducer(String string) {
        this.dm = string;
        this.dict.put(PRODUCER, this.y.toTextString(string));
    }

    public Date getCreationDate() {
        return this.dn;
    }

    public void setCreationDate(Date date) {
        this.dn = date;
        this.dict.put(CREATIONDATE, this.y.toTextString(this.y.toDateString(date)));
    }

    public Date getModDate() {
        return this.do;
    }

    public void setModDate(Date date) {
        this.do = date;
        this.dict.put(MODDATE, this.y.toTextString(this.y.toDateString(date)));
    }

    public void setTrapped(PdfName pdfName) {
        this.dict.put(TRAPPED, pdfName);
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.setModDate(new GregorianCalendar().getTime());
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        pdfOutFile.getPrintStream().println(this.toString());
    }
}

