/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import java.util.Vector;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySort;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeNode;
import jp.kitec.math.searches.regiontree.RegionTreeRestrictNode;

public class RegionTreeBuilder
implements NodeComparator {
    public static final double tolerance = 1.0E-10;
    Vector vectorAllNodes = new Vector(100, 100);
    Vector vectorAllRestrictNodes = new Vector(100, 100);
    Vector vectorAllArray = new Vector(10, 10);
    Vector vectorAllSort = new Vector(100, 100);
    BinarySort sortLeft = new BinarySort(this, new BinarySortBuilder());
    BinarySort sortRight = new BinarySort(this, new BinarySortBuilder());
    BinarySort sortAll = new BinarySort(this, new BinarySortBuilder());
    int currentNode = 0;
    int currentRestrictNode = 0;
    int depth;
    boolean ascent;

    public void resetAllNodeFlags() {
        int n = 0;
        while (n < this.vectorAllNodes.size()) {
            RegionTreeNode regionTreeNode = (RegionTreeNode)this.vectorAllNodes.get(n);
            regionTreeNode.setFlag(false);
            ++n;
        }
    }

    public void clearNodes() {
        int n = 0;
        while (n < this.vectorAllArray.size()) {
            Vector vector = (Vector)this.vectorAllArray.get(n);
            vector.clear();
            ++n;
        }
        this.currentNode = 0;
        this.vectorAllSort.clear();
        this.vectorAllNodes.clear();
        this.vectorAllRestrictNodes.clear();
    }

    private RegionTreeRestrictNode addRestrictNodes() {
        RegionTreeRestrictNode regionTreeRestrictNode = null;
        if (this.vectorAllRestrictNodes.size() <= this.currentRestrictNode) {
            regionTreeRestrictNode = new RegionTreeRestrictNode();
            this.vectorAllRestrictNodes.add(regionTreeRestrictNode);
        } else {
            regionTreeRestrictNode = (RegionTreeRestrictNode)this.vectorAllRestrictNodes.get(this.currentRestrictNode);
        }
        regionTreeRestrictNode.reset();
        ++this.currentRestrictNode;
        return regionTreeRestrictNode;
    }

    public void addNodes(RectangleSupplier rectangleSupplier) {
        RegionTreeNode regionTreeNode = this.addNodes();
        RegionTreeNode regionTreeNode2 = this.addNodes();
        regionTreeNode.set(rectangleSupplier);
        regionTreeNode.setLowerLeft(true);
        regionTreeNode.setPairNode(regionTreeNode2);
        regionTreeNode2.set(rectangleSupplier);
        regionTreeNode2.setLowerLeft(false);
        regionTreeNode2.setPairNode(regionTreeNode);
    }

    private RegionTreeNode addNodes() {
        RegionTreeNode regionTreeNode = null;
        if (this.vectorAllNodes.size() <= this.currentNode) {
            regionTreeNode = new RegionTreeNode();
            this.vectorAllNodes.add(regionTreeNode);
        } else {
            regionTreeNode = (RegionTreeNode)this.vectorAllNodes.get(this.currentNode);
        }
        regionTreeNode.reset();
        ++this.currentNode;
        return regionTreeNode;
    }

    public RegionTreeNode getSortedNode(int n) {
        return (RegionTreeNode)this.vectorAllSort.get(n);
    }

    public void build(RegionTree regionTree) {
        regionTree.root = this.build();
        regionTree.allNodes = new RegionTreeNode[this.vectorAllSort.size()];
        int n = 0;
        while (n < regionTree.allNodes.length) {
            regionTree.allNodes[n] = (RegionTreeNode)this.vectorAllSort.get(n);
            ++n;
        }
        this.clearNodes();
    }

    private RegionTreeRestrictNode build() {
        return this.build(this.vectorAllNodes, 0, this.vectorAllNodes.size(), 0);
    }

    private synchronized RegionTreeRestrictNode build(Vector vector, int n, int n2, int n3) {
        double d;
        RegionTreeNode regionTreeNode;
        Vector vector2 = null;
        if (n3 < this.vectorAllArray.size()) {
            vector2 = (Vector)this.vectorAllArray.get(n3);
        } else {
            vector2 = new Vector(100, 100);
            this.vectorAllArray.add(vector2);
        }
        vector2.clear();
        this.sortLeft.clearNodes();
        this.sortRight.clearNodes();
        this.sortAll.clearNodes();
        if (vector.size() <= 1 || n >= n2 - 1) {
            return null;
        }
        this.depth = n3;
        this.ascent = true;
        int n4 = n;
        while (n4 < n2) {
            regionTreeNode = (RegionTreeNode)vector.get(n4);
            d = regionTreeNode.getCompareValue(n3);
            this.sortAll.add(regionTreeNode);
            ++n4;
        }
        this.sortAll.getAllNode(vector2);
        int n5 = vector2.size() / 2;
        regionTreeNode = (RegionTreeNode)vector2.get(n5);
        RegionTreeRestrictNode regionTreeRestrictNode = this.addRestrictNodes();
        regionTreeRestrictNode.setValue(regionTreeNode.getCompareValue(n3));
        int n6 = n;
        while (n6 < n2) {
            double d2;
            regionTreeNode = (RegionTreeNode)vector.get(n6);
            d = regionTreeNode.isLowerLeft() ? regionTreeNode.getCompareValue(n3) : regionTreeNode.getPairNode().getCompareValue(n3);
            double d3 = d2 = !regionTreeNode.isLowerLeft() ? regionTreeNode.getCompareValue(n3) : regionTreeNode.getPairNode().getCompareValue(n3);
            if (!regionTreeNode.getFlag() && !regionTreeNode.getPairNode().getFlag() && RegionTreeBuilder.equals(d, regionTreeRestrictNode.getValue()) <= 0 && RegionTreeBuilder.equals(regionTreeRestrictNode.getValue(), d2) <= 0) {
                this.ascent = true;
                this.sortLeft.add(regionTreeNode.isLowerLeft() ? regionTreeNode : regionTreeNode.getPairNode());
                this.ascent = false;
                this.sortRight.add(!regionTreeNode.isLowerLeft() ? regionTreeNode : regionTreeNode.getPairNode());
                regionTreeNode.setFlag(true);
                regionTreeNode.getPairNode().setFlag(true);
            }
            ++n6;
        }
        Object object = this.sortLeft.getFirst();
        while (object != null) {
            this.vectorAllSort.add(object);
            regionTreeNode = (RegionTreeNode)object;
            regionTreeNode.setFlag(false);
            object = this.sortLeft.getNext();
        }
        regionTreeRestrictNode.setLeftSortedNodes(this.vectorAllSort.size() - this.sortLeft.getNodeCount(), this.vectorAllSort.size());
        object = this.sortRight.getFirst();
        while (object != null) {
            this.vectorAllSort.add(object);
            regionTreeNode = (RegionTreeNode)object;
            regionTreeNode.setFlag(false);
            object = this.sortRight.getNext();
        }
        regionTreeRestrictNode.setRightSortedNodes(this.vectorAllSort.size() - this.sortRight.getNodeCount(), this.vectorAllSort.size());
        RegionTreeRestrictNode regionTreeRestrictNode2 = this.build(vector2, 0, n5, n3 + 1);
        regionTreeRestrictNode.setLeft(regionTreeRestrictNode2);
        regionTreeRestrictNode2 = this.build(vector2, n5 + 1, vector2.size(), n3 + 1);
        regionTreeRestrictNode.setRight(regionTreeRestrictNode2);
        return regionTreeRestrictNode;
    }

    static int equals(double d, double d2) {
        if (Math.abs(d - d2) <= 1.0E-10) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public int compare(Object object, Object object2) {
        double d;
        RegionTreeNode regionTreeNode = (RegionTreeNode)object;
        RegionTreeNode regionTreeNode2 = (RegionTreeNode)object2;
        double d2 = regionTreeNode.getCompareValue(this.depth);
        if (d2 == (d = regionTreeNode2.getCompareValue(this.depth))) {
            return 0;
        }
        if (this.ascent && d2 < d || !this.ascent && d2 > d) {
            return -1;
        }
        return 1;
    }

    public int compare(Object object, double d) {
        RegionTreeNode regionTreeNode = (RegionTreeNode)object;
        double d2 = regionTreeNode.getCompareValue(this.depth);
        if (d2 == d) {
            return 0;
        }
        if (this.ascent && d2 < d || !this.ascent && d2 > d) {
            return -1;
        }
        return 1;
    }

    public boolean addSameValue(Object object, Object object2) {
        return false;
    }
}

