/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import com.kt.geom.K2DPathIterator;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.Searchable;
import jp.kitec.math.geom.datapassing.ToolAdditData;
import jp.kitec.math.geom.datapassing.ToolFigure2D;
import jp.kitec.math.geom.datapassing.ToolFigure2DArc;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2DCollection;
import jp.kitec.math.geom.datapassing.complete.ToolArc;
import jp.kitec.math.geom.datapassing.complete.ToolFigure;
import jp.kitec.math.geom.datapassing.complete.ToolPolylineCollection;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class ToolPolyline
implements ToolPolyline2D,
PolylineEditable,
Searchable,
RectangleSupplier,
Serializable {
    protected ToolPolylineCollection parent;
    protected ToolFigure2D first;
    protected ToolFigure2D last;
    protected int N;
    protected double x;
    protected double y;
    protected double[] rect;
    protected RegionTree tree;
    protected int index;
    protected byte region;
    protected Hashtable hash = new Hashtable();
    protected boolean bChanged;

    public ToolPolyline(ToolPolyline2DCollection toolPolyline2DCollection, int n) {
        this.rect = new double[4];
        this.init(toolPolyline2DCollection, n);
    }

    private void init(ToolPolyline2DCollection toolPolyline2DCollection, int n) {
        this.parent = (ToolPolylineCollection)toolPolyline2DCollection;
        this.last = null;
        this.first = null;
        this.N = 0;
        this.rect[3] = 0.0;
        this.rect[2] = 0.0;
        this.rect[1] = 0.0;
        this.rect[0] = 0.0;
        this.tree = null;
        this.index = n;
        this.region = 0;
        this.bChanged = false;
    }

    public int getType() {
        return 6;
    }

    public void setParent(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.parent = (ToolPolylineCollection)toolPolyline2DCollection;
    }

    public ToolPolyline2DCollection getParent() {
        return this.parent;
    }

    public Object firstElement() {
        return this.first;
    }

    public Object lastElement() {
        return this.last;
    }

    public Object elementAt(int n) {
        int n2 = 0;
        K2DPathIterator k2DPathIterator = (K2DPathIterator)this.firstElement();
        K2DPathIterator k2DPathIterator2 = null;
        while (true) {
            if (n2 == n) break;
            ++n2;
            if (k2DPathIterator == this.lastElement()) {
                k2DPathIterator = (K2DPathIterator)this.firstElement();
                continue;
            }
            k2DPathIterator = (K2DPathIterator)k2DPathIterator.getNext();
        }
        k2DPathIterator2 = k2DPathIterator;
        return k2DPathIterator2;
    }

    public int size() {
        return this.N;
    }

    public int getIndex() {
        return this.index;
    }

    public void setRegion(byte by) {
        this.region = by;
    }

    public byte getRegion() {
        return this.region;
    }

    public ToolFigure2D add(int n) {
        ToolFigure toolFigure = null;
        switch (n) {
            case 1: {
                toolFigure = new ToolFigure(this, this.N);
                break;
            }
            case 2: 
            case 3: {
                toolFigure = new ToolArc(this, this.N);
            }
        }
        toolFigure.type = (byte)n;
        toolFigure.setPrev(this.last);
        if (this.first == null) {
            this.first = toolFigure;
        } else {
            ToolFigure toolFigure2 = (ToolFigure)this.last;
            toolFigure2.setNext(toolFigure);
        }
        this.last = toolFigure;
        ++this.N;
        return toolFigure;
    }

    public ToolPolyline2D addAll(ToolPolyline2D toolPolyline2D) {
        this.setFirstX(((ToolFigure2D)toolPolyline2D.firstElement()).getX1());
        this.setFirstY(((ToolFigure2D)toolPolyline2D.firstElement()).getY1());
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D != null) {
            ToolFigure toolFigure = (ToolFigure)this.add(toolFigure2D.getType());
            toolFigure.setX2(toolFigure2D.getX2());
            toolFigure.setY2(toolFigure2D.getY2());
            switch (toolFigure2D.getType()) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)toolFigure2D;
                    ToolFigure2DArc toolFigure2DArc2 = (ToolFigure2DArc)((Object)toolFigure);
                    toolFigure2DArc2.setCX(toolFigure2DArc.getCX());
                    toolFigure2DArc2.setCY(toolFigure2DArc.getCY());
                    toolFigure2DArc2.setRadius(toolFigure2DArc.getRadius());
                    break;
                }
            }
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
        }
        return null;
    }

    public boolean remove(ToolFigure2D toolFigure2D) {
        ToolFigure toolFigure = null;
        ToolFigure toolFigure2 = (ToolFigure)this.firstElement();
        ToolFigure toolFigure3 = (ToolFigure)toolFigure2.getNext();
        while (toolFigure2 != null) {
            if (toolFigure2D == toolFigure2) {
                if (toolFigure2 == this.firstElement()) {
                    this.first = toolFigure3;
                }
                if (toolFigure2 == this.lastElement()) {
                    this.last = toolFigure;
                }
                if (toolFigure != null) {
                    toolFigure.setNext(toolFigure3);
                }
                if (toolFigure3 != null) {
                    toolFigure3.setPrev(toolFigure);
                }
                --this.N;
                return true;
            }
            toolFigure = toolFigure2;
            toolFigure2 = toolFigure3;
            toolFigure3 = (ToolFigure)(toolFigure3 != null ? toolFigure3.getNext() : null);
        }
        return false;
    }

    public void removeAll() {
        ToolFigure toolFigure = (ToolFigure)this.firstElement();
        ToolFigure toolFigure2 = (ToolFigure)toolFigure.getNext();
        while (toolFigure != null) {
            toolFigure.setPrev(null);
            toolFigure.setNext(null);
            toolFigure = toolFigure2;
            toolFigure2 = (ToolFigure)(toolFigure2 != null ? toolFigure2.getNext() : null);
        }
        this.init(this.parent, this.index);
    }

    public double getLeft() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[0];
    }

    public double getRight() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[2];
    }

    public double getLower() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[1];
    }

    public double getUpper() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[3];
    }

    public void makeTree(RegionTreeBuilder regionTreeBuilder) {
        boolean bl = true;
        if (!this.bChanged) {
            return;
        }
        if (regionTreeBuilder == null) {
            regionTreeBuilder = new RegionTreeBuilder();
        }
        ToolFigure toolFigure = (ToolFigure)this.firstElement();
        while (toolFigure != null) {
            ToolFigure toolFigure2 = toolFigure;
            toolFigure2.setRect();
            regionTreeBuilder.addNodes(toolFigure);
            if (bl) {
                this.rect[0] = toolFigure.getLeft();
                this.rect[1] = toolFigure.getLower();
                this.rect[2] = toolFigure.getRight();
                this.rect[3] = toolFigure.getUpper();
            } else {
                this.rect[0] = Math.min(this.rect[0], toolFigure.getLeft());
                this.rect[1] = Math.min(this.rect[1], toolFigure.getLower());
                this.rect[2] = Math.max(this.rect[2], toolFigure.getRight());
                this.rect[3] = Math.max(this.rect[3], toolFigure.getUpper());
            }
            toolFigure = (ToolFigure)ToolGeomFigure2D.getNext(toolFigure);
            bl = false;
        }
        if (this.tree == null) {
            this.tree = new RegionTree();
        }
        regionTreeBuilder.build(this.tree);
        this.bChanged = false;
    }

    public int search(Vector vector, double d, double d2, double d3, double d4) {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        if (this.tree != null) {
            return this.tree.search(vector, d, d2, d3, d4);
        }
        return 0;
    }

    public ToolAdditData get(int n) {
        return (ToolAdditData)this.hash.get(Integer.toString(n));
    }

    public ToolAdditData put(ToolAdditData toolAdditData) {
        return this.hash.put(Integer.toString(toolAdditData.getKey()), toolAdditData);
    }

    public void setFirstX(double d) {
        this.x = d;
        this.setChangedFlag();
    }

    public void setFirstY(double d) {
        this.y = d;
        this.setChangedFlag();
    }

    public double getFirstX() {
        return this.x;
    }

    public double getFirstY() {
        return this.y;
    }

    void setChangedFlag() {
        if (this.parent != null) {
            this.parent.setChangedFlag();
        }
        this.bChanged = true;
    }
}

