/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.algebra.ToolAlgebra2DQuadratic;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolJudge2D;

public class ToolIntersectPoint2D
extends ToolJudge2D {
    public static final double TOLERANCE_DISTANCE = 1.0E-8;
    public static final double TOLERANCE = 1.0E-8;
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_1 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_2 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_3 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_4 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_5 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_6 = new ToolAlgebra2DQuadratic();

    public static int compareDistance(double d, double d2) {
        if (Math.abs(d - d2) <= 1.0E-8) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static int compare(double d, double d2) {
        if (Math.abs(d - d2) <= 1.0E-8) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static double getDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        return Math.abs(d8 * d - d7 * d2 - d8 * d3 + d7 * d4) / Math.sqrt(d7 * d7 + d8 * d8);
    }

    public static double getDistance(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static synchronized boolean getIntersectPointsExtension(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws AlgebraException {
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_1;
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_2;
        toolAlgebra2DQuadratic.linear(0.0, 0.0, d3 -= d, d4 -= d2);
        toolAlgebra2DQuadratic2.linear(d5 -= d, d6 -= d2, d7 -= d, d8 -= d2);
        if (toolAlgebra2DQuadratic.solve(toolAlgebra2DQuadratic2) == 1) {
            dArray[0] = toolAlgebra2DQuadratic.getSolutionX(0) + d;
            dArray[1] = toolAlgebra2DQuadratic.getSolutionY(0) + d2;
            return true;
        }
        return false;
    }

    public static synchronized int getIntersectPointsExtension(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7) throws AlgebraException {
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_3;
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_4;
        d -= d5;
        d2 -= d6;
        d3 -= d5;
        d4 -= d6;
        toolAlgebra2DQuadratic.linear(d /= d7, d2 /= d7, d3 /= d7, d4 /= d7);
        toolAlgebra2DQuadratic2.circle(0.0, 0.0, 1.0);
        int n = toolAlgebra2DQuadratic.solve(toolAlgebra2DQuadratic2);
        int n2 = 0;
        while (n2 < n) {
            dArray[n2 * 2] = toolAlgebra2DQuadratic.getSolutionX(n2) * d7 + d5;
            dArray[n2 * 2 + 1] = toolAlgebra2DQuadratic.getSolutionY(n2) * d7 + d6;
            ++n2;
        }
        return n;
    }

    public static synchronized int getIntersectPointsExtension(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6) {
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_5;
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_6;
        d4 -= d;
        d5 -= d2;
        toolAlgebra2DQuadratic.circle(0.0, 0.0, 1.0);
        toolAlgebra2DQuadratic2.circle(d4 /= d3, d5 /= d3, d6 /= d3);
        int n = toolAlgebra2DQuadratic.solve(toolAlgebra2DQuadratic2);
        int n2 = 0;
        while (n2 < n) {
            dArray[n2 * 2] = toolAlgebra2DQuadratic.getSolutionX(n2) * d3 + d;
            dArray[n2 * 2 + 1] = toolAlgebra2DQuadratic.getSolutionY(n2) * d3 + d2;
            ++n2;
        }
        return n;
    }

    public static synchronized boolean getIntersectPoints(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws AlgebraException {
        if (!ToolIntersectPoint2D.getIntersectPointsExtension(dArray, d, d2, d3, d4, d5, d6, d7, d8)) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(dArray[0], dArray[1], d, d2, d3, d4) && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(dArray[0], dArray[1], d5, d6, d7, d8);
    }

    public static synchronized int getIntersectPoints(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, boolean bl) throws AlgebraException {
        int n = ToolIntersectPoint2D.getIntersectPointsExtension(dArray, d, d2, d3, d4, d9, d10, d11);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(dArray[n3 * 2], dArray[n3 * 2 + 1], d, d2, d3, d4) && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(dArray[n3 * 2], dArray[n3 * 2 + 1], d5, d6, d7, d8, d9, d10, bl)) {
                if (n3 != n2) {
                    dArray[n2 * 2] = dArray[n3 * 2];
                    dArray[n2 * 2 + 1] = dArray[n3 * 2 + 1];
                }
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            double d12 = 1.0E-8;
            double d13 = ToolIntersectPoint2D.getDistance(d, d2, d9, d10);
            if (Math.abs(d13 - d11) <= d12 && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(d, d2, d5, d6, d7, d8, d9, d10, bl)) {
                dArray[n2 * 2] = d;
                dArray[n2 * 2 + 1] = d2;
                ++n2;
            }
            if (Math.abs((d13 = ToolIntersectPoint2D.getDistance(d3, d4, d9, d10)) - d11) <= d12 && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(d3, d4, d5, d6, d7, d8, d9, d10, bl) && (n2 == 0 || !ToolIntersectPoint2D.equalPoints(d3, d4, dArray[n2 * 2 - 2], dArray[n2 * 2 - 1]))) {
                dArray[n2 * 2] = d3;
                dArray[n2 * 2 + 1] = d4;
                ++n2;
            }
            if (n2 < 2 && Math.abs(d13 = ToolIntersectPoint2D.getDistance(d5, d6, d, d2, d3, d4)) <= d12 && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(d5, d6, d, d2, d3, d4) && (n2 == 0 || !ToolIntersectPoint2D.equalPoints(d5, d6, dArray[n2 * 2 - 2], dArray[n2 * 2 - 1]))) {
                dArray[n2 * 2] = d5;
                dArray[n2 * 2 + 1] = d6;
                ++n2;
            }
            if (n2 < 2 && Math.abs(d13 = ToolIntersectPoint2D.getDistance(d7, d8, d, d2, d3, d4)) <= d12 && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(d7, d8, d, d2, d3, d4) && (n2 == 0 || !ToolIntersectPoint2D.equalPoints(d7, d8, dArray[n2 * 2 - 2], dArray[n2 * 2 - 1]))) {
                dArray[n2 * 2] = d7;
                dArray[n2 * 2 + 1] = d8;
                ++n2;
            }
        }
        return n2;
    }

    public static synchronized int getIntersectPoints(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, double d8, double d9, double d10, double d11, double d12, double d13, double d14, boolean bl2) {
        int n = ToolIntersectPoint2D.getIntersectPointsExtension(dArray, d5, d6, d7, d12, d13, d14);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(dArray[n3 * 2], dArray[n3 * 2 + 1], d, d2, d3, d4, d5, d6, bl) && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(dArray[n3 * 2], dArray[n3 * 2 + 1], d8, d9, d10, d11, d12, d13, bl2)) {
                if (n3 != n2) {
                    dArray[n2 * 2] = dArray[n3 * 2];
                    dArray[n2 * 2 + 1] = dArray[n3 * 2 + 1];
                }
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static synchronized boolean checkPointOnWithoutDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = new double[2];
        ToolGeom2D.getPerpendicularPoint(dArray, d, d2, d3, d4, d5, d6);
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(dArray[0], dArray[1], d3, d4, d5, d6);
    }

    public static boolean checkPointOnWithoutDistance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        double[] dArray = new double[2];
        double d9 = ToolGeom2D.getRadius(d3, d4, d5, d6, d7, d8);
        ToolGeom2D.getPerpendicularPoint(dArray, d, d2, d3, d4, d5, d6, d7, d8, d9, bl);
        return ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(dArray[0], dArray[1], d3, d4, d5, d6, d7, d8, bl);
    }

    public static synchronized boolean checkPointOnLinearWithoutDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        return ToolIntersectPoint2D.compareDistance(d, Math.min(d3, d5)) != -1 && ToolIntersectPoint2D.compareDistance(Math.max(d3, d5), d) != -1 && ToolIntersectPoint2D.compareDistance(d2, Math.min(d4, d6)) != -1 && ToolIntersectPoint2D.compareDistance(Math.max(d4, d6), d2) != -1;
    }

    public static boolean checkPointOnCircleWithoutDistance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        d3 -= d7;
        d4 -= d8;
        d5 -= d7;
        d6 -= d8;
        d -= d7;
        d2 -= d8;
        d7 = 0.0;
        d8 = 0.0;
        byte by = ToolIntersectPoint2D.getSideOfPointWithLine(d, d2, d3, d4, d5, d6);
        if (by == 0) {
            return true;
        }
        return by == 3 || by == 1 && !bl || by == 2 && bl;
    }

    public static synchronized boolean checkPointOn(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ToolIntersectPoint2D.getDistance(d, d2, d3, d4, d5, d6);
        if (ToolIntersectPoint2D.compareDistance(d7, 0.0) != 0) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(d, d2, d3, d4, d5, d6);
    }

    public static synchronized boolean checkPointOn(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        double d10 = ToolIntersectPoint2D.getDistance(d, d2, d7, d8);
        if (ToolIntersectPoint2D.compareDistance(d10, d9) != 0) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(d, d2, d3, d4, d5, d6, d7, d8, bl);
    }
}

